/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.locking;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.ojb.broker.locking.LockManager;
import org.apache.ojb.broker.locking.LockManagerRemoteImpl;
import org.apache.ojb.broker.locking.LockRuntimeException;
import org.apache.ojb.broker.util.ClassHelper;

public class LockManagerServlet
extends HttpServlet {
    protected static LockManager lockmanager;
    static final String STR_LOCK_TIMEOUT = "lockTimeout";
    static final String STR_BLOCK_TIMEOUT = "blockTimeout";
    static final String STR_LOCK_MANAGER = "lockManager";
    private static long numRequests;
    private static Throwable lastError;
    static /* synthetic */ Class class$org$apache$ojb$broker$locking$LockManagerInMemoryImpl;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        if (lockmanager == null) {
            Object object;
            lastError = null;
            numRequests = 0L;
            String string = servletConfig.getInitParameter(STR_LOCK_MANAGER);
            try {
                lockmanager = (LockManager)(string != null ? ClassHelper.newInstance(string) : ClassHelper.newInstance(class$org$apache$ojb$broker$locking$LockManagerInMemoryImpl == null ? (class$org$apache$ojb$broker$locking$LockManagerInMemoryImpl = LockManagerServlet.class$("org.apache.ojb.broker.locking.LockManagerInMemoryImpl")) : class$org$apache$ojb$broker$locking$LockManagerInMemoryImpl));
            }
            catch (Exception exception) {
                lastError = new LockRuntimeException("Can't instance lock manager, init parameter 'lockManager': " + string);
                exception.printStackTrace();
            }
            String string2 = servletConfig.getInitParameter(STR_LOCK_TIMEOUT);
            if (NumberUtils.isNumber((String)string2)) {
                try {
                    object = NumberUtils.createLong((String)string2);
                    lockmanager.setLockTimeout((Long)object);
                }
                catch (Exception exception) {
                    if (lastError == null) {
                        lastError = new LockRuntimeException("Can't convert 'lockTimeout' init parameter: " + string2);
                    }
                    exception.printStackTrace();
                }
            }
            if (NumberUtils.isNumber((String)(object = servletConfig.getInitParameter(STR_BLOCK_TIMEOUT)))) {
                try {
                    Long l = NumberUtils.createLong((String)object);
                    lockmanager.setLockTimeout(l);
                }
                catch (Exception exception) {
                    if (lastError == null) {
                        lastError = new LockRuntimeException("Can't convert 'blockTimeout' init parameter: " + (String)object);
                    }
                    exception.printStackTrace();
                }
            }
        }
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setContentType("text/html");
        httpServletResponse.setHeader("Pragma", "no-cache");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<html><head><title>OJB Distributed Locking Servlet Status Page</title>");
        printWriter.println("</head><body><h1>OJB Distributed Locking Servlet</h1>");
        printWriter.println("The servlet is running.<p>");
        if (lastError == null) {
            printWriter.println("The LockServer is running.<p>");
            printWriter.println("LockManager info: " + lockmanager.getLockInfo() + "<p>");
            printWriter.println("Processed Lock Request: " + numRequests + "<p>");
        } else {
            printWriter.println("<h2>The LockServer has a problem!</h2>");
            printWriter.println("The error message is:<p>");
            printWriter.println(lastError.getMessage() + "<p>");
            lastError.printStackTrace(printWriter);
            lastError = null;
        }
        printWriter.println("</body></html>");
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ++numRequests;
        try {
            LockManagerRemoteImpl.LockInfo lockInfo = (LockManagerRemoteImpl.LockInfo)this.buildObjectFromRequest(httpServletRequest);
            Object object = null;
            try {
                switch (lockInfo.methodName) {
                    case 97: {
                        object = new Boolean(lockmanager.readLock(lockInfo.key, lockInfo.resourceId, lockInfo.isolationLevel));
                        break;
                    }
                    case 101: {
                        object = new Boolean(lockmanager.releaseLock(lockInfo.key, lockInfo.resourceId));
                        break;
                    }
                    case 120: {
                        lockmanager.releaseLocks(lockInfo.key);
                        object = Boolean.TRUE;
                        break;
                    }
                    case 115: {
                        object = new Boolean(lockmanager.writeLock(lockInfo.key, lockInfo.resourceId, lockInfo.isolationLevel));
                        break;
                    }
                    case 117: {
                        object = new Boolean(lockmanager.upgradeLock(lockInfo.key, lockInfo.resourceId, lockInfo.isolationLevel));
                        break;
                    }
                    case 114: {
                        object = new Boolean(lockmanager.hasRead(lockInfo.key, lockInfo.resourceId));
                        break;
                    }
                    case 119: {
                        object = new Boolean(lockmanager.hasWrite(lockInfo.key, lockInfo.resourceId));
                        break;
                    }
                    case 118: {
                        object = new Boolean(lockmanager.hasUpgrade(lockInfo.key, lockInfo.resourceId));
                        break;
                    }
                    case 105: {
                        object = lockmanager.getLockInfo();
                        break;
                    }
                    case 116: {
                        object = new Long(lockmanager.getLockTimeout());
                        break;
                    }
                    case 99: {
                        object = new Long(lockmanager.getBlockTimeout());
                        break;
                    }
                    default: {
                        throw new LockRuntimeException("Unknown command:" + lockInfo.methodName);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                object = new LockRuntimeException("Error while invoke specified method in servlet.", runtimeException);
            }
            ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)httpServletResponse.getOutputStream());
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Throwable throwable) {
            lastError = throwable;
            throwable.printStackTrace();
        }
    }

    private Object buildObjectFromRequest(HttpServletRequest httpServletRequest) throws IOException, ClassNotFoundException {
        Object object = null;
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)servletInputStream);
        object = objectInputStream.readObject();
        objectInputStream.close();
        servletInputStream.close();
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        lastError = null;
    }
}

