/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.core.proxy.CollectionProxy;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.OJBProxy;
import org.apache.ojb.broker.core.proxy.ProxyConfiguration;
import org.apache.ojb.broker.core.proxy.ProxyFactory;
import org.apache.ojb.broker.core.proxy.VirtualProxy;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public abstract class AbstractProxyFactory
implements ProxyFactory {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$core$proxy$AbstractProxyFactory == null ? (class$org$apache$ojb$broker$core$proxy$AbstractProxyFactory = AbstractProxyFactory.class$("org.apache.ojb.broker.core.proxy.AbstractProxyFactory")) : class$org$apache$ojb$broker$core$proxy$AbstractProxyFactory);
    private static transient ProxyFactory singleton;
    private Class _indirectionHandlerClass;
    private transient Constructor _indirectionHandlerConstructor;
    private Constructor _listProxyConstructor;
    private Constructor _setProxyConstructor;
    private Constructor _collectionProxyConstructor;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$proxy$AbstractProxyFactory;
    static /* synthetic */ Class class$org$apache$ojb$broker$PBKey;
    static /* synthetic */ Class class$org$apache$ojb$broker$Identity;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$org$apache$ojb$broker$query$Query;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$org$apache$ojb$broker$ManageableCollection;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$proxy$IndirectionHandler;

    private static ProxyConfiguration getProxyConfiguration() {
        return (ProxyConfiguration)((Object)OjbConfigurator.getInstance().getConfigurationFor(null));
    }

    private synchronized Constructor getIndirectionHandlerConstructor() {
        if (this._indirectionHandlerConstructor == null) {
            Class[] classArray = new Class[]{class$org$apache$ojb$broker$PBKey == null ? (class$org$apache$ojb$broker$PBKey = AbstractProxyFactory.class$("org.apache.ojb.broker.PBKey")) : class$org$apache$ojb$broker$PBKey, class$org$apache$ojb$broker$Identity == null ? (class$org$apache$ojb$broker$Identity = AbstractProxyFactory.class$("org.apache.ojb.broker.Identity")) : class$org$apache$ojb$broker$Identity};
            try {
                this._indirectionHandlerConstructor = this.getIndirectionHandlerClass().getConstructor(classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new MetadataException("The class " + this._indirectionHandlerClass.getName() + " specified for IndirectionHandlerClass" + " is required to have a public constructor with signature (" + (class$org$apache$ojb$broker$PBKey == null ? (class$org$apache$ojb$broker$PBKey = AbstractProxyFactory.class$("org.apache.ojb.broker.PBKey")) : class$org$apache$ojb$broker$PBKey).getName() + ", " + (class$org$apache$ojb$broker$Identity == null ? (class$org$apache$ojb$broker$Identity = AbstractProxyFactory.class$("org.apache.ojb.broker.Identity")) : class$org$apache$ojb$broker$Identity).getName() + ").");
            }
        }
        return this._indirectionHandlerConstructor;
    }

    public Class getIndirectionHandlerClass() {
        if (this._indirectionHandlerClass == null) {
            this.setIndirectionHandlerClass(AbstractProxyFactory.getProxyConfiguration().getIndirectionHandlerClass());
        }
        return this._indirectionHandlerClass;
    }

    public void setIndirectionHandlerClass(Class clazz) {
        if (clazz == null) {
            clazz = this.getDefaultIndirectionHandlerClass();
        }
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers()) || !this.getIndirectionHandlerBaseClass().isAssignableFrom(clazz)) {
            throw new MetadataException("Illegal class " + clazz.getName() + " specified for IndirectionHandlerClass. Must be a concrete subclass of " + this.getIndirectionHandlerBaseClass().getName());
        }
        this._indirectionHandlerClass = clazz;
    }

    public IndirectionHandler createIndirectionHandler(PBKey pBKey, Identity identity) {
        Object[] objectArray = new Object[]{pBKey, identity};
        try {
            return (IndirectionHandler)this.getIndirectionHandlerConstructor().newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new PersistenceBrokerException("Exception while creating a new indirection handler instance", invocationTargetException);
        }
        catch (InstantiationException instantiationException) {
            throw new PersistenceBrokerException("Exception while creating a new indirection handler instance", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PersistenceBrokerException("Exception while creating a new indirection handler instance", illegalAccessException);
        }
    }

    private static Constructor retrieveCollectionProxyConstructor(Class clazz, Class clazz2, String string) {
        if (clazz == null) {
            throw new MetadataException("No " + string + " specified.");
        }
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers()) || !clazz2.isAssignableFrom(clazz)) {
            throw new MetadataException("Illegal class " + clazz.getName() + " specified for " + string + ". Must be a concrete subclass of " + clazz2.getName());
        }
        Class[] classArray = new Class[]{class$org$apache$ojb$broker$PBKey == null ? (class$org$apache$ojb$broker$PBKey = AbstractProxyFactory.class$("org.apache.ojb.broker.PBKey")) : class$org$apache$ojb$broker$PBKey, class$java$lang$Class == null ? (class$java$lang$Class = AbstractProxyFactory.class$("java.lang.Class")) : class$java$lang$Class, class$org$apache$ojb$broker$query$Query == null ? (class$org$apache$ojb$broker$query$Query = AbstractProxyFactory.class$("org.apache.ojb.broker.query.Query")) : class$org$apache$ojb$broker$query$Query};
        try {
            return clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new MetadataException("The class " + clazz.getName() + " specified for " + string + " is required to have a public constructor with signature (" + (class$org$apache$ojb$broker$PBKey == null ? (class$org$apache$ojb$broker$PBKey = AbstractProxyFactory.class$("org.apache.ojb.broker.PBKey")) : class$org$apache$ojb$broker$PBKey).getName() + ", " + (class$java$lang$Class == null ? (class$java$lang$Class = AbstractProxyFactory.class$("java.lang.Class")) : class$java$lang$Class).getName() + ", " + (class$org$apache$ojb$broker$query$Query == null ? (class$org$apache$ojb$broker$query$Query = AbstractProxyFactory.class$("org.apache.ojb.broker.query.Query")) : class$org$apache$ojb$broker$query$Query).getName() + ").");
        }
    }

    public Class getListProxyClass() {
        return this.getListProxyConstructor().getDeclaringClass();
    }

    private Constructor getListProxyConstructor() {
        if (this._listProxyConstructor == null) {
            this.setListProxyClass(AbstractProxyFactory.getProxyConfiguration().getListProxyClass());
        }
        return this._listProxyConstructor;
    }

    public void setListProxyClass(Class clazz) {
        this._listProxyConstructor = AbstractProxyFactory.retrieveCollectionProxyConstructor(clazz, class$java$util$List == null ? (class$java$util$List = AbstractProxyFactory.class$("java.util.List")) : class$java$util$List, "ListProxyClass");
    }

    public Class getSetProxyClass() {
        return this.getSetProxyConstructor().getDeclaringClass();
    }

    private Constructor getSetProxyConstructor() {
        if (this._setProxyConstructor == null) {
            this.setSetProxyClass(AbstractProxyFactory.getProxyConfiguration().getSetProxyClass());
        }
        return this._setProxyConstructor;
    }

    public void setSetProxyClass(Class clazz) {
        this._setProxyConstructor = AbstractProxyFactory.retrieveCollectionProxyConstructor(clazz, class$java$util$Set == null ? (class$java$util$Set = AbstractProxyFactory.class$("java.util.Set")) : class$java$util$Set, "SetProxyClass");
    }

    public Class getCollectionProxyClass() {
        return this.getCollectionProxyConstructor().getDeclaringClass();
    }

    private Constructor getCollectionProxyConstructor() {
        if (this._collectionProxyConstructor == null) {
            this.setCollectionProxyClass(AbstractProxyFactory.getProxyConfiguration().getCollectionProxyClass());
        }
        return this._collectionProxyConstructor;
    }

    public void setCollectionProxyClass(Class clazz) {
        this._collectionProxyConstructor = AbstractProxyFactory.retrieveCollectionProxyConstructor(clazz, class$java$util$Collection == null ? (class$java$util$Collection = AbstractProxyFactory.class$("java.util.Collection")) : class$java$util$Collection, "CollectionProxyClass");
        if (!(class$org$apache$ojb$broker$ManageableCollection == null ? (class$org$apache$ojb$broker$ManageableCollection = AbstractProxyFactory.class$("org.apache.ojb.broker.ManageableCollection")) : class$org$apache$ojb$broker$ManageableCollection).isAssignableFrom(clazz)) {
            throw new MetadataException("Illegal class " + clazz.getName() + " specified for CollectionProxyClass. Must be a concrete subclass of " + (class$org$apache$ojb$broker$ManageableCollection == null ? (class$org$apache$ojb$broker$ManageableCollection = AbstractProxyFactory.class$("org.apache.ojb.broker.ManageableCollection")) : class$org$apache$ojb$broker$ManageableCollection).getName());
        }
    }

    private Constructor getCollectionProxyConstructor(Class clazz) {
        if ((class$java$util$List == null ? (class$java$util$List = AbstractProxyFactory.class$("java.util.List")) : class$java$util$List).isAssignableFrom(clazz)) {
            return this.getListProxyConstructor();
        }
        if ((class$java$util$Set == null ? (class$java$util$Set = AbstractProxyFactory.class$("java.util.Set")) : class$java$util$Set).isAssignableFrom(clazz)) {
            return this.getSetProxyConstructor();
        }
        return this.getCollectionProxyConstructor();
    }

    public ManageableCollection createCollectionProxy(PBKey pBKey, Query query, Class clazz) {
        Object[] objectArray = new Object[]{pBKey, clazz, query};
        try {
            return (ManageableCollection)this.getCollectionProxyConstructor(clazz).newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
            throw new PersistenceBrokerException("Exception while creating a new collection proxy instance", instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new PersistenceBrokerException("Exception while creating a new collection proxy instance", invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PersistenceBrokerException("Exception while creating a new collection proxy instance", illegalAccessException);
        }
    }

    public final Object getRealObject(Object object) {
        if (this.isNormalOjbProxy(object)) {
            try {
                return this.getIndirectionHandler(object).getRealSubject();
            }
            catch (ClassCastException classCastException) {
                String string = "The InvocationHandler for the provided Proxy was not an instance of " + (class$org$apache$ojb$broker$core$proxy$IndirectionHandler == null ? (class$org$apache$ojb$broker$core$proxy$IndirectionHandler = AbstractProxyFactory.class$("org.apache.ojb.broker.core.proxy.IndirectionHandler")) : class$org$apache$ojb$broker$core$proxy$IndirectionHandler).getName();
                log.error(string);
                throw new PersistenceBrokerException(string, classCastException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string = "Could not retrieve real object for given Proxy: " + object;
                log.error(string);
                throw new PersistenceBrokerException(string, illegalArgumentException);
            }
            catch (PersistenceBrokerException persistenceBrokerException) {
                log.error("Could not retrieve real object for given Proxy: " + object);
                throw persistenceBrokerException;
            }
        }
        if (this.isVirtualOjbProxy(object)) {
            try {
                return ((VirtualProxy)object).getRealSubject();
            }
            catch (PersistenceBrokerException persistenceBrokerException) {
                log.error("Could not retrieve real object for VirtualProxy: " + object);
                throw persistenceBrokerException;
            }
        }
        return object;
    }

    public Object getRealObjectIfMaterialized(Object object) {
        if (this.isNormalOjbProxy(object)) {
            try {
                IndirectionHandler indirectionHandler = this.getIndirectionHandler(object);
                return indirectionHandler.alreadyMaterialized() ? indirectionHandler.getRealSubject() : null;
            }
            catch (ClassCastException classCastException) {
                String string = "The InvocationHandler for the provided Proxy was not an instance of " + (class$org$apache$ojb$broker$core$proxy$IndirectionHandler == null ? (class$org$apache$ojb$broker$core$proxy$IndirectionHandler = AbstractProxyFactory.class$("org.apache.ojb.broker.core.proxy.IndirectionHandler")) : class$org$apache$ojb$broker$core$proxy$IndirectionHandler).getName();
                log.error(string);
                throw new PersistenceBrokerException(string, classCastException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string = "Could not retrieve real object for given Proxy: " + object;
                log.error(string);
                throw new PersistenceBrokerException(string, illegalArgumentException);
            }
            catch (PersistenceBrokerException persistenceBrokerException) {
                log.error("Could not retrieve real object for given Proxy: " + object);
                throw persistenceBrokerException;
            }
        }
        if (this.isVirtualOjbProxy(object)) {
            try {
                VirtualProxy virtualProxy = (VirtualProxy)object;
                return virtualProxy.alreadyMaterialized() ? virtualProxy.getRealSubject() : null;
            }
            catch (PersistenceBrokerException persistenceBrokerException) {
                log.error("Could not retrieve real object for VirtualProxy: " + object);
                throw persistenceBrokerException;
            }
        }
        return object;
    }

    public Class getRealClass(Object object) {
        if (this.isNormalOjbProxy(object)) {
            try {
                IndirectionHandler indirectionHandler = this.getIndirectionHandler(object);
                return indirectionHandler.getIdentity().getObjectsRealClass();
            }
            catch (ClassCastException classCastException) {
                String string = "The InvocationHandler for the provided Proxy was not an instance of " + (class$org$apache$ojb$broker$core$proxy$IndirectionHandler == null ? (class$org$apache$ojb$broker$core$proxy$IndirectionHandler = AbstractProxyFactory.class$("org.apache.ojb.broker.core.proxy.IndirectionHandler")) : class$org$apache$ojb$broker$core$proxy$IndirectionHandler).getName();
                log.error(string);
                throw new PersistenceBrokerException(string, classCastException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string = "Could not retrieve real object for given Proxy: " + object;
                log.error(string);
                throw new PersistenceBrokerException(string, illegalArgumentException);
            }
        }
        if (this.isVirtualOjbProxy(object)) {
            IndirectionHandler indirectionHandler = VirtualProxy.getIndirectionHandler((VirtualProxy)object);
            return indirectionHandler.getIdentity().getObjectsRealClass();
        }
        return object.getClass();
    }

    public boolean isNormalOjbProxy(Object object) {
        return object instanceof OJBProxy;
    }

    public boolean isVirtualOjbProxy(Object object) {
        return object instanceof VirtualProxy;
    }

    public boolean isProxy(Object object) {
        return this.isNormalOjbProxy(object) || this.isVirtualOjbProxy(object);
    }

    protected abstract IndirectionHandler getDynamicIndirectionHandler(Object var1);

    public IndirectionHandler getIndirectionHandler(Object object) {
        if (object == null) {
            return null;
        }
        if (this.isNormalOjbProxy(object)) {
            return this.getDynamicIndirectionHandler(object);
        }
        if (this.isVirtualOjbProxy(object)) {
            return VirtualProxy.getIndirectionHandler((VirtualProxy)object);
        }
        return null;
    }

    public boolean isMaterialized(Object object) {
        IndirectionHandler indirectionHandler = this.getIndirectionHandler(object);
        return indirectionHandler == null || indirectionHandler.alreadyMaterialized();
    }

    public CollectionProxy getCollectionProxy(Object object) {
        if (this.isCollectionProxy(object)) {
            return (CollectionProxy)object;
        }
        return null;
    }

    public boolean isCollectionProxy(Object object) {
        return object instanceof CollectionProxy;
    }

    public String toString(Object object) {
        IndirectionHandler indirectionHandler = this.getIndirectionHandler(object);
        if (indirectionHandler != null && indirectionHandler.alreadyMaterialized()) {
            return "unmaterialized proxy for " + indirectionHandler.getIdentity();
        }
        return object.toString();
    }

    public static synchronized ProxyFactory getProxyFactory() {
        if (singleton == null) {
            Class clazz = null;
            try {
                clazz = AbstractProxyFactory.getProxyConfiguration().getProxyFactoryClass();
                singleton = (ProxyFactory)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new MetadataException("Illegal class " + clazz.getName() + " specified for ProxyFactoryClass.");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new MetadataException("Illegal class " + clazz.getName() + " specified for ProxyFactoryClass.");
            }
        }
        return singleton;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

