/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.ObjectCache;

public class ObjectCacheLocalDefaultImpl
implements ObjectCache {
    private static final String TIMEOUT = "timeout";
    protected Map objectTable = new HashMap();
    private long timeout = 900000L;

    public ObjectCacheLocalDefaultImpl(PersistenceBroker persistenceBroker, Properties properties) {
        this.timeout = properties == null ? this.timeout : Long.parseLong(properties.getProperty(TIMEOUT, "" + this.timeout)) * 1000L;
    }

    public void clear() {
        this.objectTable.clear();
    }

    public void cache(Identity identity, Object object) {
        if (object != null) {
            SoftReference<CacheEntry> softReference = new SoftReference<CacheEntry>(new CacheEntry(object));
            this.objectTable.put(identity, softReference);
        }
    }

    public boolean cacheIfNew(Identity identity, Object object) {
        if (this.objectTable.get(identity) == null) {
            this.cache(identity, object);
            return true;
        }
        return false;
    }

    public Object lookup(Identity identity) {
        CacheEntry cacheEntry = null;
        SoftReference softReference = (SoftReference)this.objectTable.get(identity);
        if (softReference != null && ((cacheEntry = (CacheEntry)softReference.get()) == null || cacheEntry.lifetime < System.currentTimeMillis())) {
            this.objectTable.remove(identity);
            cacheEntry = null;
        }
        return cacheEntry != null ? cacheEntry.object : null;
    }

    public void remove(Identity identity) {
        if (identity != null) {
            this.objectTable.remove(identity);
        }
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE);
        toStringBuilder.append("Count of cached objects", this.objectTable.keySet().size());
        return toStringBuilder.toString();
    }

    class CacheEntry {
        long lifetime;
        Object object;

        public CacheEntry(Object object) {
            this.object = object;
            this.lifetime = System.currentTimeMillis() + ObjectCacheLocalDefaultImpl.this.timeout;
        }
    }
}

