/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.cache.CacheDistributor;
import org.apache.ojb.broker.cache.ObjectCacheInternal;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class MaterializationCache
implements ObjectCacheInternal {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$cache$MaterializationCache == null ? (class$org$apache$ojb$broker$cache$MaterializationCache = MaterializationCache.class$("org.apache.ojb.broker.cache.MaterializationCache")) : class$org$apache$ojb$broker$cache$MaterializationCache);
    private CacheDistributor cacheDistributor;
    private HashMap objectBuffer;
    private boolean enabledReadCache;
    private int invokeCounter;
    static /* synthetic */ Class class$org$apache$ojb$broker$cache$MaterializationCache;

    MaterializationCache(CacheDistributor cacheDistributor) {
        this.cacheDistributor = cacheDistributor;
        this.objectBuffer = new HashMap();
        this.enabledReadCache = false;
    }

    public boolean isEnabledMaterialisationCache() {
        return this.enabledReadCache;
    }

    public void enableMaterializationCache() {
        ++this.invokeCounter;
        this.enabledReadCache = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableMaterializationCache() {
        if (!this.enabledReadCache) {
            return;
        }
        --this.invokeCounter;
        if (this.invokeCounter == 0) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Materialisation of object is finished, push " + this.objectBuffer.size() + "objects to cache");
                }
                this.pushObjects();
            }
            finally {
                this.doLocalClear();
            }
        }
    }

    public void doInternalCache(Identity identity, Object object, int n) {
        if (this.enabledReadCache) {
            this.doLocalCache(identity, object, n);
        } else {
            this.cacheDistributor.doInternalCache(identity, object, n);
        }
    }

    public void cache(Identity identity, Object object) {
        this.doInternalCache(identity, object, 0);
    }

    public boolean cacheIfNew(Identity identity, Object object) {
        boolean bl = this.cacheDistributor.cacheIfNew(identity, object);
        if (this.enabledReadCache) {
            this.doLocalCache(identity, object, 7);
        }
        return bl;
    }

    public Object lookup(Identity identity) {
        Object object = null;
        if (this.enabledReadCache) {
            object = this.doLocalLookup(identity);
        }
        if (object == null) {
            object = this.cacheDistributor.lookup(identity);
        }
        return object;
    }

    public Object doLocalLookup(Identity identity) {
        ObjectEntry objectEntry = (ObjectEntry)this.objectBuffer.get(identity);
        return objectEntry != null ? objectEntry.obj : null;
    }

    public void remove(Identity identity) {
        this.doLocalRemove(identity);
        this.cacheDistributor.remove(identity);
    }

    public void doLocalRemove(Identity identity) {
        this.objectBuffer.remove(identity);
    }

    public void doLocalClear() {
        if (log.isDebugEnabled()) {
            log.debug("Clear materialization cache");
        }
        this.invokeCounter = 0;
        this.enabledReadCache = false;
        this.objectBuffer.clear();
    }

    public void clear() {
        if (log.isDebugEnabled()) {
            log.debug("Clear used caches");
        }
        this.doLocalClear();
        this.cacheDistributor.clear();
    }

    private void doLocalCache(Identity identity, Object object, int n) {
        this.objectBuffer.put(identity, new ObjectEntry(object, n));
    }

    private void pushObjects() {
        Iterator iterator = this.objectBuffer.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ObjectEntry objectEntry = (ObjectEntry)entry.getValue();
            if (objectEntry.type == -1) continue;
            if (log.isDebugEnabled()) {
                log.debug("Push to cache: " + entry.getKey());
            }
            this.cacheDistributor.doInternalCache((Identity)entry.getKey(), objectEntry.obj, objectEntry.type);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static final class ObjectEntry {
        Object obj;
        int type;

        public ObjectEntry(Object object, int n) {
            this.obj = object;
            this.type = n;
        }
    }
}

