/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.ant;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.apache.ddlutils.io.DatabaseIO;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.task.DatabaseTaskBase;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.ant.Command;
import org.apache.ojb.broker.ant.WriteDataSqlToFileCommand;
import org.apache.ojb.broker.ant.WriteDataToDatabaseCommand;
import org.apache.ojb.broker.ant.WriteDtdToFileCommand;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.metadata.RepositoryPersistor;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class RepositoryDataTask
extends DatabaseTaskBase {
    private ArrayList _commands = new ArrayList();
    private String _jcdAlias;
    private File _ojbPropertiesFile;
    private File _repositoryFile;
    private File _singleSchemaFile = null;
    private ArrayList _fileSets = new ArrayList();
    private boolean _useInternalDtd = true;

    public void setJcdAlias(String string) {
        this._jcdAlias = string;
    }

    public String getJcdAlias() {
        return this._jcdAlias;
    }

    public File getOjbPropertiesFile() {
        return this._ojbPropertiesFile;
    }

    public void setOjbPropertiesFile(File file) {
        this._ojbPropertiesFile = file;
    }

    public File getRepositoryFile() {
        return this._repositoryFile;
    }

    public void setRepositoryFile(File file) {
        this._repositoryFile = file;
    }

    public void setUseInternalDtd(boolean bl) {
        this._useInternalDtd = bl;
    }

    public void addConfiguredFileset(FileSet fileSet) {
        this._fileSets.add(fileSet);
    }

    public void setSchemaFile(File file) {
        this._singleSchemaFile = file;
    }

    public void addWriteDtdToFile(WriteDtdToFileCommand writeDtdToFileCommand) {
        this._commands.add(writeDtdToFileCommand);
    }

    public void addWriteDataToDatabase(WriteDataToDatabaseCommand writeDataToDatabaseCommand) {
        this._commands.add(writeDataToDatabaseCommand);
    }

    public void addWriteDataSqlToFile(WriteDataSqlToFileCommand writeDataSqlToFileCommand) {
        this._commands.add(writeDataSqlToFileCommand);
    }

    protected Database readModel() {
        DatabaseIO databaseIO = new DatabaseIO();
        Database database = null;
        databaseIO.setUseInternalDtd(this._useInternalDtd);
        if (this._singleSchemaFile != null && !this._fileSets.isEmpty()) {
            throw new BuildException("Please use either the schemafile attribute or the sub fileset element, but not both");
        }
        if (this._singleSchemaFile != null) {
            database = this.readSingleSchemaFile(databaseIO, this._singleSchemaFile);
        } else {
            Iterator iterator = this._fileSets.iterator();
            while (iterator.hasNext()) {
                FileSet fileSet = (FileSet)iterator.next();
                File file = fileSet.getDir(this.getProject());
                DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
                String[] stringArray = directoryScanner.getIncludedFiles();
                for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                    Database database2 = this.readSingleSchemaFile(databaseIO, new File(file, stringArray[i]));
                    if (database == null) {
                        database = database2;
                        continue;
                    }
                    if (database2 == null) continue;
                    try {
                        database.mergeWith(database2);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new BuildException("Could not merge with schema from file " + stringArray[i] + ": " + illegalArgumentException.getLocalizedMessage(), (Throwable)illegalArgumentException);
                    }
                }
            }
        }
        return database;
    }

    private Database readSingleSchemaFile(DatabaseIO databaseIO, File file) {
        Database database = null;
        if (!file.isFile()) {
            this.log("Path " + file.getAbsolutePath() + " does not denote a schema file", 0);
        } else if (!file.canRead()) {
            this.log("Could not read schema file " + file.getAbsolutePath(), 0);
        } else {
            try {
                database = databaseIO.read(file);
                this.log("Read schema file " + file.getAbsolutePath(), 2);
            }
            catch (Exception exception) {
                throw new BuildException("Could not read schema file " + file.getAbsolutePath() + ": " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        return database;
    }

    private MetadataManager initOJB() {
        try {
            Object object;
            Object object2;
            if (this._ojbPropertiesFile == null) {
                this._ojbPropertiesFile = new File("OJB.properties");
                if (!this._ojbPropertiesFile.exists()) {
                    throw new BuildException("Could not find OJB.properties, please specify it via the ojbpropertiesfile attribute");
                }
            } else {
                if (!this._ojbPropertiesFile.exists()) {
                    throw new BuildException("Could not load the specified OJB properties file " + this._ojbPropertiesFile);
                }
                this.log("Using properties file " + this._ojbPropertiesFile.getAbsolutePath(), 2);
                System.setProperty("OJB.properties", this._ojbPropertiesFile.getAbsolutePath());
            }
            MetadataManager metadataManager = MetadataManager.getInstance();
            RepositoryPersistor repositoryPersistor = new RepositoryPersistor();
            if (this._repositoryFile != null) {
                if (!this._repositoryFile.exists()) {
                    throw new BuildException("Could not load the specified repository file " + this._repositoryFile);
                }
                this.log("Loading repository file " + this._repositoryFile.getAbsolutePath(), 2);
                metadataManager.mergeConnectionRepository(repositoryPersistor.readConnectionRepository(this._repositoryFile.getAbsolutePath()));
                metadataManager.mergeDescriptorRepository(repositoryPersistor.readDescriptorRepository(this._repositoryFile.getAbsolutePath()));
            } else if (metadataManager.connectionRepository().getAllDescriptor().isEmpty() && metadataManager.getGlobalRepository().getDescriptorTable().isEmpty()) {
                object2 = new Properties();
                ((Properties)object2).load(new FileInputStream(this._ojbPropertiesFile));
                object = ((Properties)object2).getProperty("repositoryFile", "repository.xml");
                File file = new File((String)object);
                if (!file.exists()) {
                    file = new File(this._ojbPropertiesFile.getParentFile(), (String)object);
                }
                metadataManager.mergeConnectionRepository(repositoryPersistor.readConnectionRepository(file.getAbsolutePath()));
                metadataManager.mergeDescriptorRepository(repositoryPersistor.readDescriptorRepository(file.getAbsolutePath()));
            }
            if (metadataManager.getDefaultPBKey() == null) {
                object2 = metadataManager.connectionRepository().getAllDescriptor().iterator();
                while (object2.hasNext()) {
                    object = (JdbcConnectionDescriptor)object2.next();
                    if (!((JdbcConnectionDescriptor)object).isDefaultConnection()) continue;
                    metadataManager.setDefaultPBKey(new PBKey(((JdbcConnectionDescriptor)object).getJcdAlias(), ((JdbcConnectionDescriptor)object).getUserName(), ((JdbcConnectionDescriptor)object).getPassWord()));
                    break;
                }
            }
            return metadataManager;
        }
        catch (Exception exception) {
            if (exception instanceof BuildException) {
                throw (BuildException)exception;
            }
            throw new BuildException((Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this._commands.isEmpty()) {
            this.log("No sub tasks specified, so there is nothing to do.", 2);
            return;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        AntClassLoader antClassLoader = new AntClassLoader(((Object)((Object)this)).getClass().getClassLoader(), true);
        Thread.currentThread().setContextClassLoader((ClassLoader)antClassLoader);
        try {
            MetadataManager metadataManager = this.initOJB();
            Database database = this.readModel();
            DescriptorRepository descriptorRepository = metadataManager.getGlobalRepository();
            if (database == null) {
                throw new BuildException("No database model specified");
            }
            Iterator iterator = this._commands.iterator();
            while (iterator.hasNext()) {
                Command command = (Command)iterator.next();
                command.setPlatform(this.getPlatform());
                command.execute((Task)this, database, descriptorRepository);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }
}

