/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.ant;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Wrapper;
import java.util.Hashtable;

public class DBUtility {
    private Connection m_connection = null;
    private String m_url = null;
    private String m_user = null;
    private String m_pwd = null;
    private static String m_ORA_EXCEPTION_1000 = "ORA-01000";
    private static String m_ORA_EXCEPTION_604 = "ORA-00604";
    private Hashtable m_columnCache = new Hashtable(79);

    public DBUtility(String string, String string2, String string3) throws SQLException {
        this.m_url = string;
        this.m_user = string2;
        this.m_pwd = string3;
        this.m_connection = this.connect(string, string2, string3);
    }

    public void release() throws SQLException {
        if (this.m_connection != null) {
            this.m_connection.close();
        }
    }

    private void resetConnection() {
        try {
            this.release();
            this.connect(this.m_url, this.m_user, this.m_pwd);
        }
        catch (Exception exception) {
            System.out.println("Could not reconnect to database!!!! " + exception.getMessage());
        }
    }

    private Connection connect(String string, String string2, String string3) throws SQLException {
        this.m_connection = DriverManager.getConnection(string, string2, string3);
        return this.m_connection;
    }

    public boolean exists(String string) {
        boolean bl = false;
        if (string == null) {
            return bl;
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.m_connection.prepareStatement("Select * from " + string + " where 1=0");
            preparedStatement.executeQuery();
            bl = true;
        }
        catch (Exception exception) {
            if (exception.getMessage().startsWith(m_ORA_EXCEPTION_1000) || exception.getMessage().startsWith(m_ORA_EXCEPTION_604)) {
                System.out.println("Exceeded available Oracle cursors.  Resetting connection and trying the SQL statement again...");
                this.resetConnection();
                return this.exists(string);
            }
            bl = false;
        }
        return bl;
    }

    private ResultSet getColumns(String string) {
        return (ResultSet)this.m_columnCache.get(string);
    }

    private void putColumns(String string, ResultSet resultSet) {
        this.m_columnCache.put(string, resultSet);
    }

    public void exists(String string, String string2, String string3, boolean bl) throws SQLException {
        Wrapper wrapper;
        if (string == null) {
            throw new SQLException("TableName was null.  You must specify a valid table name.");
        }
        if (string2 == null) {
            throw new SQLException("Column name was null.  You must specify a valid column name.");
        }
        ResultSet resultSet = this.getColumns(string);
        if (resultSet == null) {
            wrapper = null;
            try {
                wrapper = this.m_connection.prepareStatement("Select * from " + string + " where 1=0");
                resultSet = wrapper.executeQuery();
                this.putColumns(string, resultSet);
            }
            catch (SQLException sQLException) {
                if (sQLException.getMessage().startsWith(m_ORA_EXCEPTION_1000) || sQLException.getMessage().startsWith(m_ORA_EXCEPTION_604)) {
                    System.out.println("Exceeded available Oracle cursors.  Resetting connection and trying the SQL statement again...");
                    this.resetConnection();
                    this.exists(string, string2, string3, bl);
                }
                throw sQLException;
            }
        }
        wrapper = resultSet.getMetaData();
        int n = wrapper.getColumnCount();
        int n2 = this.getJdbcType(string3);
        for (int i = 1; i <= n; ++i) {
            if (bl) {
                if (!string2.equalsIgnoreCase(wrapper.getColumnName(i))) continue;
                if (n2 != wrapper.getColumnType(i)) {
                    throw new SQLException("The column '" + string + "." + string2 + "' is of type '" + wrapper.getColumnTypeName(i) + "' and cannot be mapped to the jdbc type '" + string3 + "'.");
                }
                return;
            }
            if (!string2.equals(wrapper.getColumnName(i))) continue;
            if (n2 != wrapper.getColumnType(i)) {
                throw new SQLException("The column '" + string + "." + string2 + "' is of type '" + wrapper.getColumnTypeName(i) + "' and cannot be mapped to the jdbc type '" + string3 + "'.");
            }
            return;
        }
        throw new SQLException("The column '" + string2 + "' was not found in table '" + string + "'.");
    }

    public void existsUseWarnings(String string, String string2, String string3, boolean bl) throws SQLException, SQLWarning {
        Wrapper wrapper;
        if (string == null) {
            throw new SQLException("TableName was null.  You must specify a valid table name.");
        }
        if (string2 == null) {
            throw new SQLException("Column name was null.  You must specify a valid column name.");
        }
        ResultSet resultSet = this.getColumns(string);
        if (resultSet == null) {
            try {
                wrapper = this.m_connection.prepareStatement("Select * from " + string + " where 1=0");
                resultSet = wrapper.executeQuery();
                this.putColumns(string, resultSet);
            }
            catch (SQLException sQLException) {
                if (sQLException.getMessage().startsWith(m_ORA_EXCEPTION_1000) || sQLException.getMessage().startsWith(m_ORA_EXCEPTION_604)) {
                    System.out.println("Exceeded available Oracle cursors.  Resetting connection and trying the SQL statement again...");
                    this.resetConnection();
                    this.existsUseWarnings(string, string2, string3, bl);
                }
                throw sQLException;
            }
        }
        wrapper = resultSet.getMetaData();
        int n = wrapper.getColumnCount();
        int n2 = this.getJdbcType(string3);
        for (int i = 1; i <= n; ++i) {
            if (bl) {
                if (!string2.equalsIgnoreCase(wrapper.getColumnName(i))) continue;
                if (n2 != wrapper.getColumnType(i)) {
                    throw new SQLWarning("The column '" + string + "." + string2 + "' is of type '" + wrapper.getColumnTypeName(i) + "' and cannot be mapped to the jdbc type '" + string3 + "'.");
                }
                return;
            }
            if (!string2.equals(wrapper.getColumnName(i))) continue;
            if (n2 != wrapper.getColumnType(i)) {
                throw new SQLWarning("The column '" + string + "." + string2 + "' is of type '" + wrapper.getColumnTypeName(i) + "' and cannot be mapped to the jdbc type '" + string3 + "'.");
            }
            return;
        }
        throw new SQLException("The column '" + string2 + "' was not found in table '" + string + "'.");
    }

    public void exists(String string, String string2, boolean bl) throws SQLException {
        Wrapper wrapper;
        if (string == null) {
            throw new SQLException("TableName was null.  You must specify a valid table name.");
        }
        if (string2 == null) {
            throw new SQLException("Column name was null.  You must specify a valid column name.");
        }
        ResultSet resultSet = this.getColumns(string);
        if (resultSet == null) {
            try {
                wrapper = this.m_connection.prepareStatement("Select * from " + string + " where 1=0");
                resultSet = wrapper.executeQuery();
                this.putColumns(string, resultSet);
            }
            catch (SQLException sQLException) {
                if (sQLException.getMessage().startsWith(m_ORA_EXCEPTION_1000) || sQLException.getMessage().startsWith(m_ORA_EXCEPTION_604)) {
                    System.out.println("Exceeded available Oracle cursors.  Resetting connection and trying the SQL statement again...");
                    this.resetConnection();
                    this.exists(string, string2, bl);
                }
                System.out.println(sQLException.getMessage());
                throw sQLException;
            }
        }
        wrapper = resultSet.getMetaData();
        int n = wrapper.getColumnCount();
        for (int i = 1; i <= n; ++i) {
            if (!(bl ? string2.equalsIgnoreCase(wrapper.getColumnName(i)) : string2.equals(wrapper.getColumnName(i)))) continue;
            return;
        }
        throw new SQLException("The column '" + string2 + "' was not found in table '" + string + "'.");
    }

    public int getJdbcType(String string) throws SQLException {
        int n;
        if (string == null) {
            string = "";
        }
        if ((string = string.toLowerCase()).equals("bit")) {
            n = -7;
        } else if (string.equals("tinyint")) {
            n = -6;
        } else if (string.equals("smallint")) {
            n = 5;
        } else if (string.equals("integer")) {
            n = 4;
        } else if (string.equals("bigint")) {
            n = -5;
        } else if (string.equals("float")) {
            n = 6;
        } else if (string.equals("real")) {
            n = 7;
        } else if (string.equals("double")) {
            n = 8;
        } else if (string.equals("numeric")) {
            n = 2;
        } else if (string.equals("decimal")) {
            n = 3;
        } else if (string.equals("char")) {
            n = 1;
        } else if (string.equals("varchar")) {
            n = 12;
        } else if (string.equals("longvarchar")) {
            n = -1;
        } else if (string.equals("date")) {
            n = 91;
        } else if (string.equals("time")) {
            n = 92;
        } else if (string.equals("timestamp")) {
            n = 93;
        } else if (string.equals("binary")) {
            n = -2;
        } else if (string.equals("varbinary")) {
            n = -3;
        } else if (string.equals("longvarbinary")) {
            n = -4;
        } else if (string.equals("clob")) {
            n = 2005;
        } else if (string.equals("blob")) {
            n = 2004;
        } else {
            throw new SQLException("The type '" + string + "' is not a valid jdbc type.");
        }
        return n;
    }

    protected void finalize() {
        try {
            this.release();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

