/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.lang.ref.WeakReference;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBLifeCycleEvent;
import org.apache.ojb.broker.PBStateEvent;
import org.apache.ojb.broker.PBStateListener;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerInternal;
import org.apache.ojb.broker.PersistenceBrokerSQLException;
import org.apache.ojb.broker.accesslayer.OJBIterator;
import org.apache.ojb.broker.accesslayer.RelationshipPrefetcher;
import org.apache.ojb.broker.accesslayer.ResultSetAndStatement;
import org.apache.ojb.broker.accesslayer.RowReader;
import org.apache.ojb.broker.accesslayer.RsQueryObject;
import org.apache.ojb.broker.cache.MaterializationCache;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryBySQL;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class RsIterator
implements OJBIterator {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String INFO_MSG = "Resources already cleaned up, recommend to set this flag before first use of the iterator";
    private PBLifeCycleEvent afterLookupEvent;
    private MaterializationCache m_cache;
    private PersistenceBrokerImpl m_broker;
    private ResultSetAndStatement m_rsAndStmt;
    private RsQueryObject m_queryObject;
    private Class m_itemProxyClass;
    private Class m_itemTopLevelClass = null;
    private Map m_row = null;
    private boolean m_hasCalledCheck = false;
    private boolean m_inBatchedMode = false;
    private boolean hasNext = false;
    private boolean advancedJDBCSupport = false;
    private boolean JDBCSupportAssessed = false;
    private int m_current_row = 0;
    private boolean resourcesAreReleased = false;
    private boolean autoRelease = true;
    private ResourceWrapper resourceListener;
    private boolean disableLifeCycleEvents = false;

    public RsIterator(RsQueryObject rsQueryObject, PersistenceBrokerImpl persistenceBrokerImpl) {
        this.setCache(persistenceBrokerImpl.getInternalCache());
        this.setRow(new HashMap());
        this.setBroker(persistenceBrokerImpl);
        this.setQueryObject(rsQueryObject);
        Class clazz = persistenceBrokerImpl.getReferenceBroker().getClassToPrefetch();
        if (clazz != null && clazz.isAssignableFrom(rsQueryObject.getClassDescriptor().getClassOfObject())) {
            this.setItemProxyClass(null);
        } else {
            this.setItemProxyClass(rsQueryObject.getClassDescriptor().getProxyClass());
        }
        this.setAfterLookupEvent(new PBLifeCycleEvent(this.getBroker(), PBLifeCycleEvent.Type.AFTER_LOOKUP));
        try {
            this.setRsAndStmt(rsQueryObject.performQuery(persistenceBrokerImpl.serviceJdbcAccess()));
            this.prefetchRelationships(rsQueryObject.getQuery());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("RsIterator[" + rsQueryObject + "] initialized");
            }
        }
        catch (RuntimeException runtimeException) {
            this.autoReleaseDbResources();
            throw runtimeException;
        }
        this.resourceListener = new ResourceWrapper(this);
        this.m_broker.addListener(this.resourceListener);
    }

    protected Class getTopLevelClass() {
        if (this.m_itemTopLevelClass == null) {
            this.m_itemTopLevelClass = this.getBroker().getTopLevelClass(this.getQueryObject().getClassDescriptor().getClassOfObject());
        }
        return this.m_itemTopLevelClass;
    }

    public synchronized boolean hasNext() {
        try {
            if (!this.isHasCalledCheck()) {
                this.setHasCalledCheck(true);
                this.setHasNext(this.getRsAndStmt().m_rs.next());
                if (!this.getHasNext()) {
                    this.autoReleaseDbResources();
                }
            }
        }
        catch (Exception exception) {
            this.setHasNext(false);
            this.autoReleaseDbResources();
            if (exception instanceof ResourceClosedException) {
                throw (ResourceClosedException)((Object)exception);
            }
            if (exception instanceof SQLException) {
                throw new PersistenceBrokerSQLException("Calling ResultSet.next() failed", (SQLException)exception);
            }
            throw new PersistenceBrokerException("Can't get next row from ResultSet", exception);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("hasNext() -> " + this.getHasNext());
        }
        return this.getHasNext();
    }

    public synchronized Object next() throws NoSuchElementException {
        try {
            if (!this.isHasCalledCheck()) {
                this.hasNext();
            }
            this.setHasCalledCheck(false);
            if (this.getHasNext()) {
                Object object = this.getObjectFromResultSet();
                ++this.m_current_row;
                if (!this.disableLifeCycleEvents) {
                    this.getAfterLookupEvent().setTarget(object);
                    this.getBroker().fireBrokerEvent(this.getAfterLookupEvent());
                    this.getAfterLookupEvent().setTarget(null);
                }
                return object;
            }
            throw new NoSuchElementException("inner hasNext was false");
        }
        catch (ResourceClosedException resourceClosedException) {
            this.autoReleaseDbResources();
            throw resourceClosedException;
        }
        catch (NoSuchElementException noSuchElementException) {
            this.autoReleaseDbResources();
            this.logger.error("Error while iterate ResultSet for query " + this.m_queryObject, noSuchElementException);
            throw new NoSuchElementException("Could not obtain next object: " + noSuchElementException.getMessage());
        }
    }

    public void remove() {
        throw new UnsupportedOperationException("removing not supported by RsIterator");
    }

    private Collection getOwnerObjects() {
        Vector<Object> vector = new Vector<Object>();
        while (this.hasNext()) {
            vector.add(this.next());
        }
        return vector;
    }

    private void prefetchRelationships(Query query) {
        int n;
        if (query == null || query.getPrefetchedRelationships() == null || query.getPrefetchedRelationships().isEmpty()) {
            return;
        }
        if (!this.supportsAdvancedJDBCCursorControl()) {
            this.logger.info("prefetching relationships requires JDBC level 2.0");
            return;
        }
        this.setInBatchedMode(true);
        List list = query.getPrefetchedRelationships();
        RelationshipPrefetcher[] relationshipPrefetcherArray = new RelationshipPrefetcher[list.size()];
        for (n = 0; n < list.size(); ++n) {
            String string = (String)list.get(n);
            relationshipPrefetcherArray[n] = this.getBroker().getRelationshipPrefetcherFactory().createRelationshipPrefetcher(this.getQueryObject().getClassDescriptor(), string);
            relationshipPrefetcherArray[n].prepareRelationshipSettings();
        }
        Collection collection = this.getOwnerObjects();
        for (n = 0; n < list.size(); ++n) {
            relationshipPrefetcherArray[n].prefetchRelationship(collection);
        }
        for (n = 0; n < list.size(); ++n) {
            relationshipPrefetcherArray[n].restoreRelationshipSettings();
        }
        try {
            this.getRsAndStmt().m_rs.beforeFirst();
        }
        catch (SQLException sQLException) {
            this.logger.error("beforeFirst failed !", sQLException);
        }
        this.setInBatchedMode(false);
        this.setHasCalledCheck(false);
    }

    protected Identity getIdentityFromResultSet() throws PersistenceBrokerException {
        FieldDescriptor[] fieldDescriptorArray = this.getQueryObject().getClassDescriptor().getPkFields();
        Object[] objectArray = new Object[fieldDescriptorArray.length];
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
            objectArray[i] = this.getRow().get(fieldDescriptor.getColumnName());
        }
        return this.getBroker().serviceIdentity().buildIdentity(this.getQueryObject().getClassDescriptor().getClassOfObject(), this.getTopLevelClass(), objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObjectFromResultSet() throws PersistenceBrokerException {
        this.getRow().clear();
        RowReader rowReader = this.getQueryObject().getClassDescriptor().getRowReader();
        rowReader.readPkValuesFrom(this.getRsAndStmt(), this.getRow());
        if (this.getItemProxyClass() != null) {
            return this.getProxyFromResultSet();
        }
        Identity identity = this.getIdentityFromResultSet();
        Object object = this.getCache().lookup(identity);
        if (object == null) {
            rowReader.readObjectArrayFrom(this.getRsAndStmt(), this.getRow());
            object = rowReader.readObjectFrom(this.getRow());
            if (object != null) {
                Object object2 = object;
                synchronized (object2) {
                    this.getCache().enableMaterializationCache();
                    try {
                        this.getCache().doInternalCache(identity, object, 11);
                        ClassDescriptor classDescriptor = this.getBroker().getClassDescriptor(object.getClass());
                        this.getBroker().getReferenceBroker().retrieveReferences(object, classDescriptor, false);
                        this.getBroker().getReferenceBroker().retrieveCollections(object, classDescriptor, false);
                        this.getCache().disableMaterializationCache();
                    }
                    catch (RuntimeException runtimeException) {
                        this.getCache().doLocalClear();
                        throw runtimeException;
                    }
                }
            }
        } else {
            ClassDescriptor classDescriptor = this.getBroker().getClassDescriptor(object.getClass());
            if (classDescriptor.isAlwaysRefresh()) {
                rowReader.readObjectArrayFrom(this.getRsAndStmt(), this.getRow());
                rowReader.refreshObject(object, this.getRow());
            }
            this.getBroker().checkRefreshRelationships(object, identity, classDescriptor);
        }
        return object;
    }

    protected Object getProxyFromResultSet() throws PersistenceBrokerException {
        Identity identity = this.getIdentityFromResultSet();
        return this.getBroker().createProxy(this.getItemProxyClass(), identity);
    }

    private boolean supportsAdvancedJDBCCursorControl() {
        if (!this.JDBCSupportAssessed) {
            if (this.getConnectionDescriptor().getJdbcLevel() >= 2.0) {
                this.advancedJDBCSupport = true;
            }
            this.JDBCSupportAssessed = true;
        }
        return this.advancedJDBCSupport;
    }

    protected int countedSize() throws PersistenceBrokerException {
        ResultSetAndStatement resultSetAndStatement;
        Query query = this.getBroker().serviceBrokerHelper().getCountQuery(this.getQueryObject().getQuery());
        ClassDescriptor classDescriptor = this.getQueryObject().getClassDescriptor();
        int n = 0;
        if (query instanceof QueryBySQL) {
            String string = ((QueryBySQL)query).getSql();
            resultSetAndStatement = this.getBroker().serviceJdbcAccess().executeSQL(string, classDescriptor, false);
        } else {
            resultSetAndStatement = this.getBroker().serviceJdbcAccess().executeQuery(query, classDescriptor);
        }
        try {
            if (resultSetAndStatement.m_rs.next()) {
                n = resultSetAndStatement.m_rs.getInt(1);
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceBrokerException(sQLException);
        }
        finally {
            resultSetAndStatement.close();
        }
        return n;
    }

    public int size() throws PersistenceBrokerException {
        int n = 0;
        boolean bl = true;
        try {
            bl = this.getRsAndStmt().m_stmt.getResultSetType() == 1003;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (!this.supportsAdvancedJDBCCursorControl() || this.getBroker().serviceConnectionManager().getSupportedPlatform().useCountForResultsetSize() || bl) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Executing count(*) to get size()");
            }
            n = this.countedSize();
        } else {
            try {
                if (this.getRsAndStmt().m_rs != null) {
                    int n2 = this.getRsAndStmt().m_rs.getRow();
                    n = this.getRsAndStmt().m_rs.last() ? this.getRsAndStmt().m_rs.getRow() : 0;
                    if (n2 > 0) {
                        this.getRsAndStmt().m_rs.absolute(n2);
                    } else {
                        this.getRsAndStmt().m_rs.beforeFirst();
                    }
                }
            }
            catch (SQLException sQLException) {
                this.advancedJDBCSupport = false;
            }
        }
        return n;
    }

    public int fullSize() throws PersistenceBrokerException {
        return this.size();
    }

    public boolean absolute(int n) throws PersistenceBrokerException {
        boolean bl = this.supportsAdvancedJDBCCursorControl() ? this.absoluteAdvanced(n) : this.absoluteBasic(n);
        return bl;
    }

    private boolean absoluteBasic(int n) {
        boolean bl;
        block6: {
            bl = false;
            if (n > this.m_current_row) {
                try {
                    while (this.m_current_row < n && this.getRsAndStmt().m_rs.next()) {
                        ++this.m_current_row;
                    }
                    if (this.m_current_row == n) {
                        bl = true;
                        break block6;
                    }
                    this.setHasCalledCheck(true);
                    this.setHasNext(false);
                    bl = false;
                    this.autoReleaseDbResources();
                }
                catch (Exception exception) {
                    this.setHasCalledCheck(true);
                    this.setHasNext(false);
                    bl = false;
                }
            } else {
                this.logger.info("Your driver does not support advanced JDBC Functionality, you cannot call absolute() with a position < current");
            }
        }
        return bl;
    }

    private boolean absoluteAdvanced(int n) {
        boolean bl = false;
        try {
            if (this.getRsAndStmt().m_rs != null) {
                if (n == 0) {
                    this.getRsAndStmt().m_rs.beforeFirst();
                } else {
                    bl = this.getRsAndStmt().m_rs.absolute(n);
                }
                this.m_current_row = n;
                this.setHasCalledCheck(false);
            }
        }
        catch (SQLException sQLException) {
            this.advancedJDBCSupport = false;
        }
        return bl;
    }

    public boolean relative(int n) throws PersistenceBrokerException {
        boolean bl = false;
        if (this.supportsAdvancedJDBCCursorControl()) {
            try {
                if (this.getRsAndStmt().m_rs != null) {
                    bl = this.getRsAndStmt().m_rs.relative(n);
                    this.m_current_row += n;
                }
            }
            catch (SQLException sQLException) {
                this.advancedJDBCSupport = false;
            }
        } else {
            if (n >= 0) {
                return this.absolute(this.m_current_row + n);
            }
            this.logger.info("Your driver does not support advanced JDBC Functionality, you cannot call relative() with a negative value");
        }
        return bl;
    }

    public void releaseDbResources() {
        this.release(true);
    }

    void release(boolean bl) {
        if (!this.isInBatchedMode() && !this.resourcesAreReleased) {
            if (bl && this.resourceListener != null) {
                try {
                    this.m_broker.removeListener(this.resourceListener);
                    this.resourceListener = null;
                }
                catch (Exception exception) {
                    this.logger.error("Error when try to remove RsIterator resource listener", exception);
                }
            }
            this.resourcesAreReleased = true;
            if (this.m_rsAndStmt != null) {
                this.m_rsAndStmt.close();
                this.m_rsAndStmt = null;
            }
        }
    }

    protected void autoReleaseDbResources() {
        if (this.autoRelease) {
            this.releaseDbResources();
        }
    }

    public void setAutoRelease(boolean bl) {
        if (this.resourcesAreReleased && !bl) {
            this.logger.info(INFO_MSG);
        }
        this.autoRelease = bl;
    }

    protected DescriptorRepository getDescriptorRepository() {
        return this.getBroker().getDescriptorRepository();
    }

    protected JdbcConnectionDescriptor getConnectionDescriptor() {
        return this.getBroker().serviceConnectionManager().getConnectionDescriptor();
    }

    protected void finalize() {
        if (this.m_rsAndStmt != null) {
            this.logger.info("Found unclosed resources while finalize (causer class: " + this.getClass().getName() + ")" + " Do automatic cleanup");
            this.releaseDbResources();
        }
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public String toString() {
        return super.toString();
    }

    public ClassDescriptor getClassDescriptor() {
        return this.getQueryObject().getClassDescriptor();
    }

    protected void setBroker(PersistenceBrokerImpl persistenceBrokerImpl) {
        this.m_broker = persistenceBrokerImpl;
    }

    protected PersistenceBrokerInternal getBroker() {
        return this.m_broker;
    }

    protected void setRsAndStmt(ResultSetAndStatement resultSetAndStatement) {
        if (this.m_rsAndStmt != null) {
            throw new ResourceNotClosedException("Unclosed resources found, please release resources before set new ones");
        }
        this.resourcesAreReleased = false;
        this.m_rsAndStmt = resultSetAndStatement;
    }

    protected ResultSetAndStatement getRsAndStmt() {
        if (this.resourcesAreReleased) {
            throw new ResourceClosedException("Resources no longer reachable, RsIterator will be automatic cleaned up on PB.close/.commitTransaction/.abortTransaction");
        }
        return this.m_rsAndStmt;
    }

    protected void setQueryObject(RsQueryObject rsQueryObject) {
        this.m_queryObject = rsQueryObject;
    }

    protected RsQueryObject getQueryObject() {
        return this.m_queryObject;
    }

    protected void setItemProxyClass(Class clazz) {
        this.m_itemProxyClass = clazz;
    }

    protected Class getItemProxyClass() {
        return this.m_itemProxyClass;
    }

    protected void setRow(Map map) {
        this.m_row = map;
    }

    protected Map getRow() {
        return this.m_row;
    }

    protected void setCache(MaterializationCache materializationCache) {
        this.m_cache = materializationCache;
    }

    protected MaterializationCache getCache() {
        return this.m_cache;
    }

    protected void setAfterLookupEvent(PBLifeCycleEvent pBLifeCycleEvent) {
        this.afterLookupEvent = pBLifeCycleEvent;
    }

    protected PBLifeCycleEvent getAfterLookupEvent() {
        return this.afterLookupEvent;
    }

    protected void setHasCalledCheck(boolean bl) {
        this.m_hasCalledCheck = bl;
    }

    protected boolean isHasCalledCheck() {
        return this.m_hasCalledCheck;
    }

    protected void setHasNext(boolean bl) {
        this.hasNext = bl;
    }

    protected boolean getHasNext() {
        return this.hasNext;
    }

    protected void setInBatchedMode(boolean bl) {
        this.m_inBatchedMode = bl;
    }

    protected boolean isInBatchedMode() {
        return this.m_inBatchedMode;
    }

    public void disableLifeCycleEvents() {
        this.disableLifeCycleEvents = true;
    }

    public static class ResourceNotClosedException
    extends OJBRuntimeException {
        public ResourceNotClosedException(String string) {
            super(string);
        }

        public ResourceNotClosedException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public static class ResourceClosedException
    extends OJBRuntimeException {
        public ResourceClosedException(String string) {
            super(string);
        }

        public ResourceClosedException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public static class ResourceWrapper
    implements PBStateListener {
        WeakReference ref;

        public ResourceWrapper(RsIterator rsIterator) {
            this.ref = new WeakReference<RsIterator>(rsIterator);
        }

        public void beforeClose(PBStateEvent pBStateEvent) {
            if (this.ref != null) {
                RsIterator rsIterator = (RsIterator)this.ref.get();
                if (rsIterator != null) {
                    rsIterator.release(false);
                }
                this.ref = null;
            }
        }

        public void beforeRollback(PBStateEvent pBStateEvent) {
            if (this.ref != null) {
                RsIterator rsIterator = (RsIterator)this.ref.get();
                if (rsIterator != null) {
                    rsIterator.release(false);
                }
                this.ref = null;
            }
        }

        public void beforeCommit(PBStateEvent pBStateEvent) {
            if (this.ref != null) {
                RsIterator rsIterator = (RsIterator)this.ref.get();
                if (rsIterator != null) {
                    rsIterator.release(false);
                }
                this.ref = null;
            }
        }

        public void afterCommit(PBStateEvent pBStateEvent) {
        }

        public void afterRollback(PBStateEvent pBStateEvent) {
        }

        public void afterBegin(PBStateEvent pBStateEvent) {
        }

        public void beforeBegin(PBStateEvent pBStateEvent) {
        }

        public void afterOpen(PBStateEvent pBStateEvent) {
        }
    }
}

