/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OptimisticLockException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerSQLException;
import org.apache.ojb.broker.accesslayer.JdbcAccess;
import org.apache.ojb.broker.accesslayer.ResultSetAndStatement;
import org.apache.ojb.broker.accesslayer.StatementManagerIF;
import org.apache.ojb.broker.accesslayer.sql.SelectStatement;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.metadata.ArgumentDescriptor;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ProcedureDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.util.ExceptionHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;

public class JdbcAccessImpl
implements JdbcAccess {
    protected Logger logger;
    protected PersistenceBroker broker;

    public JdbcAccessImpl(PersistenceBroker persistenceBroker) {
        this.broker = persistenceBroker;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    private Platform getPlatform() {
        return this.broker.serviceConnectionManager().getSupportedPlatform();
    }

    public void executeDelete(ClassDescriptor classDescriptor, Object object) throws PersistenceBrokerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("executeDelete: " + object);
        }
        StatementManagerIF statementManagerIF = this.broker.serviceStatementManager();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = statementManagerIF.getDeleteStatement(classDescriptor);
            if (preparedStatement == null) {
                this.logger.error("getDeleteStatement returned a null statement");
                throw new PersistenceBrokerException("JdbcAccessImpl: getDeleteStatement returned a null statement");
            }
            statementManagerIF.bindDelete(preparedStatement, classDescriptor, object);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("executeDelete: " + preparedStatement);
            }
            if (preparedStatement.executeUpdate() == 0 && classDescriptor.isLocking()) {
                throw new OptimisticLockException("Object has been modified or deleted by someone else", object);
            }
            this.harvestReturnValues(classDescriptor.getDeleteProcedure(), object, preparedStatement);
        }
        catch (OptimisticLockException optimisticLockException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("OptimisticLockException during the execution of delete: " + optimisticLockException.getMessage(), (Throwable)((Object)optimisticLockException));
            }
            throw optimisticLockException;
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            this.logger.error("PersistenceBrokerException during the execution of delete: " + persistenceBrokerException.getMessage(), (Throwable)((Object)persistenceBrokerException));
            throw persistenceBrokerException;
        }
        catch (SQLException sQLException) {
            String string = this.broker.serviceSqlGenerator().getPreparedDeleteStatement(classDescriptor).getStatement();
            throw ExceptionHelper.generateException(sQLException, string, classDescriptor, this.logger, object);
        }
        finally {
            statementManagerIF.closeResources(preparedStatement, null);
        }
    }

    public void executeDelete(Query query, ClassDescriptor classDescriptor) throws PersistenceBrokerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("executeDelete (by Query): " + query);
        }
        StatementManagerIF statementManagerIF = this.broker.serviceStatementManager();
        PreparedStatement preparedStatement = null;
        String string = this.broker.serviceSqlGenerator().getPreparedDeleteStatement(query, classDescriptor).getStatement();
        try {
            preparedStatement = statementManagerIF.getPreparedStatement(classDescriptor, string, false, -1, classDescriptor.getDeleteProcedure() != null);
            statementManagerIF.bindStatement(preparedStatement, query, classDescriptor, 1);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("executeDelete (by Query): " + preparedStatement);
            }
            preparedStatement.executeUpdate();
            statementManagerIF.closeResources(preparedStatement, null);
        }
        catch (SQLException sQLException) {
            try {
                throw ExceptionHelper.generateException(sQLException, string, classDescriptor, null, this.logger);
            }
            catch (Throwable throwable) {
                statementManagerIF.closeResources(preparedStatement, null);
                throw throwable;
            }
        }
    }

    public void executeInsert(ClassDescriptor classDescriptor, Object object) throws PersistenceBrokerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("executeInsert: " + object);
        }
        StatementManagerIF statementManagerIF = this.broker.serviceStatementManager();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = statementManagerIF.getInsertStatement(classDescriptor);
            if (preparedStatement == null) {
                this.logger.error("getInsertStatement returned a null statement");
                throw new PersistenceBrokerException("getInsertStatement returned a null statement");
            }
            this.assignAutoincrementSequences(classDescriptor, object);
            statementManagerIF.bindInsert(preparedStatement, classDescriptor, object);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("executeInsert: " + preparedStatement);
            }
            preparedStatement.executeUpdate();
            this.assignAutoincrementIdentityColumns(classDescriptor, object);
            this.harvestReturnValues(classDescriptor.getInsertProcedure(), object, preparedStatement);
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            this.logger.error("PersistenceBrokerException during the execution of the insert: " + persistenceBrokerException.getMessage(), (Throwable)((Object)persistenceBrokerException));
            throw persistenceBrokerException;
        }
        catch (SequenceManagerException sequenceManagerException) {
            throw new PersistenceBrokerException("Error while try to assign identity value", (Throwable)((Object)sequenceManagerException));
        }
        catch (SQLException sQLException) {
            String string = this.broker.serviceSqlGenerator().getPreparedInsertStatement(classDescriptor).getStatement();
            throw ExceptionHelper.generateException(sQLException, string, classDescriptor, this.logger, object);
        }
        finally {
            statementManagerIF.closeResources(preparedStatement, null);
        }
    }

    public ResultSetAndStatement executeQuery(Query query, ClassDescriptor classDescriptor) throws PersistenceBrokerException {
        boolean bl;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("executeQuery: " + query);
        }
        boolean bl2 = bl = query.getStartAtIndex() > 0 || query.getEndAtIndex() > 0;
        if (query != null && query.getPrefetchedRelationships() != null && !query.getPrefetchedRelationships().isEmpty()) {
            bl = true;
        }
        StatementManagerIF statementManagerIF = this.broker.serviceStatementManager();
        SelectStatement selectStatement = this.broker.serviceSqlGenerator().getPreparedSelectStatement(query, classDescriptor);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            int n = query.getFetchSize();
            boolean bl3 = this.isStoredProcedure(selectStatement.getStatement());
            preparedStatement = statementManagerIF.getPreparedStatement(classDescriptor, selectStatement.getStatement(), bl, n, bl3);
            if (bl3) {
                this.getPlatform().registerOutResultSet((CallableStatement)preparedStatement, 1);
                statementManagerIF.bindStatement(preparedStatement, query, classDescriptor, 2);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("executeQuery: " + preparedStatement);
                }
                preparedStatement.execute();
                resultSet = (ResultSet)((CallableStatement)preparedStatement).getObject(1);
            } else {
                statementManagerIF.bindStatement(preparedStatement, query, classDescriptor, 1);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("executeQuery: " + preparedStatement);
                }
                resultSet = preparedStatement.executeQuery();
            }
            return new ResultSetAndStatement(statementManagerIF, preparedStatement, resultSet, selectStatement);
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            statementManagerIF.closeResources(preparedStatement, resultSet);
            this.logger.error("PersistenceBrokerException during the execution of the query: " + persistenceBrokerException.getMessage(), (Throwable)((Object)persistenceBrokerException));
            throw persistenceBrokerException;
        }
        catch (SQLException sQLException) {
            statementManagerIF.closeResources(preparedStatement, resultSet);
            throw ExceptionHelper.generateException(sQLException, selectStatement.getStatement(), null, this.logger, null);
        }
    }

    public ResultSetAndStatement executeSQL(String string, ClassDescriptor classDescriptor, boolean bl) throws PersistenceBrokerException {
        return this.executeSQL(string, classDescriptor, null, bl);
    }

    public ResultSetAndStatement executeSQL(final String string, ClassDescriptor classDescriptor, ValueContainer[] valueContainerArray, boolean bl) throws PersistenceBrokerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("executeSQL: " + string);
        }
        boolean bl2 = this.isStoredProcedure(string);
        StatementManagerIF statementManagerIF = this.broker.serviceStatementManager();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = statementManagerIF.getPreparedStatement(classDescriptor, string, bl, 0, bl2);
            if (bl2) {
                this.getPlatform().registerOutResultSet((CallableStatement)preparedStatement, 1);
                statementManagerIF.bindValues(preparedStatement, valueContainerArray, 2);
                preparedStatement.execute();
                resultSet = (ResultSet)((CallableStatement)preparedStatement).getObject(1);
            } else {
                statementManagerIF.bindValues(preparedStatement, valueContainerArray, 1);
                resultSet = preparedStatement.executeQuery();
            }
            return new ResultSetAndStatement(statementManagerIF, preparedStatement, resultSet, new SelectStatement(){

                public Query getQueryInstance() {
                    return null;
                }

                public int getColumnIndex(FieldDescriptor fieldDescriptor) {
                    return Integer.MIN_VALUE;
                }

                public String getStatement() {
                    return string;
                }
            });
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            statementManagerIF.closeResources(preparedStatement, resultSet);
            this.logger.error("PersistenceBrokerException during the execution of the SQL query: " + persistenceBrokerException.getMessage(), (Throwable)((Object)persistenceBrokerException));
            throw persistenceBrokerException;
        }
        catch (SQLException sQLException) {
            statementManagerIF.closeResources(preparedStatement, resultSet);
            throw ExceptionHelper.generateException(sQLException, string, classDescriptor, valueContainerArray, this.logger, null);
        }
    }

    public int executeUpdateSQL(String string, ClassDescriptor classDescriptor) throws PersistenceBrokerException {
        return this.executeUpdateSQL(string, classDescriptor, null, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdateSQL(String string, ClassDescriptor classDescriptor, ValueContainer[] valueContainerArray, ValueContainer[] valueContainerArray2) throws PersistenceBrokerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("executeUpdateSQL: " + string);
        }
        PreparedStatement preparedStatement = null;
        StatementManagerIF statementManagerIF = this.broker.serviceStatementManager();
        try {
            preparedStatement = statementManagerIF.getPreparedStatement(classDescriptor, string, false, -1, this.isStoredProcedure(string));
            int n = statementManagerIF.bindValues(preparedStatement, valueContainerArray, 1);
            statementManagerIF.bindValues(preparedStatement, valueContainerArray2, n);
            int n2 = preparedStatement.executeUpdate();
            statementManagerIF.closeResources(preparedStatement, null);
            return n2;
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            try {
                this.logger.error("PersistenceBrokerException during the execution of the Update SQL query: " + persistenceBrokerException.getMessage(), (Throwable)((Object)persistenceBrokerException));
                throw persistenceBrokerException;
                catch (SQLException sQLException) {
                    ValueContainer[] valueContainerArray3 = this.addValues(valueContainerArray, valueContainerArray2);
                    throw ExceptionHelper.generateException(sQLException, string, classDescriptor, valueContainerArray3, this.logger, null);
                }
            }
            catch (Throwable throwable) {
                statementManagerIF.closeResources(preparedStatement, null);
                throw throwable;
            }
        }
    }

    private ValueContainer[] addValues(ValueContainer[] valueContainerArray, ValueContainer[] valueContainerArray2) {
        ValueContainer[] valueContainerArray3;
        if (valueContainerArray2 != null && valueContainerArray2.length > 0) {
            if (valueContainerArray != null) {
                valueContainerArray3 = new ValueContainer[valueContainerArray.length + valueContainerArray2.length];
                System.arraycopy(valueContainerArray, 0, valueContainerArray3, 0, valueContainerArray.length);
                System.arraycopy(valueContainerArray2, 0, valueContainerArray3, valueContainerArray.length, valueContainerArray2.length);
            } else {
                valueContainerArray3 = valueContainerArray2;
            }
        } else {
            valueContainerArray3 = valueContainerArray;
        }
        return valueContainerArray3;
    }

    public void executeUpdate(ClassDescriptor classDescriptor, Object object) throws PersistenceBrokerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("executeUpdate: " + object);
        }
        if (classDescriptor.getNonPkRwFields().length == 0) {
            return;
        }
        StatementManagerIF statementManagerIF = this.broker.serviceStatementManager();
        PreparedStatement preparedStatement = null;
        ValueContainer[] valueContainerArray = classDescriptor.getCurrentLockingValues(object);
        try {
            preparedStatement = statementManagerIF.getUpdateStatement(classDescriptor);
            if (preparedStatement == null) {
                this.logger.error("getUpdateStatement returned a null statement");
                throw new PersistenceBrokerException("getUpdateStatement returned a null statement");
            }
            statementManagerIF.bindUpdate(preparedStatement, classDescriptor, object);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("executeUpdate: " + preparedStatement);
            }
            if (preparedStatement.executeUpdate() == 0 && classDescriptor.isLocking()) {
                throw new OptimisticLockException("Object has been modified by someone else", object);
            }
            this.harvestReturnValues(classDescriptor.getUpdateProcedure(), object, preparedStatement);
        }
        catch (OptimisticLockException optimisticLockException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("OptimisticLockException during the execution of update: " + optimisticLockException.getMessage(), (Throwable)((Object)optimisticLockException));
            }
            throw optimisticLockException;
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            this.setLockingValues(classDescriptor, object, valueContainerArray);
            this.logger.error("PersistenceBrokerException during the execution of the update: " + persistenceBrokerException.getMessage(), (Throwable)((Object)persistenceBrokerException));
            throw persistenceBrokerException;
        }
        catch (SQLException sQLException) {
            String string = this.broker.serviceSqlGenerator().getPreparedUpdateStatement(classDescriptor).getStatement();
            throw ExceptionHelper.generateException(sQLException, string, classDescriptor, this.logger, object);
        }
        finally {
            statementManagerIF.closeResources(preparedStatement, null);
        }
    }

    public Object materializeObject(ClassDescriptor classDescriptor, Identity identity) throws PersistenceBrokerException {
        StatementManagerIF statementManagerIF = this.broker.serviceStatementManager();
        SelectStatement selectStatement = this.broker.serviceSqlGenerator().getPreparedSelectByPkStatement(classDescriptor);
        Object object = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = statementManagerIF.getSelectByPKStatement(classDescriptor);
            if (preparedStatement == null) {
                this.logger.error("getSelectByPKStatement returned a null statement");
                throw new PersistenceBrokerException("getSelectByPKStatement returned a null statement");
            }
            statementManagerIF.bindSelect(preparedStatement, identity, classDescriptor, false);
            resultSet = preparedStatement.executeQuery();
            ResultSetAndStatement resultSetAndStatement = new ResultSetAndStatement(this.broker.serviceStatementManager(), preparedStatement, resultSet, selectStatement);
            if (resultSet.next()) {
                HashMap hashMap = new HashMap();
                classDescriptor.getRowReader().readObjectArrayFrom(resultSetAndStatement, hashMap);
                object = classDescriptor.getRowReader().readObjectFrom(hashMap);
            }
            resultSetAndStatement.close();
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            statementManagerIF.closeResources(preparedStatement, resultSet);
            this.logger.error("PersistenceBrokerException during the execution of materializeObject: " + persistenceBrokerException.getMessage(), (Throwable)((Object)persistenceBrokerException));
            throw persistenceBrokerException;
        }
        catch (SQLException sQLException) {
            statementManagerIF.closeResources(preparedStatement, resultSet);
            throw ExceptionHelper.generateException(sQLException, selectStatement.getStatement(), classDescriptor, this.logger, null);
        }
        return object;
    }

    private void setLockingValues(ClassDescriptor classDescriptor, Object object, ValueContainer[] valueContainerArray) {
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getLockingFields();
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            PersistentField persistentField = fieldDescriptorArray[i].getPersistentField();
            Object object2 = valueContainerArray[i].getValue();
            persistentField.set(object, object2);
        }
    }

    private void harvestReturnValues(ProcedureDescriptor procedureDescriptor, Object object, PreparedStatement preparedStatement) throws PersistenceBrokerSQLException {
        if (procedureDescriptor == null || !procedureDescriptor.hasReturnValues()) {
            return;
        }
        CallableStatement callableStatement = (CallableStatement)preparedStatement;
        int n = 0;
        if (procedureDescriptor.hasReturnValue()) {
            this.harvestReturnValue(object, callableStatement, procedureDescriptor.getReturnValueFieldRef(), ++n);
        }
        Iterator iterator = procedureDescriptor.getArguments().iterator();
        while (iterator.hasNext()) {
            ++n;
            ArgumentDescriptor argumentDescriptor = (ArgumentDescriptor)iterator.next();
            if (!argumentDescriptor.getIsReturnedByProcedure()) continue;
            this.harvestReturnValue(object, callableStatement, argumentDescriptor.getFieldRef(), n);
        }
    }

    private void harvestReturnValue(Object object, CallableStatement callableStatement, FieldDescriptor fieldDescriptor, int n) throws PersistenceBrokerSQLException {
        try {
            if (callableStatement != null && fieldDescriptor != null && object != null) {
                Object object2 = fieldDescriptor.getJdbcType().getObjectFromColumn(callableStatement, n);
                fieldDescriptor.getPersistentField().set(object, fieldDescriptor.getFieldConversion().sqlToJava(object2));
            }
        }
        catch (SQLException sQLException) {
            String string = "SQLException during the execution of harvestReturnValue class=" + object.getClass().getName() + "," + " field=" + fieldDescriptor.getAttributeName() + " : " + sQLException.getMessage();
            this.logger.error(string, sQLException);
            throw new PersistenceBrokerSQLException(string, sQLException);
        }
    }

    protected boolean isStoredProcedure(String string) {
        int n = 0;
        for (int i = 0; n < 3 && i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ') continue;
            switch (n) {
                case 0: {
                    if (c == '{') break;
                    return false;
                }
                case 1: {
                    if (c == '?' || c == 'c') break;
                    return false;
                }
                case 2: {
                    if (c == '=' || c == 'a') break;
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    protected void assignAutoincrementSequences(ClassDescriptor classDescriptor, Object object) throws SequenceManagerException {
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getFieldDescriptor(false);
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
            if (!fieldDescriptor.isAutoIncrement() || fieldDescriptor.isAccessReadOnly()) continue;
            Object object2 = fieldDescriptor.getPersistentField().get(object);
            if (!this.broker.serviceBrokerHelper().representsNull(fieldDescriptor, object2)) continue;
            Object object3 = this.broker.serviceSequenceManager().getUniqueValue(fieldDescriptor);
            fieldDescriptor.getPersistentField().set(object, object3);
        }
    }

    protected void assignAutoincrementIdentityColumns(ClassDescriptor classDescriptor, Object object) throws SequenceManagerException {
        if (classDescriptor.useIdentityColumnField()) {
            this.broker.serviceSequenceManager().afterStore(this, classDescriptor, object);
        }
    }
}

