/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.otm.core;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.apache.commons.collections.iterators.ArrayIterator;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.accesslayer.ConnectionManagerIF;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.core.proxy.CollectionProxyDefaultImpl;
import org.apache.ojb.broker.core.proxy.CollectionProxyListener;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.ListProxyDefaultImpl;
import org.apache.ojb.broker.core.proxy.MaterializationListener;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.core.proxy.SetProxyDefaultImpl;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.otm.EditingContext;
import org.apache.ojb.otm.OTMKit;
import org.apache.ojb.otm.copy.ObjectCopyStrategy;
import org.apache.ojb.otm.core.LockingPassthruException;
import org.apache.ojb.otm.core.Transaction;
import org.apache.ojb.otm.core.TransactionAbortedException;
import org.apache.ojb.otm.lock.LockManager;
import org.apache.ojb.otm.lock.LockingException;
import org.apache.ojb.otm.states.State;
import org.apache.ojb.otm.swizzle.Swizzling;

public class ConcreteEditingContext
implements EditingContext,
MaterializationListener,
ObjectCache {
    private static HashMap _withBidirAsscMap = new HashMap();
    private static HashMap _withoutBidirAsscMap = new HashMap();
    private HashSet _withBidirAssc;
    private HashSet _withoutBidirAssc;
    private HashMap _objects;
    private ArrayList _order;
    private Transaction _tx;
    private PersistenceBroker _pb;
    private HashMap _original;
    private HashMap _checkpointed;
    private HashMap _colProxyListeners;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Set;

    public ConcreteEditingContext(Transaction tx, PersistenceBroker pb) {
        this._tx = tx;
        this._pb = pb;
        this._objects = new HashMap();
        this._order = new ArrayList();
        this._original = new HashMap();
        this._checkpointed = this._original;
        PBKey pbkey = this._pb.getPBKey();
        this._withoutBidirAssc = (HashSet)_withoutBidirAsscMap.get(pbkey);
        if (this._withoutBidirAssc != null) {
            this._withBidirAssc = (HashSet)_withBidirAsscMap.get(pbkey);
        } else {
            this._withoutBidirAssc = new HashSet();
            _withoutBidirAsscMap.put(pbkey, this._withoutBidirAssc);
            this._withBidirAssc = new HashSet();
            _withBidirAsscMap.put(pbkey, this._withBidirAssc);
        }
    }

    public void insert(Identity oid, Object userObject, int lock) throws LockingException {
        ContextEntry entry = this.insertInternal(oid, userObject, lock, true, null, new Stack());
        if (entry != null && entry.state.needsDelete()) {
            entry.state = State.PERSISTENT_CLEAN;
        }
    }

    private ContextEntry insertInternal(Identity oid, Object userObject, int lock, boolean canCreate, Identity insertBeforeThis, Stack stack) throws LockingException {
        IndirectionHandler handler = null;
        OTMKit kit = this._tx.getKit();
        boolean buildingObject = false;
        boolean lazySwizzle = false;
        if (lock == 0) {
            return null;
        }
        ContextEntry entry = (ContextEntry)this._objects.get(oid);
        if (userObject == null) {
            this._original.remove(oid);
            this._checkpointed.remove(oid);
            if (entry != null) {
                entry.userObject = null;
                entry.cacheObject = null;
            }
            return entry;
        }
        LockManager lockManager = LockManager.getInstance();
        Swizzling swizzlingStrategy = kit.getSwizzlingStrategy();
        handler = ProxyHelper.getIndirectionHandler(userObject);
        if (handler != null && handler.alreadyMaterialized()) {
            userObject = handler.getRealSubject();
            handler = null;
        }
        if (entry == null || entry.userObject == null) {
            Object swizzledObject = swizzlingStrategy.swizzle(userObject, null, this._pb, this);
            entry = new ContextEntry(swizzledObject);
            if (entry.handler != null) {
                ObjectCopyStrategy copyStrategy = this._tx.getKit().getCopyStrategy(oid);
                entry.cacheObject = copyStrategy.copy(userObject, this._pb);
                this._objects.put(oid, entry);
                lockManager.ensureLock(oid, this._tx, lock, this._pb);
                entry.handler.addListener(this);
            } else {
                Object origCacheObj = this._pb.getObjectByIdentity(oid);
                if (origCacheObj == null && !canCreate) {
                    throw new IllegalStateException("Related object is neither persistent, nor otm-depentent: " + oid);
                }
                if (origCacheObj != null) {
                    entry.cacheObject = origCacheObj;
                }
                buildingObject = true;
                this._objects.put(oid, entry);
                lockManager.ensureLock(oid, this._tx, lock, this._pb);
                if (userObject != null) {
                    if (origCacheObj == null && canCreate) {
                        ObjectCopyStrategy copyStrategy = this._tx.getKit().getCopyStrategy(oid);
                        entry.cacheObject = copyStrategy.copy(userObject, this._pb);
                        entry.state = State.PERSISTENT_NEW;
                        if (kit.isEagerInsert(userObject) || this.hasBidirectionalAssociation(userObject.getClass())) {
                            this._pb.store(entry.cacheObject, entry.state);
                            entry.state = State.PERSISTENT_CLEAN;
                            origCacheObj = entry.cacheObject;
                        }
                    }
                    if (origCacheObj != null) {
                        this._original.put(oid, this.getFields(userObject, false, true));
                    }
                }
            }
            if (insertBeforeThis != null) {
                int insertIndex = this._order.indexOf(insertBeforeThis);
                this._order.add(insertIndex, oid);
            } else {
                this._order.add(oid);
            }
        } else {
            lockManager.ensureLock(oid, this._tx, lock, this._pb);
            if (handler == null && !swizzlingStrategy.isSameInstance(entry.userObject, userObject)) {
                if (entry.handler != null) {
                    entry.userObject = entry.handler.getRealSubject();
                    entry.handler = null;
                }
                lazySwizzle = true;
            }
        }
        if (handler == null && !stack.contains(userObject)) {
            stack.push(userObject);
            this.lockReachableObjects(oid, userObject, entry.cacheObject, lock, stack, buildingObject);
            stack.pop();
            if (lazySwizzle) {
                entry.userObject = swizzlingStrategy.swizzle(userObject, entry.userObject, this._pb, this);
            }
        }
        return entry;
    }

    /*
     * WARNING - void declaration
     */
    private void lockReachableObjects(Identity oid, Object userObject, Object cacheObject, int lock, Stack stack, boolean buildingObject) throws LockingException {
        Identity relOid;
        ContextEntry entry;
        PersistentField f;
        Object relUserObj;
        boolean isDependent;
        boolean onlyDependants = !this._tx.getKit().isImplicitLockingUsed();
        ClassDescriptor mif = this._pb.getClassDescriptor(userObject.getClass());
        Iterator iter = mif.getObjectReferenceDescriptors().iterator();
        ObjectReferenceDescriptor rds = null;
        while (iter.hasNext()) {
            rds = (ObjectReferenceDescriptor)iter.next();
            isDependent = rds.getOtmDependent();
            if (onlyDependants && !isDependent || (relUserObj = (f = rds.getPersistentField()).get(userObject)) == null || (entry = (ContextEntry)this._objects.get(relOid = new Identity(relUserObj, this._pb))) != null && entry.userObject == relUserObj) continue;
            entry = this.insertInternal(relOid, relUserObj, lock, isDependent, oid, stack);
            if (!buildingObject || entry == null) continue;
            f.set(userObject, entry.userObject);
            f.set(cacheObject, entry.cacheObject);
        }
        Iterator collections = mif.getCollectionDescriptors().iterator();
        ArrayList<Object> newUserCol = null;
        ArrayList<Object> newCacheCol = null;
        while (collections.hasNext()) {
            void var19_21;
            ArrayIterator userColIterator;
            Object userCol;
            CollectionDescriptor cds = (CollectionDescriptor)collections.next();
            f = cds.getPersistentField();
            Class type = f.getType();
            isDependent = cds.getOtmDependent();
            if (onlyDependants && !isDependent || (userCol = f.get(userObject)) == null || userCol instanceof CollectionProxyDefaultImpl && !((CollectionProxyDefaultImpl)userCol).isLoaded()) continue;
            if (buildingObject) {
                newUserCol = new ArrayList<Object>();
                newCacheCol = new ArrayList<Object>();
            }
            if ((class$java$util$Collection == null ? ConcreteEditingContext.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom(type)) {
                userColIterator = ((Collection)userCol).iterator();
            } else if (type.isArray()) {
                userColIterator = new ArrayIterator(userCol);
            } else {
                throw new OJBRuntimeException(userCol.getClass() + " can not be managed by OJB OTM, use Array or Collection instead !");
            }
            while (var19_21.hasNext()) {
                relUserObj = var19_21.next();
                relOid = new Identity(relUserObj, this._pb);
                entry = (ContextEntry)this._objects.get(relOid);
                if (entry == null || entry.userObject != relUserObj) {
                    entry = this.insertInternal(relOid, relUserObj, lock, isDependent, null, stack);
                }
                if (!buildingObject || entry == null) continue;
                newUserCol.add(entry.userObject);
                newCacheCol.add(entry.cacheObject);
            }
            if (!buildingObject) continue;
            this.setCollectionField(userObject, f, newUserCol);
            this.setCollectionField(cacheObject, f, newCacheCol);
        }
    }

    public void remove(Identity oid) {
        this._objects.remove(oid);
        this._order.remove(oid);
        LockManager.getInstance().releaseLock(oid, this._tx);
    }

    public void deletePersistent(Identity oid, Object userObject) throws LockingException {
        ContextEntry entry = this.insertInternal(oid, userObject, 2, true, null, new Stack());
        if (entry != null) {
            entry.state = entry.state.deletePersistent();
        }
        this._order.remove(oid);
        this._order.add(oid);
    }

    public Object lookup(Identity oid) {
        ContextEntry entry = (ContextEntry)this._objects.get(oid);
        return entry == null ? null : entry.userObject;
    }

    public boolean contains(Identity oid) {
        return this.lookup(oid) != null;
    }

    public State lookupState(Identity oid) throws LockingException {
        State retval = null;
        ContextEntry entry = (ContextEntry)this._objects.get(oid);
        if (entry != null) {
            retval = entry.state;
        }
        return retval;
    }

    public void setState(Identity oid, State state) {
        ContextEntry entry = (ContextEntry)this._objects.get(oid);
        entry.state = state;
    }

    public Collection getAllObjectsInContext() {
        return this._objects.values();
    }

    public void beforeMaterialization(IndirectionHandler handler, Identity oid) {
    }

    public void afterMaterialization(IndirectionHandler handler, Object cacheObject) {
        Identity oid = handler.getIdentity();
        ContextEntry entry = (ContextEntry)this._objects.get(oid);
        if (entry == null) {
            return;
        }
        int lock = LockManager.getInstance().getLockHeld(oid, this._tx);
        ObjectCopyStrategy copyStrategy = this._tx.getKit().getCopyStrategy(oid);
        Object userObject = copyStrategy.copy(cacheObject, this._pb);
        handler.setRealSubject(userObject);
        this._original.put(oid, this.getFields(userObject, false, true));
        entry.userObject = userObject;
        entry.cacheObject = cacheObject;
        entry.handler.removeListener(this);
        entry.handler = null;
        try {
            this.lockReachableObjects(oid, userObject, cacheObject, lock, new Stack(), true);
        }
        catch (LockingException ex) {
            throw new LockingPassthruException(ex);
        }
    }

    public void commit() throws TransactionAbortedException {
        this.checkpointInternal(true);
        this.releaseLocksAndClear();
    }

    private void releaseLocksAndClear() {
        this.releaseLocks();
        this.removeMaterializationListener();
        this._objects.clear();
        this._order.clear();
        this._original.clear();
        if (this._checkpointed != this._original) {
            this._checkpointed.clear();
        }
    }

    public void checkpoint() throws TransactionAbortedException {
        this.checkpointInternal(false);
        this._checkpointed = new HashMap();
        Iterator iterator = this._order.iterator();
        while (iterator.hasNext()) {
            Identity oid = (Identity)iterator.next();
            ContextEntry entry = (ContextEntry)this._objects.get(oid);
            if (entry.handler != null) continue;
            this._checkpointed.put(oid, this.getFields(entry.userObject, false, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkpointInternal(boolean isCommit) throws TransactionAbortedException {
        if (this._order.size() == 0) {
            return;
        }
        this.removeCollectionProxyListeners();
        ConnectionManagerIF connMan = this._pb.serviceConnectionManager();
        boolean saveBatchMode = connMan.isBatchMode();
        Swizzling swizzlingStrategy = this._tx.getKit().getSwizzlingStrategy();
        LockManager lockManager = LockManager.getInstance();
        Identity[] lockOrder = this._order.toArray(new Identity[this._order.size()]);
        ObjectCache cache = this._pb.serviceObjectCache();
        boolean isInsertVerified = this._tx.getKit().isInsertVerified();
        ArrayList<Identity> changedCollections = new ArrayList<Identity>();
        Arrays.sort(lockOrder, new Comparator(){

            public int compare(Object o1, Object o2) {
                return o1.hashCode() - o2.hashCode();
            }

            public boolean equals(Object obj) {
                return false;
            }
        });
        try {
            ContextEntry entry;
            Identity oid;
            Iterator it;
            int countCascadeDeleted;
            ContextEntry entry2;
            Identity oid2;
            int countNewObjects;
            ArrayList newObjects = new ArrayList();
            do {
                newObjects.clear();
                countNewObjects = 0;
                for (int i = 0; i < lockOrder.length; ++i) {
                    oid2 = lockOrder[i];
                    entry2 = (ContextEntry)this._objects.get(oid2);
                    State state = entry2.state;
                    if (entry2.userObject == null || entry2.handler != null || state.isDeleted()) continue;
                    Object[][] origFields = (Object[][])this._checkpointed.get(oid2);
                    Object[][] newFields = this.getFields(entry2.userObject, true, !isCommit);
                    if (origFields == null) {
                        entry2.needsCacheSwizzle = true;
                        newObjects.addAll(this.handleDependentReferences(oid2, entry2.userObject, null, newFields[0], newFields[2]));
                        newObjects.addAll(this.handleDependentCollections(oid2, entry2.userObject, null, newFields[1], newFields[3]));
                        continue;
                    }
                    if (this.isModified(origFields[0], newFields[0])) {
                        entry2.state = state.markDirty();
                        entry2.needsCacheSwizzle = true;
                        lockManager.ensureLock(oid2, this._tx, 2, this._pb);
                        newObjects.addAll(this.handleDependentReferences(oid2, entry2.userObject, origFields[0], newFields[0], newFields[2]));
                    }
                    if (!this.isModified(origFields[1], newFields[1])) continue;
                    entry2.needsCacheSwizzle = true;
                    lockManager.ensureLock(oid2, this._tx, 2, this._pb);
                    newObjects.addAll(this.handleDependentCollections(oid2, entry2.userObject, origFields[1], newFields[1], newFields[3]));
                    changedCollections.add(oid2);
                }
                countNewObjects = newObjects.size();
                if (countNewObjects <= 0) continue;
                lockOrder = newObjects.toArray(new Identity[countNewObjects]);
            } while (countNewObjects > 0);
            Iterator it2 = this._order.iterator();
            while (it2.hasNext()) {
                oid2 = (Identity)it2.next();
                entry2 = (ContextEntry)this._objects.get(oid2);
                if (!entry2.needsCacheSwizzle) continue;
                entry2.userObject = swizzlingStrategy.getRealTarget(entry2.userObject);
                entry2.cacheObject = swizzlingStrategy.swizzle(entry2.userObject, entry2.cacheObject, this._pb, new ObjectCache(){

                    public Object lookup(Identity anOid) {
                        ContextEntry ent = (ContextEntry)ConcreteEditingContext.this._objects.get(anOid);
                        return ent == null ? null : ent.cacheObject;
                    }

                    public boolean contains(Identity oid) {
                        return this.lookup(oid) != null;
                    }

                    public void cache(Identity anOid, Object obj) {
                    }

                    public boolean cacheIfNew(Identity oid, Object obj) {
                        return false;
                    }

                    public void clear() {
                    }

                    public void remove(Identity anOid) {
                    }
                });
            }
            do {
                countCascadeDeleted = 0;
                it = new ArrayList(this._order).iterator();
                while (it.hasNext()) {
                    oid = (Identity)it.next();
                    entry = (ContextEntry)this._objects.get(oid);
                    if (!entry.state.isDeleted()) continue;
                    countCascadeDeleted += this.doCascadeDelete(oid, entry.userObject);
                }
            } while (countCascadeDeleted > 0);
            connMan.setBatchMode(true);
            try {
                it = this._order.iterator();
                while (it.hasNext()) {
                    oid = (Identity)it.next();
                    entry = (ContextEntry)this._objects.get(oid);
                    State state = entry.state;
                    if (!(state.needsInsert() || state.needsUpdate() || state.needsDelete())) {
                        if (!changedCollections.contains(oid)) continue;
                        this._pb.store(entry.cacheObject, state);
                        continue;
                    }
                    if (state.needsInsert()) {
                        if (isInsertVerified) {
                            this._pb.store(entry.cacheObject);
                        } else if (cache.lookup(oid) == null) {
                            this._pb.store(entry.cacheObject, state);
                        }
                    } else if (state.needsUpdate()) {
                        this._pb.store(entry.cacheObject, state);
                    } else if (state.needsDelete()) {
                        this._pb.delete(entry.cacheObject);
                    }
                    entry.state = state.commit();
                }
                connMan.executeBatch();
            }
            finally {
                connMan.setBatchMode(saveBatchMode);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new TransactionAbortedException(ex);
        }
    }

    public void rollback() {
        Iterator iterator = this._order.iterator();
        while (iterator.hasNext()) {
            Identity oid = (Identity)iterator.next();
            ContextEntry entry = (ContextEntry)this._objects.get(oid);
            entry.state = entry.state.rollback();
            Object[][] origFields = (Object[][])this._original.get(oid);
            if (origFields == null) continue;
            this.setFields(entry.userObject, origFields);
            this.setFields(entry.cacheObject, origFields);
        }
        this.releaseLocksAndClear();
    }

    public void refresh(Identity oid, Object object) {
        ContextEntry entry = (ContextEntry)this._objects.get(oid);
        Object[][] origFields = (Object[][])this._original.get(oid);
        if (origFields != null) {
            this.setFields(entry.userObject, origFields);
            if (object != entry.userObject) {
                this.setFields(object, origFields);
            }
        }
        entry.state = entry.state.refresh();
    }

    private void removeMaterializationListener() {
        Iterator it = this._order.iterator();
        while (it.hasNext()) {
            Identity oid = (Identity)it.next();
            ContextEntry entry = (ContextEntry)this._objects.get(oid);
            if (entry.handler == null) continue;
            entry.handler.removeListener(this);
        }
    }

    private void removeCollectionProxyListeners() {
        if (this._colProxyListeners != null) {
            Iterator it = this._colProxyListeners.keySet().iterator();
            while (it.hasNext()) {
                CollectionProxyListener listener = (CollectionProxyListener)it.next();
                CollectionProxyDefaultImpl colProxy = (CollectionProxyDefaultImpl)this._colProxyListeners.get(listener);
                colProxy.removeListener(listener);
            }
            this._colProxyListeners.clear();
        }
    }

    private void releaseLocks() {
        LockManager lockManager = LockManager.getInstance();
        Iterator it = this._objects.keySet().iterator();
        while (it.hasNext()) {
            Identity oid = (Identity)it.next();
            lockManager.releaseLock(oid, this._tx);
        }
        this._tx.getKit().getLockMap().gc();
    }

    private boolean isEqual(Object fld1, Object fld2) {
        if (fld1 == null || fld2 == null) {
            return fld1 == fld2;
        }
        if (fld1 instanceof BigDecimal && fld2 instanceof BigDecimal) {
            return ((BigDecimal)fld1).compareTo((BigDecimal)fld2) == 0;
        }
        if (fld1 instanceof Date && fld2 instanceof Date) {
            return ((Date)fld1).getTime() == ((Date)fld2).getTime();
        }
        return fld1.equals(fld2);
    }

    private boolean isModified(Object[] newFields, Object[] oldFields) {
        if (newFields.length != oldFields.length) {
            return true;
        }
        for (int i = 0; i < newFields.length; ++i) {
            if (this.isEqual(newFields[i], oldFields[i])) continue;
            return true;
        }
        return false;
    }

    private Object[][] getFields(Object obj, boolean withObjects, boolean addListeners) {
        PersistentField f;
        ClassDescriptor mif = this._pb.getClassDescriptor(obj.getClass());
        FieldDescriptor[] fieldDescs = mif.getFieldDescriptions();
        Vector refDescs = mif.getObjectReferenceDescriptors();
        Vector colDescs = mif.getCollectionDescriptors();
        int count = 0;
        Object[] fields = new Object[1 + fieldDescs.length + refDescs.size()];
        ArrayList[] collections = new ArrayList[colDescs.size()];
        Object[] references = null;
        ArrayList[] collectionsOfObjects = null;
        int lockForListeners = 0;
        if (withObjects) {
            references = new Object[refDescs.size()];
            collectionsOfObjects = new ArrayList[colDescs.size()];
        }
        if (addListeners) {
            lockForListeners = LockManager.getInstance().getLockHeld(new Identity(obj, this._pb), this._tx);
        }
        fields[0] = obj.getClass();
        ++count;
        for (int i = 0; i < fieldDescs.length; ++i) {
            FieldDescriptor fd = fieldDescs[i];
            PersistentField f2 = fd.getPersistentField();
            fields[count] = f2.get(obj);
            ++count;
        }
        int countRefs = 0;
        Iterator it = refDescs.iterator();
        while (it.hasNext()) {
            ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)it.next();
            f = rds.getPersistentField();
            Object relObj = f.get(obj);
            if (relObj != null) {
                fields[count] = new Identity(relObj, this._pb);
                if (withObjects) {
                    references[countRefs] = relObj;
                }
            }
            ++count;
            ++countRefs;
        }
        count = 0;
        it = colDescs.iterator();
        while (it.hasNext()) {
            block16: {
                ArrayIterator colIterator;
                ArrayList listOfObjects;
                ArrayList<Identity> list;
                block18: {
                    Object col;
                    Class type;
                    block17: {
                        block15: {
                            CollectionDescriptor cds = (CollectionDescriptor)it.next();
                            f = cds.getPersistentField();
                            type = f.getType();
                            col = f.get(obj);
                            if (col == null || !(col instanceof CollectionProxyDefaultImpl) || ((CollectionProxyDefaultImpl)col).isLoaded()) break block15;
                            if (addListeners) {
                                OTMCollectionProxyListener listener = new OTMCollectionProxyListener(cds, collections, count, lockForListeners);
                                ((CollectionProxyDefaultImpl)col).addListener(listener);
                                if (this._colProxyListeners == null) {
                                    this._colProxyListeners = new HashMap();
                                }
                                this._colProxyListeners.put(listener, col);
                            }
                            break block16;
                        }
                        if (col == null) break block16;
                        list = new ArrayList<Identity>();
                        listOfObjects = null;
                        collections[count] = list;
                        if (withObjects) {
                            collectionsOfObjects[count] = listOfObjects = new ArrayList();
                        }
                        if (!(class$java$util$Collection == null ? ConcreteEditingContext.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom(type)) break block17;
                        colIterator = ((Collection)col).iterator();
                        break block18;
                    }
                    if (!type.isArray()) break block16;
                    colIterator = new ArrayIterator(col);
                }
                while (colIterator.hasNext()) {
                    Object relObj = colIterator.next();
                    list.add(new Identity(relObj, this._pb));
                    if (!withObjects) continue;
                    listOfObjects.add(relObj);
                }
            }
            ++count;
        }
        return new Object[][]{fields, collections, references, collectionsOfObjects};
    }

    private void setFields(Object obj, Object[][] fieldsAndCollections) {
        PersistentField f;
        ClassDescriptor mif = this._pb.getClassDescriptor(obj.getClass());
        FieldDescriptor[] fieldDescs = mif.getFieldDescriptions();
        Vector refDescs = mif.getObjectReferenceDescriptors();
        Vector colDescs = mif.getCollectionDescriptors();
        Object[] fields = fieldsAndCollections[0];
        ArrayList[] collections = (ArrayList[])fieldsAndCollections[1];
        int count = 0;
        if (!fields[0].equals(obj.getClass())) {
            System.err.println("Can't restore the object fields since its class changed during transaction from " + fields[0] + " to " + obj.getClass());
            return;
        }
        ++count;
        for (int i = 0; i < fieldDescs.length; ++i) {
            FieldDescriptor fd = fieldDescs[i];
            f = fd.getPersistentField();
            f.set(obj, fields[count]);
            ++count;
        }
        Iterator it = refDescs.iterator();
        while (it.hasNext()) {
            ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)it.next();
            f = rds.getPersistentField();
            Identity oid = (Identity)fields[count];
            Object relObj = oid == null ? null : this._pb.getObjectByIdentity(oid);
            f.set(obj, relObj);
            ++count;
        }
        count = 0;
        it = colDescs.iterator();
        while (it.hasNext()) {
            CollectionDescriptor cds = (CollectionDescriptor)it.next();
            f = cds.getPersistentField();
            ArrayList list = collections[count];
            if (list == null) {
                f.set(obj, null);
            } else {
                ArrayList<Object> newCol = new ArrayList<Object>();
                Iterator it2 = list.iterator();
                while (it2.hasNext()) {
                    Identity relOid = (Identity)it2.next();
                    Object relObj = this._pb.getObjectByIdentity(relOid);
                    if (relObj == null) continue;
                    newCol.add(relObj);
                }
                this.setCollectionField(obj, f, newCol);
            }
            ++count;
        }
    }

    private void setCollectionField(Object obj, PersistentField f, List newCol) {
        Class type;
        if ((class$java$util$Collection == null ? (class$java$util$Collection = ConcreteEditingContext.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(type = f.getType())) {
            Collection col = (ArrayList)f.get(obj);
            if (col == null) {
                if (type == (class$java$util$List == null ? (class$java$util$List = ConcreteEditingContext.class$("java.util.List")) : class$java$util$List) || type == (class$java$util$Collection == null ? (class$java$util$Collection = ConcreteEditingContext.class$("java.util.Collection")) : class$java$util$Collection)) {
                    col = new ArrayList();
                } else if (type == (class$java$util$Set == null ? (class$java$util$Set = ConcreteEditingContext.class$("java.util.Set")) : class$java$util$Set)) {
                    col = new HashSet();
                } else {
                    try {
                        col = (Collection)type.newInstance();
                    }
                    catch (Throwable ex) {
                        System.err.println("Cannot instantiate collection field: " + f);
                        ex.printStackTrace();
                        return;
                    }
                }
            } else if (col instanceof CollectionProxyDefaultImpl) {
                CollectionProxyDefaultImpl cp = (CollectionProxyDefaultImpl)col;
                col = col instanceof List ? new ListProxyDefaultImpl(this._pb.getPBKey(), cp.getData().getClass(), null) : (col instanceof Set ? new SetProxyDefaultImpl(this._pb.getPBKey(), cp.getData().getClass(), null) : new CollectionProxyDefaultImpl(this._pb.getPBKey(), cp.getData().getClass(), null));
                col.clear();
            } else {
                try {
                    col = (Collection)col.getClass().newInstance();
                }
                catch (Exception ex) {
                    System.err.println("Cannot instantiate collection field: " + f);
                    ex.printStackTrace();
                    return;
                }
            }
            col.addAll(newCol);
            f.set(obj, col);
        } else if (type.isArray()) {
            int length = newCol.size();
            Object array = Array.newInstance(type.getComponentType(), length);
            for (int i = 0; i < length; ++i) {
                Array.set(array, i, newCol.get(i));
            }
            f.set(obj, array);
        }
    }

    private boolean hasBidirectionalAssociation(Class clazz) {
        if (this._withoutBidirAssc.contains(clazz)) {
            return false;
        }
        if (this._withBidirAssc.contains(clazz)) {
            return true;
        }
        ClassDescriptor cdesc = this._pb.getClassDescriptor(clazz);
        Vector refs = cdesc.getObjectReferenceDescriptors();
        boolean hasBidirAssc = false;
        Iterator it = refs.iterator();
        block0: while (it.hasNext()) {
            ObjectReferenceDescriptor ord = (ObjectReferenceDescriptor)it.next();
            ClassDescriptor relCDesc = this._pb.getClassDescriptor(ord.getItemClass());
            Vector relRefs = relCDesc.getObjectReferenceDescriptors();
            Iterator relIt = relRefs.iterator();
            while (relIt.hasNext()) {
                ObjectReferenceDescriptor relOrd = (ObjectReferenceDescriptor)relIt.next();
                if (!relOrd.getItemClass().equals(clazz)) continue;
                hasBidirAssc = true;
                break block0;
            }
        }
        if (hasBidirAssc) {
            this._withBidirAssc.add(clazz);
        } else {
            this._withoutBidirAssc.add(clazz);
        }
        return hasBidirAssc;
    }

    private int markDelete(Identity oid, Identity mainOid, boolean isCollection) {
        ContextEntry entry = (ContextEntry)this._objects.get(oid);
        if (entry == null) {
            throw new IllegalStateException("markDelete failed: the dependent object " + oid + " is not in the editing context");
        }
        if (entry.state.isDeleted()) {
            return 0;
        }
        entry.state = entry.state.deletePersistent();
        if (mainOid != null) {
            int dependentIndex = this._order.indexOf(oid);
            int mainIndex = this._order.indexOf(mainOid);
            if (isCollection) {
                if (dependentIndex > mainIndex) {
                    this._order.remove(dependentIndex);
                    this._order.add(mainIndex, oid);
                }
            } else if (dependentIndex < mainIndex) {
                this._order.remove(dependentIndex);
                this._order.add(mainIndex, oid);
            }
        }
        return 1;
    }

    private ArrayList handleDependentReferences(Identity oid, Object userObject, Object[] origFields, Object[] newFields, Object[] newRefs) throws LockingException {
        ClassDescriptor mif = this._pb.getClassDescriptor(userObject.getClass());
        FieldDescriptor[] fieldDescs = mif.getFieldDescriptions();
        Vector refDescs = mif.getObjectReferenceDescriptors();
        int count = 1 + fieldDescs.length;
        ArrayList<Identity> newObjects = new ArrayList<Identity>();
        int countRefs = 0;
        Iterator it = refDescs.iterator();
        while (it.hasNext()) {
            ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)it.next();
            Identity origOid = origFields == null ? null : (Identity)origFields[count];
            Identity newOid = (Identity)newFields[count];
            if (rds.getOtmDependent()) {
                if (origOid == null && newOid != null) {
                    ContextEntry entry = (ContextEntry)this._objects.get(newOid);
                    if (entry == null) {
                        Object relObj = newRefs[countRefs];
                        this.insertInternal(newOid, relObj, 2, true, oid, new Stack());
                        newObjects.add(newOid);
                    }
                } else if (!(origOid == null || newOid != null && newOid.equals(origOid))) {
                    this.markDelete(origOid, oid, false);
                }
            }
            ++count;
            ++countRefs;
        }
        return newObjects;
    }

    private ArrayList handleDependentCollections(Identity oid, Object obj, Object[] origCollections, Object[] newCollections, Object[] newCollectionsOfObjects) throws LockingException {
        ClassDescriptor mif = this._pb.getClassDescriptor(obj.getClass());
        Vector colDescs = mif.getCollectionDescriptors();
        ArrayList<Identity> newObjects = new ArrayList<Identity>();
        int count = 0;
        Iterator it = colDescs.iterator();
        while (it.hasNext()) {
            CollectionDescriptor cds = (CollectionDescriptor)it.next();
            if (cds.getOtmDependent()) {
                ArrayList origList = origCollections == null ? null : (ArrayList)origCollections[count];
                ArrayList newList = (ArrayList)newCollections[count];
                if (origList != null) {
                    Iterator it2 = origList.iterator();
                    while (it2.hasNext()) {
                        Identity origOid = (Identity)it2.next();
                        if (newList != null && newList.contains(origOid)) continue;
                        this.markDelete(origOid, oid, true);
                    }
                }
                if (newList != null) {
                    int countElem = 0;
                    Iterator it2 = newList.iterator();
                    while (it2.hasNext()) {
                        ContextEntry entry;
                        Identity newOid = (Identity)it2.next();
                        if (!(origList != null && origList.contains(newOid) || (entry = (ContextEntry)this._objects.get(newOid)) != null)) {
                            ArrayList relCol = (ArrayList)newCollectionsOfObjects[count];
                            Object relObj = relCol.get(countElem);
                            this.insertInternal(newOid, relObj, 2, true, null, new Stack());
                            newObjects.add(newOid);
                        }
                        ++countElem;
                    }
                }
            }
            ++count;
        }
        return newObjects;
    }

    private int doCascadeDelete(Identity oid, Object obj) {
        PersistentField f;
        ClassDescriptor mif = this._pb.getClassDescriptor(ProxyHelper.getRealClass(obj));
        Vector refDescs = mif.getObjectReferenceDescriptors();
        Vector colDescs = mif.getCollectionDescriptors();
        int countCascadeDeleted = 0;
        Iterator it = refDescs.iterator();
        while (it.hasNext()) {
            Object relObj;
            ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)it.next();
            if (!rds.getOtmDependent() || (relObj = (f = rds.getPersistentField()).get(obj)) == null) continue;
            countCascadeDeleted += this.markDelete(new Identity(relObj, this._pb), oid, false);
        }
        it = colDescs.iterator();
        while (it.hasNext()) {
            ArrayIterator colIterator;
            CollectionDescriptor cds = (CollectionDescriptor)it.next();
            if (!cds.getOtmDependent()) continue;
            f = cds.getPersistentField();
            Class type = f.getType();
            Object col = f.get(obj);
            if (col == null) continue;
            if ((class$java$util$Collection == null ? ConcreteEditingContext.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom(type)) {
                colIterator = ((Collection)col).iterator();
            } else {
                if (!type.isArray()) continue;
                colIterator = new ArrayIterator(col);
            }
            while (colIterator.hasNext()) {
                countCascadeDeleted += this.markDelete(new Identity(colIterator.next(), this._pb), oid, true);
            }
        }
        return countCascadeDeleted;
    }

    public void cache(Identity oid, Object obj) {
        throw new UnsupportedOperationException();
    }

    public boolean cacheIfNew(Identity oid, Object obj) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class OTMCollectionProxyListener
    implements CollectionProxyListener {
        private final CollectionDescriptor _cds;
        private final ArrayList[] _collections;
        private final int _index;
        private final int _lock;

        OTMCollectionProxyListener(CollectionDescriptor cds, ArrayList[] collections, int index, int lock) {
            this._cds = cds;
            this._collections = collections;
            this._index = index;
            this._lock = lock;
        }

        public void beforeLoading(CollectionProxyDefaultImpl colProxy) {
        }

        public void afterLoading(CollectionProxyDefaultImpl colProxy) {
            ArrayList<Identity> list = new ArrayList<Identity>();
            ArrayList<Object> newUserCol = new ArrayList<Object>();
            LockManager lockManager = LockManager.getInstance();
            this._collections[this._index] = list;
            Iterator it = colProxy.iterator();
            while (it.hasNext()) {
                Object relUserObj;
                Object relCacheObj = it.next();
                Identity relOid = new Identity(relCacheObj, ConcreteEditingContext.this._pb);
                list.add(relOid);
                ContextEntry entry = (ContextEntry)ConcreteEditingContext.this._objects.get(relOid);
                if (entry != null) {
                    relUserObj = entry.userObject;
                } else {
                    ObjectCopyStrategy copyStrategy = ConcreteEditingContext.this._tx.getKit().getCopyStrategy(relOid);
                    relUserObj = copyStrategy.copy(relCacheObj, ConcreteEditingContext.this._pb);
                    try {
                        entry = ConcreteEditingContext.this.insertInternal(relOid, relUserObj, this._lock, this._cds.getOtmDependent(), null, new Stack());
                        if (entry != null) {
                            relUserObj = entry.userObject;
                        }
                    }
                    catch (LockingException ex) {
                        throw new LockingPassthruException(ex);
                    }
                }
                newUserCol.add(relUserObj);
            }
            colProxy.clear();
            colProxy.addAll(newUserCol);
        }
    }

    private static class ContextEntry {
        Object userObject;
        Object cacheObject;
        State state = State.PERSISTENT_CLEAN;
        IndirectionHandler handler;
        boolean needsCacheSwizzle;

        ContextEntry(Object theUserObject) {
            this.userObject = theUserObject;
            if (this.userObject != null) {
                this.handler = ProxyHelper.getIndirectionHandler(this.userObject);
                if (this.handler != null && this.handler.alreadyMaterialized()) {
                    this.userObject = this.handler.getRealSubject();
                    this.handler = null;
                }
            }
        }
    }
}

