/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.locking;

import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.locking.LockManager;
import org.apache.ojb.odmg.locking.LockManagerOdmgImpl;

public class LockManagerFactory {
    private static LockManagerFactory lockManagerFactory = null;
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$locking$LockManagerFactory == null ? (class$org$apache$ojb$odmg$locking$LockManagerFactory = LockManagerFactory.class$("org.apache.ojb.odmg.locking.LockManagerFactory")) : class$org$apache$ojb$odmg$locking$LockManagerFactory);
    private LockManager lockManager;
    static /* synthetic */ Class class$org$apache$ojb$odmg$locking$LockManagerFactory;
    static /* synthetic */ Class class$org$apache$ojb$odmg$locking$LockManager;

    private LockManagerFactory() {
        this.init();
    }

    private void init() {
        Configuration conf = OjbConfigurator.getInstance().getConfigurationFor(null);
        Class lockMapClass = conf.getClass("LockMapClass", null);
        Class lockManagerClass = conf.getClass("LockManagerClass", null);
        if (lockManagerClass == null) {
            throw new OJBRuntimeException(this.buildErrorMsg(lockMapClass, lockManagerClass));
        }
        if (lockMapClass != null) {
            this.log.info("Setup *deprecated* odmg-locking api.");
            this.log.info("Used LockManagerClass=" + lockManagerClass);
            this.log.info("Used LockMapClass=" + lockMapClass);
            if (!(class$org$apache$ojb$odmg$locking$LockManager == null ? (class$org$apache$ojb$odmg$locking$LockManager = LockManagerFactory.class$("org.apache.ojb.odmg.locking.LockManager")) : class$org$apache$ojb$odmg$locking$LockManager).isAssignableFrom(lockManagerClass)) {
                throw new OJBRuntimeException(this.buildErrorMsg(lockMapClass, lockManagerClass));
            }
            this.setupLockManager(lockManagerClass);
        } else {
            this.log.info("Setup odmg-locking api.");
            this.log.info("Used LockManagerClass=" + lockManagerClass);
            if ((class$org$apache$ojb$odmg$locking$LockManager == null ? (class$org$apache$ojb$odmg$locking$LockManager = LockManagerFactory.class$("org.apache.ojb.odmg.locking.LockManager")) : class$org$apache$ojb$odmg$locking$LockManager).isAssignableFrom(lockManagerClass)) {
                throw new OJBRuntimeException(this.buildErrorMsg(lockMapClass, lockManagerClass));
            }
            this.setupLockManager(conf, lockManagerClass);
        }
    }

    private void setupLockManager(Configuration conf, Class lockManagerClass) {
        long timeout = conf.getInteger("LockTimeout", 60000);
        this.log.info("LockTimeout=" + timeout);
        try {
            org.apache.ojb.broker.locking.LockManager lm = (org.apache.ojb.broker.locking.LockManager)ClassHelper.newInstance(lockManagerClass);
            lm.setLockTimeout(timeout);
            this.lockManager = new LockManagerOdmgImpl(lm);
        }
        catch (Exception e) {
            throw new OJBRuntimeException("Can't setup odmg lock manager instance", e);
        }
    }

    private void setupLockManager(Class lockManagerClass) {
        try {
            this.lockManager = (LockManager)ClassHelper.newInstance(lockManagerClass);
        }
        catch (Exception e) {
            throw new OJBRuntimeException("Can't setup odmg lock manager instance", e);
        }
    }

    private String buildErrorMsg(Class lockMap, Class lockManager) {
        String eol = SystemUtils.LINE_SEPARATOR;
        StringBuffer msg = new StringBuffer("Can't setup LockManager. Current used properties are:" + eol);
        msg.append("LockMapClass=" + (lockMap != null ? lockMap.getName() : null) + eol).append("LockManagerClass=" + (lockManager != null ? lockManager.getName() : null) + eol).append("For correct setup of the lock manager, please enable the 'LockManagerClass' property").append(" in OJB configuration, OJB expects an 'org.apache.ojb.broker.locking.LockManager' implementation class.").append(eol + "Or to enable the *deprecated* odmg-locking api enable the 'LockMapClass' AND the 'LockManager' properties").append(", in this case OJB expects an 'org.apache.ojb.odmg.locking.LockManager' implementation class.");
        return msg.toString();
    }

    private LockManager getManager() {
        return this.lockManager;
    }

    public static synchronized LockManager getLockManager() {
        if (lockManagerFactory == null) {
            lockManagerFactory = new LockManagerFactory();
        }
        return lockManagerFactory.getManager();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

