/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.core.proxy.CollectionProxy;
import org.apache.ojb.broker.core.proxy.CollectionProxyDefaultImpl;
import org.apache.ojb.broker.core.proxy.CollectionProxyListener;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.MaterializationListener;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.GUID;
import org.apache.ojb.broker.util.configuration.Configurable;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.DatabaseImpl;
import org.apache.ojb.odmg.ImplementationImpl;
import org.apache.ojb.odmg.NamedRootsMap;
import org.apache.ojb.odmg.ObjectEnvelope;
import org.apache.ojb.odmg.ObjectEnvelopeTable;
import org.apache.ojb.odmg.RuntimeObject;
import org.apache.ojb.odmg.TransactionAbortedExceptionOJB;
import org.apache.ojb.odmg.TransactionExt;
import org.apache.ojb.odmg.TxUtil;
import org.apache.ojb.odmg.locking.LockManager;
import org.odmg.DatabaseClosedException;
import org.odmg.LockNotGrantedException;
import org.odmg.ODMGRuntimeException;
import org.odmg.Transaction;
import org.odmg.TransactionAbortedException;
import org.odmg.TransactionInProgressException;
import org.odmg.TransactionNotInProgressException;

public class TransactionImpl
implements Transaction,
MaterializationListener,
Configurable,
CollectionProxyListener,
TransactionExt {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$TransactionImpl == null ? (class$org$apache$ojb$odmg$TransactionImpl = TransactionImpl.class$("org.apache.ojb.odmg.TransactionImpl")) : class$org$apache$ojb$odmg$TransactionImpl);
    private boolean impliciteWriteLocks;
    private boolean implicitLocking;
    private String txGUID;
    protected PersistenceBroker broker = null;
    private ArrayList registeredForLock = new ArrayList();
    private ImplementationImpl implementation;
    private NamedRootsMap namedRootsMap;
    private int txStatus = 6;
    protected ObjectEnvelopeTable objectEnvelopeTable = null;
    private DatabaseImpl curDB;
    private ArrayList registeredIndirectionHandlers = new ArrayList();
    private ArrayList registeredCollectionProxies = new ArrayList();
    private ArrayList unmaterializedLocks = new ArrayList();
    private HashMap runtimeCascadeDeleteMap = new HashMap();
    static /* synthetic */ Class class$org$apache$ojb$odmg$TransactionImpl;

    public TransactionImpl(ImplementationImpl implementation) {
        this.implementation = implementation;
        this.impliciteWriteLocks = implementation.isImpliciteWriteLocks();
        this.implicitLocking = implementation.isImplicitLocking();
        this.txGUID = new GUID().toString();
        this.curDB = implementation.getCurrentDatabase();
        this.namedRootsMap = new NamedRootsMap(this);
    }

    public ImplementationImpl getImplementation() {
        return this.implementation;
    }

    public NamedRootsMap getNamedRootsMap() {
        return this.namedRootsMap;
    }

    public DatabaseImpl getAssociatedDatabase() {
        return this.curDB;
    }

    protected int getStatus() {
        return this.txStatus;
    }

    protected void setStatus(int status) {
        this.txStatus = status;
    }

    private void checkForDB() {
        if (this.curDB == null || !this.curDB.isOpen()) {
            this.log.error("Transaction without a associated open Database.");
            throw new TransactionAbortedExceptionOJB("No open database found. Open the database before handling transactions");
        }
    }

    public boolean isOpen() {
        return this.getStatus() == 0 || this.getStatus() == 1 || this.getStatus() == 2 || this.getStatus() == 7 || this.getStatus() == 8;
    }

    private void checkOpen() {
        if (!this.isOpen()) {
            throw new TransactionNotInProgressException("Transaction was not open, call tx.begin() before perform action, current status is: " + TxUtil.getStatusString(this.getStatus()));
        }
    }

    public void join() {
        this.checkOpen();
        this.implementation.getTxManager().deregisterTx(this);
        this.implementation.getTxManager().registerTx(this);
    }

    public void lock(Object obj, int lockMode) throws LockNotGrantedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("lock object was called on tx " + this + ", object is " + obj.toString());
        }
        this.checkOpen();
        RuntimeObject rtObject = new RuntimeObject(obj, this);
        this.lockAndRegister(rtObject, lockMode, true);
        this.registeredForLock.clear();
    }

    public void lockAndRegisterCleanup() {
        this.registeredForLock.clear();
    }

    public void lockAndRegister(RuntimeObject rtObject, int lockMode, boolean cascade) {
        if (!this.registeredForLock.contains(rtObject.getIdentity())) {
            if (cascade) {
                this.registeredForLock.add(rtObject.getIdentity());
            }
            try {
                if (!rtObject.isNew()) {
                    this.doSingleLock(rtObject.getCld(), rtObject.getObj(), rtObject.getIdentity(), lockMode);
                }
                this.register(rtObject, lockMode, cascade);
            }
            catch (Throwable t) {
                this.implementation.getLockManager().releaseLock(this, rtObject.getIdentity(), rtObject.getObj());
                if (t instanceof LockNotGrantedException) {
                    throw (LockNotGrantedException)t;
                }
                this.log.error("Unexpected failure while locking", t);
                throw new LockNotGrantedException("Locking failed for " + rtObject.getIdentity() + ", nested exception is: [" + t.getClass().getName() + ": " + t.getMessage() + "]");
            }
        }
    }

    void doSingleLock(ClassDescriptor cld, Object obj, Identity oid, int lockMode) throws LockNotGrantedException {
        LockManager lm = this.implementation.getLockManager();
        if (cld.isAcceptLocks()) {
            if (lockMode == 1) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Do READ lock on object: " + oid);
                }
                if (!lm.readLock(this, oid, obj)) {
                    throw new LockNotGrantedException("Can not lock for READ: " + oid);
                }
            } else if (lockMode == 4) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Do WRITE lock on object: " + oid);
                }
                if (!lm.writeLock(this, oid, obj)) {
                    throw new LockNotGrantedException("Can not lock for WRITE: " + oid);
                }
            } else if (lockMode == 2) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Do UPGRADE lock on object: " + oid);
                }
                if (!lm.upgradeLock(this, oid, obj)) {
                    throw new LockNotGrantedException("Can not lock for UPGRADE: " + oid);
                }
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Class '" + cld.getClassNameOfObject() + "' doesn't accept locks (specified in class-descriptor), so OJB skip this object: " + oid);
        }
    }

    public void leave() {
        this.checkOpen();
        this.implementation.getTxManager().deregisterTx(this);
    }

    protected synchronized void doWriteObjects(boolean isFlush) throws TransactionAbortedException, LockNotGrantedException {
        if (!this.getBroker().isInTransaction()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("call beginTransaction() on PB instance");
            }
            this.broker.beginTransaction();
        }
        this.performTransactionAwareBeforeCommit();
        this.objectEnvelopeTable.writeObjects(isFlush);
        this.namedRootsMap.performDeletion();
        this.namedRootsMap.performInsert();
        this.namedRootsMap.afterWriteCleanup();
    }

    protected synchronized void doAbort() {
        this.performTransactionAwareBeforeRollback();
        this.objectEnvelopeTable.rollback();
        this.performTransactionAwareAfterRollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doClose() {
        try {
            Enumeration en = this.objectEnvelopeTable.elements();
            while (en.hasMoreElements()) {
                Object obj = ((ObjectEnvelope)en.nextElement()).getObject();
                this.removeLock(obj);
            }
            Iterator it = this.unmaterializedLocks.iterator();
            while (it.hasNext()) {
                this.removeLock(it.next());
            }
            this.unRegisterFromAllIndirectionHandlers();
            this.unRegisterFromAllCollectionProxies();
            Object var4_3 = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Close Transaction and release current PB " + this.broker + " on tx " + this);
            }
            this.implementation.getTxManager().deregisterTx(this);
            this.refresh();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Close Transaction and release current PB " + this.broker + " on tx " + this);
            }
            this.implementation.getTxManager().deregisterTx(this);
            this.refresh();
            throw throwable;
        }
    }

    protected void refresh() {
        block3: {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Refresh this transaction for reuse: " + this);
            }
            try {
                this.objectEnvelopeTable.refresh();
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug("error closing object envelope table : " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.cleanupBroker();
        this.broker = null;
        this.registeredForLock.clear();
        this.unmaterializedLocks.clear();
        this.txStatus = 6;
    }

    public void checkpoint() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Checkpoint was called, commit changes hold locks on tx " + this);
        }
        try {
            this.checkOpen();
            this.doWriteObjects(true);
            if (this.hasBroker() && this.broker.isInTransaction()) {
                this.broker.commitTransaction();
            }
        }
        catch (Throwable t) {
            this.log.error("Checkpoint call failed, do abort transaction", t);
            this.txStatus = 1;
            this.abort();
            if (!(t instanceof ODMGRuntimeException)) {
                throw new TransactionAbortedExceptionOJB("Can't tx.checkpoint() objects: " + t.getMessage(), t);
            }
            throw (ODMGRuntimeException)t;
        }
    }

    public void flush() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Flush was called - write changes to database, do not commit, hold locks on tx " + this);
        }
        try {
            this.checkOpen();
            this.doWriteObjects(true);
        }
        catch (Throwable t) {
            this.log.error("flush failed", t);
            this.txStatus = 1;
            this.abort();
            if (!(t instanceof ODMGRuntimeException)) {
                throw new TransactionAbortedExceptionOJB("Can't tx.flush() objects: " + t.getMessage(), t);
            }
            throw (ODMGRuntimeException)t;
        }
    }

    public void markDelete(Object anObject) {
        ObjectEnvelope otw = this.objectEnvelopeTable.get(anObject, false);
        otw.setModificationState(otw.getModificationState().markDelete());
    }

    public void markDirty(Object anObject) {
        ObjectEnvelope otw = this.objectEnvelopeTable.get(anObject, false);
        otw.refreshObjectIfNeeded(anObject);
        otw.setModificationState(otw.getModificationState().markDirty());
    }

    void markPersistent(RuntimeObject rtObj) {
        ObjectEnvelope oe = this.objectEnvelopeTable.getByIdentity(rtObj.getIdentity());
        if (oe == null) {
            oe = this.objectEnvelopeTable.get(rtObj.getIdentity(), rtObj.getObj(), rtObj.isNew());
        }
        if (oe.needsDelete()) {
            oe.setModificationState(oe.getModificationState().markNew());
        } else {
            oe.setModificationState(oe.getModificationState().markDirty());
        }
        oe.refreshObjectIfNeeded(rtObj.getObj());
    }

    public boolean tryLock(Object obj, int lockMode) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Try to lock object was called on tx " + this);
        }
        this.checkOpen();
        try {
            this.lock(obj, lockMode);
            return true;
        }
        catch (LockNotGrantedException ex) {
            return false;
        }
    }

    private boolean removeLock(Object obj) {
        return this.getImplementation().getLockManager().releaseLock(this, obj);
    }

    public void commit() {
        this.checkOpen();
        try {
            this.prepareCommit();
            this.checkForCommit();
            this.txStatus = 8;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Commit transaction " + this);
            }
            if (this.hasBroker()) {
                this.getBroker().commitTransaction();
            }
            this.performTransactionAwareAfterCommit();
            this.doClose();
            this.txStatus = 3;
        }
        catch (Exception ex) {
            this.log.error("Error while commit objects, do abort tx " + this + ", " + ex.getMessage(), ex);
            this.txStatus = 1;
            this.abort();
            if (!(ex instanceof ODMGRuntimeException)) {
                throw new TransactionAbortedExceptionOJB("Can't commit objects: " + ex.getMessage(), ex);
            }
            throw (ODMGRuntimeException)ex;
        }
    }

    protected void checkForCommit() {
        if (this.txStatus == 1) {
            throw new TransactionAbortedExceptionOJB("Illegal tx-status: tx is already markedRollback");
        }
        if (this.txStatus != 2) {
            throw new IllegalStateException("Illegal tx-status: Do prepare commit before commit");
        }
    }

    protected void prepareCommit() throws TransactionAbortedException, LockNotGrantedException {
        if (this.txStatus == 1) {
            throw new TransactionAbortedExceptionOJB("Prepare Transaction: tx already marked for rollback");
        }
        if (this.txStatus != 0) {
            throw new IllegalStateException("Prepare Transaction: tx status is not 'active', status is " + TxUtil.getStatusString(this.txStatus));
        }
        try {
            this.txStatus = 7;
            this.doWriteObjects(false);
            this.txStatus = 2;
        }
        catch (RuntimeException e) {
            this.log.error("Could not prepare for commit: " + e.getMessage());
            this.txStatus = 1;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        if (this.txStatus == 6 || this.txStatus == 5 || this.txStatus == 4) {
            this.log.info("Nothing to abort, tx is not active - status is " + TxUtil.getStatusString(this.txStatus));
            return;
        }
        if (this.txStatus != 0 && this.txStatus != 2 && this.txStatus != 1) {
            if (this.txStatus == 6) {
                throw new TransactionNotInProgressException("The Transaction was not started, tx " + this);
            }
            throw new IllegalStateException("Illegal state for abort call, state was '" + TxUtil.getStatusString(this.txStatus) + "'");
        }
        if (this.log.isEnabledFor(2)) {
            this.log.info("Abort transaction was called on tx " + this);
        }
        try {
            try {
                this.doAbort();
            }
            catch (Exception e) {
                this.log.error("Error while abort transaction, will be skipped", e);
            }
            this.implementation.getTxManager().abortExternalTx(this);
            try {
                if (this.hasBroker() && this.getBroker().isInTransaction()) {
                    this.getBroker().abortTransaction();
                }
            }
            catch (Exception e) {
                this.log.error("Error while do abort used broker instance, will be skipped", e);
            }
        }
        finally {
            this.txStatus = 4;
            this.doClose();
        }
    }

    public synchronized void begin() {
        this.checkForBegin();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Begin transaction was called on tx " + this);
        }
        this.objectEnvelopeTable = new ObjectEnvelopeTable(this);
        this.implementation.getTxManager().registerTx(this);
        this.txStatus = 0;
    }

    protected void checkForBegin() {
        if (this.curDB == null || !this.curDB.isOpen()) {
            throw new DatabaseClosedException("Database is not open. Must have an open DB to begin the Tx.");
        }
        if (this.isOpen()) {
            this.log.error("Transaction is already open");
            throw new TransactionInProgressException("Impossible to call begin on already opened tx");
        }
    }

    public String getGUID() {
        return this.txGUID;
    }

    public Object getObjectByIdentity(Identity id) throws PersistenceBrokerException {
        this.checkOpen();
        ObjectEnvelope envelope = this.objectEnvelopeTable.getByIdentity(id);
        if (envelope != null) {
            return envelope.needsDelete() ? null : envelope.getObject();
        }
        return this.getBroker().getObjectByIdentity(id);
    }

    private synchronized void register(RuntimeObject rtObject, int lockMode, boolean cascade) throws LockNotGrantedException, PersistenceBrokerException {
        Object objectToRegister = rtObject.getObj();
        if (rtObject.isProxy()) {
            IndirectionHandler handler = rtObject.getHandler();
            if (handler == null) {
                throw new OJBRuntimeException("Unexpected error, expect an proxy object as indicated: " + rtObject);
            }
            if (handler.alreadyMaterialized()) {
                objectToRegister = handler.getRealSubject();
            } else {
                this.registerToIndirectionHandler(handler);
                this.registerUnmaterializedLocks(rtObject.getObj());
                objectToRegister = null;
            }
        }
        if (objectToRegister != null) {
            ObjectEnvelope envelope = this.objectEnvelopeTable.getByIdentity(rtObject.getIdentity());
            if (envelope == null) {
                envelope = this.objectEnvelopeTable.get(rtObject.getIdentity(), objectToRegister, rtObject.isNew());
            } else {
                envelope.refreshObjectIfNeeded(objectToRegister);
            }
            if (lockMode == 4) {
                envelope.setWriteLocked(true);
            }
            if (cascade) {
                this.lockAndRegisterReferences(rtObject.getCld(), rtObject.getObjMaterialized(), this.getImpliciteLockType(lockMode));
                this.lockAndRegisterCollections(rtObject.getCld(), rtObject.getObjMaterialized(), this.getImpliciteLockType(lockMode));
            }
        }
    }

    private void lockAndRegisterReferences(ClassDescriptor cld, Object sourceObject, int lockMode) throws LockNotGrantedException {
        if (this.implicitLocking) {
            Iterator i = cld.getObjectReferenceDescriptors().iterator();
            while (i.hasNext()) {
                boolean isProxy;
                RuntimeObject rt;
                ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)i.next();
                Object refObj = rds.getPersistentField().get(sourceObject);
                if (refObj == null || this.registeredForLock.contains((rt = (isProxy = ProxyHelper.isProxy(refObj)) ? new RuntimeObject(refObj, this, false) : new RuntimeObject(refObj, this)).getIdentity())) continue;
                this.lockAndRegister(rt, lockMode, true);
            }
        }
    }

    private void lockAndRegisterCollections(ClassDescriptor cld, Object sourceObject, int lockMode) throws LockNotGrantedException {
        if (this.implicitLocking) {
            Iterator i = cld.getCollectionDescriptors().iterator();
            while (i.hasNext()) {
                CollectionDescriptor cds = (CollectionDescriptor)i.next();
                Object col = cds.getPersistentField().get(sourceObject);
                if (col == null) continue;
                CollectionProxy proxy = ProxyHelper.getCollectionProxy(col);
                if (proxy != null && !proxy.isLoaded()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("adding self as listener to collection proxy");
                    }
                    proxy.addListener(this);
                    this.registeredCollectionProxies.add(proxy);
                    continue;
                }
                Iterator colIterator = BrokerHelper.getCollectionIterator(col);
                Object item = null;
                try {
                    while (colIterator.hasNext()) {
                        item = colIterator.next();
                        RuntimeObject rt = new RuntimeObject(item, this);
                        if (rt.isProxy()) {
                            IndirectionHandler handler = ProxyHelper.getIndirectionHandler(item);
                            if (!handler.alreadyMaterialized()) {
                                handler.addListener(this);
                                continue;
                            }
                            item = handler.getRealSubject();
                        }
                        this.lockAndRegister(rt, lockMode, true);
                    }
                }
                catch (LockNotGrantedException e) {
                    String eol = SystemUtils.LINE_SEPARATOR;
                    this.log.error("Lock not granted, while lock collection references[" + eol + "current reference descriptor:" + eol + cds.toXML() + eol + "object to lock: " + item + eol + "main object class: " + sourceObject.getClass().getName() + eol + "]", e);
                    throw e;
                }
            }
        }
    }

    public void beforeMaterialization(IndirectionHandler handler, Identity oid) {
    }

    public void afterMaterialization(IndirectionHandler handler, Object materializedObject) {
        try {
            Identity oid = handler.getIdentity();
            if (this.log.isDebugEnabled()) {
                this.log.debug("deferred registration: " + oid);
            }
            if (!this.isOpen()) {
                this.log.error("Proxy object materialization outside of a running tx, obj=" + oid);
                try {
                    throw new Exception("Proxy object materialization outside of a running tx, obj=" + oid);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ClassDescriptor cld = this.getBroker().getClassDescriptor(materializedObject.getClass());
            RuntimeObject rt = new RuntimeObject(materializedObject, oid, cld, false, false);
            this.lockAndRegister(rt, 1, false);
        }
        catch (Throwable t) {
            this.log.error("Register materialized object with this tx failed", t);
            throw new LockNotGrantedException(t.getMessage());
        }
        this.unregisterFromIndirectionHandler(handler);
    }

    protected synchronized void unRegisterFromAllIndirectionHandlers() {
        for (int i = this.registeredIndirectionHandlers.size() - 1; i >= 0; --i) {
            this.unregisterFromIndirectionHandler((IndirectionHandler)this.registeredIndirectionHandlers.get(i));
        }
    }

    protected synchronized void unRegisterFromAllCollectionProxies() {
        for (int i = this.registeredCollectionProxies.size() - 1; i >= 0; --i) {
            this.unregisterFromCollectionProxy((CollectionProxy)this.registeredCollectionProxies.get(i));
        }
    }

    protected synchronized void unregisterFromCollectionProxy(CollectionProxy handler) {
        handler.removeListener(this);
        this.registeredCollectionProxies.remove(handler);
    }

    protected synchronized void unregisterFromIndirectionHandler(IndirectionHandler handler) {
        handler.removeListener(this);
        this.registeredIndirectionHandlers.remove(handler);
    }

    protected synchronized void registerToIndirectionHandler(IndirectionHandler handler) {
        handler.addListener(this);
        this.registeredIndirectionHandlers.add(handler);
    }

    protected void registerUnmaterializedLocks(Object obj) {
        this.unmaterializedLocks.add(obj);
    }

    public PersistenceBroker getBroker() {
        if (this.broker == null || this.broker.isClosed()) {
            this.checkOpen();
            try {
                this.checkForDB();
                this.broker = PersistenceBrokerFactory.createPersistenceBroker(this.curDB.getPBKey());
            }
            catch (PBFactoryException e) {
                this.log.error("Cannot obtain PersistenceBroker from PersistenceBrokerFactory, found PBKey was " + this.curDB.getPBKey(), (Throwable)((Object)e));
                throw new PersistenceBrokerException((Throwable)((Object)e));
            }
        }
        return this.broker;
    }

    protected boolean hasBroker() {
        return this.broker != null && !this.broker.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupBroker() {
        if (this.hasBroker()) {
            try {
                if (this.broker.isInTransaction()) {
                    this.broker.abortTransaction();
                }
            }
            finally {
                this.broker.close();
                this.broker = null;
            }
        }
    }

    public void configure(Configuration config) throws ConfigurationException {
    }

    public synchronized void setImplicitLocking(boolean value) {
        this.implicitLocking = value;
    }

    public boolean isImplicitLocking() {
        return this.implicitLocking;
    }

    public void beforeLoading(CollectionProxyDefaultImpl colProxy) {
    }

    public void afterLoading(CollectionProxyDefaultImpl colProxy) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("loading a proxied collection a collection: " + colProxy);
        }
        Collection data = colProxy.getData();
        Iterator iterator = data.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!this.isOpen()) {
                this.log.error("Collection proxy materialization outside of a running tx, obj=" + o);
                try {
                    throw new Exception("Collection proxy materialization outside of a running tx, obj=" + o);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            Identity oid = this.getBroker().serviceIdentity().buildIdentity(o);
            ClassDescriptor cld = this.getBroker().getClassDescriptor(ProxyHelper.getRealClass(o));
            RuntimeObject rt = new RuntimeObject(o, oid, cld, false, ProxyHelper.isProxy(o));
            this.lockAndRegister(rt, 1, false);
        }
        this.unregisterFromCollectionProxy(colProxy);
    }

    protected void performTransactionAwareBeforeCommit() {
        Enumeration en = this.objectEnvelopeTable.elements();
        while (en.hasMoreElements()) {
            ((ObjectEnvelope)en.nextElement()).beforeCommit();
        }
    }

    protected void performTransactionAwareAfterCommit() {
        Enumeration en = this.objectEnvelopeTable.elements();
        try {
            while (en.hasMoreElements()) {
                ((ObjectEnvelope)en.nextElement()).afterCommit();
            }
        }
        catch (Exception e) {
            this.log.error("Unexpected error while perform 'TransactionAware#afterCommit()' listener after commit of objects, after commit you can't rollback - exception will be skipped.", e);
        }
    }

    protected void performTransactionAwareBeforeRollback() {
        Enumeration en = this.objectEnvelopeTable.elements();
        while (en.hasMoreElements()) {
            try {
                ((ObjectEnvelope)en.nextElement()).beforeAbort();
            }
            catch (Exception e) {
                this.log.error("Unexpected error while perform 'TransactionAware#beforeAbort()' listener before rollback of objects - exception will be skipped to complete rollback.", e);
            }
        }
    }

    protected void performTransactionAwareAfterRollback() {
        Enumeration en = this.objectEnvelopeTable.elements();
        try {
            while (en.hasMoreElements()) {
                ((ObjectEnvelope)en.nextElement()).afterAbort();
            }
        }
        catch (Exception e) {
            this.log.error("Unexpected error while perform 'TransactionAware#afterAbort()' listener after rollback of objects - exception will be skipped.", e);
        }
    }

    public void setCascadingDelete(Class target, String referenceField, boolean doCascade) {
        ClassDescriptor cld = this.getBroker().getClassDescriptor(target);
        ObjectReferenceDescriptor ord = cld.getObjectReferenceDescriptorByName(referenceField);
        if (ord == null) {
            ord = cld.getCollectionDescriptorByName(referenceField);
        }
        if (ord == null) {
            throw new CascadeSettingException("Invalid reference field name '" + referenceField + "', can't find 1:1, 1:n or m:n relation with that name in " + target);
        }
        this.runtimeCascadeDeleteMap.put(ord, doCascade ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setCascadingDelete(Class target, boolean doCascade) {
        ClassDescriptor cld = this.getBroker().getClassDescriptor(target);
        Boolean result = doCascade ? Boolean.TRUE : Boolean.FALSE;
        Vector singleRefs = cld.getObjectReferenceDescriptors();
        for (int i = 0; i < singleRefs.size(); ++i) {
            Object o = singleRefs.get(i);
            this.runtimeCascadeDeleteMap.put(o, result);
        }
        Vector collectionRefs = cld.getCollectionDescriptors();
        for (int i = 0; i < collectionRefs.size(); ++i) {
            Object o = collectionRefs.get(i);
            this.runtimeCascadeDeleteMap.put(o, result);
        }
    }

    protected boolean cascadeDeleteFor(ObjectReferenceDescriptor ord) {
        CollectionDescriptor cds;
        boolean result = false;
        Boolean runtimeSetting = (Boolean)this.runtimeCascadeDeleteMap.get(ord);
        result = runtimeSetting == null ? (ord instanceof CollectionDescriptor ? ((cds = (CollectionDescriptor)ord).isMtoNRelation() ? this.implementation.cascadingDeleteMtoN : this.implementation.cascadingDeleteOnetoN) : this.implementation.cascadingDeleteOnetoOne) : runtimeSetting;
        return result;
    }

    int getImpliciteLockType(int parentLockMode) {
        return parentLockMode == 4 && this.impliciteWriteLocks ? 4 : 1;
    }

    void clearRegisteredForLock() {
        this.registeredForLock.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class CascadeSettingException
    extends OJBRuntimeException {
        public CascadeSettingException() {
        }

        public CascadeSettingException(String msg) {
            super(msg);
        }

        public CascadeSettingException(Throwable cause) {
            super(cause);
        }

        public CascadeSettingException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

