/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.jdo.jdoql;

import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.jdo.jdoql.QueryTreeNode;
import org.apache.ojb.jdo.jdoql.Visitor;

public class Type
extends QueryTreeNode {
    private String _name;
    private Class _type;

    public Type(String typeName, boolean isPrimitive) {
        this._name = typeName;
        if (isPrimitive) {
            this.resolvePrimitiveType();
        }
    }

    private void resolvePrimitiveType() {
        ClassLoader loader = ClassHelper.getClassLoader();
        try {
            this._type = Class.forName(this._name, true, loader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public Class getType() {
        return this._type;
    }

    public void setType(Class type) {
        this._type = type;
        if (this._type != null) {
            this._name = type.getName();
        }
    }

    public String getName() {
        return this._name;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this._type == null ? this._name : this._type.getName();
    }
}

