/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException;
import org.apache.ojb.broker.util.ConstructorHelper;

public class ClassHelper {
    private static final Object[] NO_ARGS = new Object[0];
    private static final Class[] NO_ARGS_CLASS = new Class[0];
    private static ClassLoader _classLoader = null;
    private static Object _mutex = new Object();

    private ClassHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setClassLoader(ClassLoader loader) {
        Object object = _mutex;
        synchronized (object) {
            _classLoader = loader;
        }
    }

    public static ClassLoader getClassLoader() {
        ClassLoader threadCtxtClassLoader;
        ClassLoader ojbClassLoader = _classLoader != null ? _classLoader : ((threadCtxtClassLoader = Thread.currentThread().getContextClassLoader()) == null ? ClassLoader.getSystemClassLoader() : threadCtxtClassLoader);
        return ojbClassLoader;
    }

    public static URL getResource(String name) {
        return ClassHelper.getClassLoader().getResource(name);
    }

    public static Class getClass(String className, boolean initialize) throws ClassNotFoundException {
        return Class.forName(className, initialize, ClassHelper.getClassLoader());
    }

    public static Object newInstance(Class target) throws InstantiationException, IllegalAccessException {
        return target.newInstance();
    }

    public static Object newInstance(Class target, boolean makeAccessible) throws InstantiationException, IllegalAccessException {
        if (makeAccessible) {
            try {
                return ClassHelper.newInstance(target, NO_ARGS_CLASS, NO_ARGS, makeAccessible);
            }
            catch (InvocationTargetException e) {
                throw new OJBRuntimeException("Unexpected exception while instantiate class '" + target + "' with default constructor", e);
            }
            catch (NoSuchMethodException e) {
                throw new OJBRuntimeException("Unexpected exception while instantiate class '" + target + "' with default constructor", e);
            }
        }
        return target.newInstance();
    }

    public static Object newInstance(Class target, Class[] types, Object[] args) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return ClassHelper.newInstance(target, types, args, false);
    }

    public static Object newInstance(Class target, Class[] types, Object[] args, boolean makeAccessible) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Constructor con;
        if (makeAccessible) {
            con = target.getDeclaredConstructor(types);
            if (makeAccessible && !con.isAccessible()) {
                con.setAccessible(true);
            }
        } else {
            con = target.getConstructor(types);
        }
        return con.newInstance(args);
    }

    public static Method getMethod(Class clazz, String methodName, Class[] params) {
        try {
            return clazz.getMethod(methodName, params);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Field getField(Class clazz, String fieldName) {
        try {
            return clazz.getField(fieldName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Class getClass(String name) throws ClassNotFoundException {
        return ClassHelper.getClass(name, true);
    }

    public static Object newInstance(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return ClassHelper.newInstance(ClassHelper.getClass(className));
    }

    public static Object newInstance(String className, Class[] types, Object[] args) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        return ClassHelper.newInstance(ClassHelper.getClass(className), types, args);
    }

    public static Object newInstance(Class target, Class type, Object arg) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return ClassHelper.newInstance(target, new Class[]{type}, new Object[]{arg});
    }

    public static Object newInstance(String className, Class type, Object arg) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        return ClassHelper.newInstance(className, new Class[]{type}, new Object[]{arg});
    }

    public static Method getMethod(Object object, String methodName, Class[] params) {
        return ClassHelper.getMethod(object.getClass(), methodName, params);
    }

    public static Method getMethod(String className, String methodName, Class[] params) {
        try {
            return ClassHelper.getMethod(ClassHelper.getClass(className, false), methodName, params);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object buildNewObjectInstance(ClassDescriptor cld) {
        Object result = null;
        if (cld.getFactoryClass() == null || cld.getFactoryMethod() == null) {
            try {
                Constructor con = cld.getZeroArgumentConstructor();
                if (con == null) {
                    throw new ClassNotPersistenceCapableException("A zero argument constructor was not provided! Class was '" + cld.getClassNameOfObject() + "'");
                }
                result = ConstructorHelper.instantiate(con);
            }
            catch (InstantiationException e) {
                throw new ClassNotPersistenceCapableException("Can't instantiate class '" + cld.getClassNameOfObject() + "'");
            }
        }
        try {
            Method method = cld.getFactoryMethod();
            if (Modifier.isStatic(method.getModifiers())) {
                result = method.invoke(null, null);
            } else {
                Object factoryInstance = cld.getFactoryClass().newInstance();
                result = method.invoke(factoryInstance, null);
            }
        }
        catch (Exception ex) {
            throw new PersistenceBrokerException("Unable to build object instance of class '" + cld.getClassNameOfObject() + "' from factory:" + cld.getFactoryClass() + "." + cld.getFactoryMethod(), ex);
        }
        return result;
    }
}

