/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.core.PersistenceBrokerConfiguration;
import org.apache.ojb.broker.metadata.FieldHelper;
import org.apache.ojb.broker.query.ExistsCriteria;
import org.apache.ojb.broker.query.FieldCriteria;
import org.apache.ojb.broker.query.InCriteria;
import org.apache.ojb.broker.query.NullCriteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.SelectionCriteria;
import org.apache.ojb.broker.query.SqlCriteria;
import org.apache.ojb.broker.query.UserAlias;
import org.apache.ojb.broker.query.ValueCriteria;
import org.apache.ojb.broker.util.configuration.ConfigurationException;

public class Criteria
implements Serializable {
    static final long serialVersionUID = 7384550404778187808L;
    public static final int OR = 0;
    public static final int AND = 1;
    public static final int NONE = 9;
    public static final String PARENT_QUERY_PREFIX = "parentQuery.";
    private Vector m_criteria = new Vector();
    private int m_type = 9;
    private boolean m_embraced = false;
    private boolean m_negative = false;
    private List orderby = null;
    private List groupby = new ArrayList();
    private List prefetchedRelationships = null;
    private String m_alias = null;
    private String m_aliasPath = null;
    private UserAlias m_userAlias = null;
    protected static final int IN_LIMIT = Criteria.getSqlInLimit();
    private QueryByCriteria m_query;
    private Criteria m_parentCriteria;
    private Map m_pathClasses;

    public Criteria() {
        this.orderby = new ArrayList();
        this.prefetchedRelationships = new ArrayList();
        this.m_pathClasses = new HashMap();
    }

    public Criteria(SelectionCriteria aSelectionCriteria) {
        this();
        this.addSelectionCriteria(aSelectionCriteria);
    }

    public Criteria copy(boolean includeGroupBy, boolean includeOrderBy, boolean includePrefetchedRelationships) {
        Criteria copy = new Criteria();
        copy.m_criteria = new Vector(this.m_criteria);
        copy.m_negative = this.m_negative;
        if (includeGroupBy) {
            copy.groupby = this.groupby;
        }
        if (includeOrderBy) {
            copy.orderby = this.orderby;
        }
        if (includePrefetchedRelationships) {
            copy.prefetchedRelationships = this.prefetchedRelationships;
        }
        return copy;
    }

    protected void addSelectionCriteria(SelectionCriteria selectionCrit) {
        selectionCrit.setCriteria(this);
        this.m_criteria.addElement(selectionCrit);
    }

    protected void addCriteria(Criteria crit) {
        crit.setParentCriteria(this);
        this.m_criteria.addElement(crit);
    }

    protected void addCriteria(Vector criteria) {
        for (int i = 0; i < criteria.size(); ++i) {
            Object crit = criteria.elementAt(i);
            if (crit instanceof SelectionCriteria) {
                this.addSelectionCriteria((SelectionCriteria)crit);
                continue;
            }
            if (!(crit instanceof Criteria)) continue;
            this.addCriteria((Criteria)crit);
        }
    }

    protected List splitInCriteria(Object attribute, Collection values, boolean negative, int inLimit) {
        ArrayList<InCriteria> result = new ArrayList<InCriteria>();
        ArrayList inCollection = new ArrayList();
        if (values == null || values.isEmpty()) {
            result.add(this.buildInCriteria(attribute, negative, values));
        } else {
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                inCollection.add(iter.next());
                if (inCollection.size() != inLimit && iter.hasNext()) continue;
                result.add(this.buildInCriteria(attribute, negative, inCollection));
                inCollection = new ArrayList();
            }
        }
        return result;
    }

    private InCriteria buildInCriteria(Object attribute, boolean negative, Collection values) {
        if (negative) {
            return ValueCriteria.buildNotInCriteria(attribute, (Object)values, this.getUserAlias(attribute));
        }
        return ValueCriteria.buildInCriteria(attribute, (Object)values, this.getUserAlias(attribute));
    }

    public Enumeration getElements() {
        return this.getCriteria().elements();
    }

    protected Vector getCriteria() {
        return this.m_criteria;
    }

    public int getType() {
        return this.m_type;
    }

    public void setType(int type) {
        this.m_type = type;
    }

    public boolean isEmbraced() {
        return this.m_embraced;
    }

    public void setEmbraced(boolean embraced) {
        this.m_embraced = embraced;
    }

    public void addEqualTo(String attribute, Object value) {
        this.addSelectionCriteria(ValueCriteria.buildEqualToCriteria((Object)attribute, value, this.getUserAlias(attribute)));
    }

    public void addColumnEqualTo(String column, Object value) {
        ValueCriteria c = ValueCriteria.buildEqualToCriteria((Object)column, value, this.getUserAlias(column));
        c.setTranslateAttribute(false);
        this.addSelectionCriteria(c);
    }

    public void addColumnEqualToField(String column, Object fieldName) {
        FieldCriteria c = FieldCriteria.buildEqualToCriteria(column, fieldName, this.getUserAlias(column));
        c.setTranslateAttribute(false);
        this.addSelectionCriteria(c);
    }

    public void addEqualToField(String attribute, String fieldName) {
        FieldCriteria c = FieldCriteria.buildEqualToCriteria(attribute, fieldName, this.getUserAlias(attribute));
        this.addSelectionCriteria(c);
    }

    public void addNotEqualToField(String attribute, String fieldName) {
        FieldCriteria c = FieldCriteria.buildNotEqualToCriteria(attribute, fieldName, this.getUserAlias(attribute));
        this.addSelectionCriteria(c);
    }

    public void addNotEqualToColumn(String attribute, String colName) {
        FieldCriteria c = FieldCriteria.buildNotEqualToCriteria(attribute, colName, this.getUserAlias(attribute));
        c.setTranslateField(false);
        this.addSelectionCriteria(c);
    }

    public void addEqualToColumn(String attribute, String colName) {
        FieldCriteria c = FieldCriteria.buildEqualToCriteria(attribute, colName, this.getUserAlias(attribute));
        c.setTranslateField(false);
        this.addSelectionCriteria(c);
    }

    public void addGreaterOrEqualThan(Object attribute, Object value) {
        this.addSelectionCriteria(ValueCriteria.buildNotLessCriteria(attribute, value, this.getUserAlias(attribute)));
    }

    public void addGreaterOrEqualThanField(String attribute, Object value) {
        this.addSelectionCriteria(FieldCriteria.buildNotLessCriteria(attribute, value, this.getUserAlias(attribute)));
    }

    public void addLessOrEqualThan(Object attribute, Object value) {
        this.addSelectionCriteria(ValueCriteria.buildNotGreaterCriteria(attribute, value, this.getUserAlias(attribute)));
    }

    public void addLessOrEqualThanField(String attribute, Object value) {
        this.addSelectionCriteria(FieldCriteria.buildNotGreaterCriteria(attribute, value, this.getUserAlias(attribute)));
    }

    public void addLike(Object attribute, Object value) {
        this.addSelectionCriteria(ValueCriteria.buildLikeCriteria(attribute, value, this.getUserAlias(attribute)));
    }

    public void addNotLike(String attribute, Object value) {
        this.addSelectionCriteria(ValueCriteria.buildNotLikeCriteria((Object)attribute, value, this.getUserAlias(attribute)));
    }

    public void addNotEqualTo(Object attribute, Object value) {
        this.addSelectionCriteria(ValueCriteria.buildNotEqualToCriteria(attribute, value, this.getUserAlias(attribute)));
    }

    public void addGreaterThan(Object attribute, Object value) {
        this.addSelectionCriteria(ValueCriteria.buildGreaterCriteria(attribute, value, this.getUserAlias(attribute)));
    }

    public void addGreaterThanField(String attribute, Object value) {
        this.addSelectionCriteria(FieldCriteria.buildGreaterCriteria(attribute, value, this.getUserAlias(attribute)));
    }

    public void addLessThan(Object attribute, Object value) {
        this.addSelectionCriteria(ValueCriteria.buildLessCriteria(attribute, value, this.getUserAlias(attribute)));
    }

    public void addLessThanField(String attribute, Object value) {
        this.addSelectionCriteria(FieldCriteria.buildLessCriteria(attribute, value, this.getUserAlias(attribute)));
    }

    public void addOrderBy(String fieldName) {
        this.addOrderBy(fieldName, true);
    }

    public void addOrderBy(String fieldName, boolean sortAscending) {
        if (fieldName != null) {
            this._getOrderby().add(new FieldHelper(fieldName, sortAscending));
        }
    }

    public void addOrderBy(FieldHelper aField) {
        if (aField != null) {
            this._getOrderby().add(aField);
        }
    }

    public void addOrderByAscending(String fieldName) {
        this.addOrderBy(fieldName, true);
    }

    public void addOrderByDescending(String fieldName) {
        this.addOrderBy(fieldName, false);
    }

    List getOrderby() {
        List result = this._getOrderby();
        Iterator iter = this.getCriteria().iterator();
        while (iter.hasNext()) {
            Object crit = iter.next();
            if (!(crit instanceof Criteria)) continue;
            result.addAll(((Criteria)crit).getOrderby());
        }
        return result;
    }

    protected List _getOrderby() {
        return this.orderby;
    }

    public void addOrCriteria(Criteria pc) {
        if (!this.m_criteria.isEmpty()) {
            pc.setEmbraced(true);
            pc.setType(0);
            this.addCriteria(pc);
        } else {
            this.setEmbraced(false);
            pc.setType(0);
            this.addCriteria(pc);
        }
    }

    public void addIsNull(String attribute) {
        this.addSelectionCriteria(ValueCriteria.buildNullCriteria(attribute, this.getUserAlias(attribute)));
    }

    public void addColumnIsNull(String column) {
        NullCriteria c = ValueCriteria.buildNullCriteria(column, this.getUserAlias(column));
        c.setTranslateAttribute(false);
        this.addSelectionCriteria(c);
    }

    public void addNotNull(String attribute) {
        this.addSelectionCriteria(ValueCriteria.buildNotNullCriteria(attribute, this.getUserAlias(attribute)));
    }

    public void addColumnNotNull(String column) {
        NullCriteria c = ValueCriteria.buildNotNullCriteria(column, this.getUserAlias(column));
        c.setTranslateAttribute(false);
        this.addSelectionCriteria(c);
    }

    public void addBetween(Object attribute, Object value1, Object value2) {
        this.addSelectionCriteria(ValueCriteria.buildBeweenCriteria(attribute, value1, value2, this.getUserAlias(attribute)));
    }

    public void addNotBetween(Object attribute, Object value1, Object value2) {
        this.addSelectionCriteria(ValueCriteria.buildNotBeweenCriteria(attribute, value1, value2, this.getUserAlias(attribute)));
    }

    public void addIn(String attribute, Collection values) {
        List list = this.splitInCriteria(attribute, values, false, IN_LIMIT);
        int index = 0;
        InCriteria inCrit = (InCriteria)list.get(index);
        Criteria allInCritaria = new Criteria(inCrit);
        for (index = 1; index < list.size(); ++index) {
            inCrit = (InCriteria)list.get(index);
            allInCritaria.addOrCriteria(new Criteria(inCrit));
        }
        this.addAndCriteria(allInCritaria);
    }

    public void addColumnIn(String column, Collection values) {
        List list = this.splitInCriteria(column, values, false, IN_LIMIT);
        int index = 0;
        InCriteria inCrit = (InCriteria)list.get(index);
        inCrit.setTranslateAttribute(false);
        Criteria allInCritaria = new Criteria(inCrit);
        for (index = 1; index < list.size(); ++index) {
            inCrit = (InCriteria)list.get(index);
            inCrit.setTranslateAttribute(false);
            allInCritaria.addOrCriteria(new Criteria(inCrit));
        }
        this.addAndCriteria(allInCritaria);
    }

    public void addNotIn(String attribute, Collection values) {
        List list = this.splitInCriteria(attribute, values, true, IN_LIMIT);
        int index = 0;
        for (index = 0; index < list.size(); ++index) {
            InCriteria inCrit = (InCriteria)list.get(index);
            this.addSelectionCriteria(inCrit);
        }
    }

    public void addIn(Object attribute, Query subQuery) {
        this.addSelectionCriteria(ValueCriteria.buildInCriteria(attribute, (Object)subQuery, this.getUserAlias(attribute)));
    }

    public void addNotIn(String attribute, Query subQuery) {
        this.addSelectionCriteria(ValueCriteria.buildNotInCriteria((Object)attribute, (Object)subQuery, this.getUserAlias(attribute)));
    }

    public void addSql(String anSqlStatment) {
        this.addSelectionCriteria(new SqlCriteria(anSqlStatment));
    }

    public void addAndCriteria(Criteria pc) {
        if (!this.m_criteria.isEmpty()) {
            this.setEmbraced(true);
            pc.setEmbraced(true);
            pc.setType(1);
            this.addCriteria(pc);
        } else {
            this.setEmbraced(false);
            pc.setType(1);
            this.addCriteria(pc);
        }
    }

    public void addExists(Query subQuery) {
        this.addSelectionCriteria(new ExistsCriteria(subQuery, false));
    }

    public void addNotExists(Query subQuery) {
        this.addSelectionCriteria(new ExistsCriteria(subQuery, true));
    }

    public boolean isEmpty() {
        return this.m_criteria.isEmpty();
    }

    List getGroupby() {
        List result = this._getGroupby();
        Iterator iter = this.getCriteria().iterator();
        while (iter.hasNext()) {
            Object crit = iter.next();
            if (!(crit instanceof Criteria)) continue;
            result.addAll(((Criteria)crit).getGroupby());
        }
        return result;
    }

    protected List _getGroupby() {
        return this.groupby;
    }

    public void addGroupBy(String fieldName) {
        if (fieldName != null) {
            this._getGroupby().add(new FieldHelper(fieldName, false));
        }
    }

    public void addGroupBy(FieldHelper aField) {
        if (aField != null) {
            this._getGroupby().add(aField);
        }
    }

    public void addGroupBy(String[] fieldNames) {
        for (int i = 0; i < fieldNames.length; ++i) {
            this.addGroupBy(fieldNames[i]);
        }
    }

    List getPrefetchedRelationships() {
        return this.prefetchedRelationships;
    }

    public void addPrefetchedRelationship(String aName) {
        this.getPrefetchedRelationships().add(aName);
    }

    private static int getSqlInLimit() {
        try {
            PersistenceBrokerConfiguration config = (PersistenceBrokerConfiguration)((Object)PersistenceBrokerFactory.getConfigurator().getConfigurationFor(null));
            return config.getSqlInLimit();
        }
        catch (ConfigurationException e) {
            return 200;
        }
    }

    public String getAlias() {
        return this.m_alias;
    }

    public UserAlias getUserAlias() {
        return this.m_userAlias;
    }

    private UserAlias getUserAlias(Object attribute) {
        if (this.m_userAlias != null) {
            return this.m_userAlias;
        }
        if (!(attribute instanceof String)) {
            return null;
        }
        if (this.m_alias == null) {
            return null;
        }
        if (this.m_aliasPath == null) {
            boolean allPathsAliased = true;
            return new UserAlias(this.m_alias, (String)attribute, allPathsAliased);
        }
        return new UserAlias(this.m_alias, (String)attribute, this.m_aliasPath);
    }

    public void setAlias(String alias) {
        this.m_alias = alias == null || alias.trim().equals("") ? null : alias;
        for (int i = 0; i < this.m_criteria.size(); ++i) {
            if (this.m_criteria.elementAt(i) instanceof Criteria) continue;
            ((SelectionCriteria)this.m_criteria.elementAt(i)).setAlias(this.m_alias);
        }
    }

    public void setAlias(String alias, String aliasPath) {
        if (alias == null || alias.trim().equals("")) {
            this.m_alias = null;
        } else {
            this.m_alias = alias;
            this.m_aliasPath = aliasPath;
        }
        for (int i = 0; i < this.m_criteria.size(); ++i) {
            if (this.m_criteria.elementAt(i) instanceof Criteria) continue;
            ((SelectionCriteria)this.m_criteria.elementAt(i)).setAlias(this.m_alias, aliasPath);
        }
    }

    public void setAlias(UserAlias userAlias) {
        this.m_alias = userAlias.getName();
        for (int i = 0; i < this.m_criteria.size(); ++i) {
            if (this.m_criteria.elementAt(i) instanceof Criteria) continue;
            ((SelectionCriteria)this.m_criteria.elementAt(i)).setAlias(userAlias);
        }
    }

    public QueryByCriteria getQuery() {
        if (this.getParentCriteria() != null) {
            return this.getParentCriteria().getQuery();
        }
        return this.m_query;
    }

    void setQuery(QueryByCriteria query) {
        this.m_query = query;
    }

    public Criteria getParentCriteria() {
        return this.m_parentCriteria;
    }

    void setParentCriteria(Criteria criteria) {
        this.m_parentCriteria = criteria;
    }

    public String toString() {
        if (this.isNegative()) {
            return "-" + this.m_criteria.toString();
        }
        return this.m_criteria.toString();
    }

    public boolean isNegative() {
        return this.m_negative;
    }

    public void setNegative(boolean negative) {
        this.m_negative = negative;
    }

    public void addPathClass(String aPath, Class aClass) {
        Object pathClasses = this.m_pathClasses.get(aPath);
        if (pathClasses == null) {
            this.setPathClass(aPath, aClass);
        } else {
            List hints = (List)pathClasses;
            hints.add(aClass);
            this.m_pathClasses.put(aPath, hints);
        }
    }

    public void setPathClass(String aPath, Class aClass) {
        ArrayList<Class> pathClasses = new ArrayList<Class>(1);
        pathClasses.add(aClass);
        this.m_pathClasses.put(aPath, pathClasses);
    }

    public List getClassesForPath(String aPath) {
        return (List)this.getPathClasses().get(aPath);
    }

    public Map getPathClasses() {
        if (this.m_pathClasses.isEmpty()) {
            if (this.m_parentCriteria == null) {
                if (this.m_query == null) {
                    return this.m_pathClasses;
                }
                return this.m_query.getPathClasses();
            }
            return this.m_parentCriteria.getPathClasses();
        }
        return this.m_pathClasses;
    }
}

