/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.platforms;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.ojb.broker.platforms.PlatformDefaultImpl;
import org.apache.ojb.broker.query.LikeCriteria;

public class PlatformMySQLImpl
extends PlatformDefaultImpl {
    private static final String LAST_INSERT = "SELECT LAST_INSERT_ID() FROM ";
    private static final String LIMIT = " LIMIT 1";

    public void setObjectForStatement(PreparedStatement ps, int index, Object value, int sqlType) throws SQLException {
        switch (sqlType) {
            case -7: {
                ps.setObject(index, value);
                break;
            }
            case -4: 
            case -3: 
            case 2004: {
                if (value instanceof byte[]) {
                    byte[] buf = (byte[])value;
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(buf);
                    ps.setBinaryStream(index, (InputStream)inputStream, buf.length);
                    break;
                }
            }
            case 2005: {
                Reader reader = null;
                int length = 0;
                if (value instanceof String) {
                    reader = new StringReader((String)value);
                    length = ((String)value).length();
                } else if (value instanceof char[]) {
                    String string = new String((char[])value);
                    reader = new StringReader(string);
                    length = string.length();
                } else if (value instanceof byte[]) {
                    byte[] buf = (byte[])value;
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(buf);
                    reader = new InputStreamReader(inputStream);
                }
                ps.setCharacterStream(index, reader, length);
                break;
            }
            default: {
                super.setObjectForStatement(ps, index, value, sqlType);
            }
        }
    }

    public byte getJoinSyntaxType() {
        return 1;
    }

    public String getLastInsertIdentityQuery(String tableName) {
        return LAST_INSERT + tableName + LIMIT;
    }

    public void addPagingSql(StringBuffer anSqlString) {
        anSqlString.append(" LIMIT ?,?");
    }

    public boolean supportsPaging() {
        return true;
    }

    public String concatenate(String[] theColumns) {
        if (theColumns.length == 1) {
            return theColumns[0];
        }
        StringBuffer buf = new StringBuffer();
        buf.append("concat(");
        for (int i = 0; i < theColumns.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(theColumns[i]);
        }
        buf.append(")");
        return buf.toString();
    }

    public String getEscapeClause(LikeCriteria aCriteria) {
        if (LikeCriteria.getEscapeCharacter() != '\\') {
            return super.getEscapeClause(aCriteria);
        }
        return "";
    }
}

