/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.platforms;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ojb.broker.platforms.PlatformDefaultImpl;
import org.apache.ojb.broker.platforms.PlatformException;
import org.apache.ojb.broker.query.LikeCriteria;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class PlatformMsAccessImpl
extends PlatformDefaultImpl {
    public void setObjectForStatement(PreparedStatement ps, int index, Object value, int sqlType) throws SQLException {
        if (sqlType == 3) {
            ps.setBigDecimal(index, (BigDecimal)value);
        } else if (sqlType == 6) {
            if (value instanceof Double) {
                ps.setDouble(index, (Double)value);
            } else {
                super.setObjectForStatement(ps, index, value, sqlType);
            }
        } else if (sqlType == -1) {
            if (value instanceof String) {
                String s = (String)value;
                byte[] bytes = s.getBytes();
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                ps.setAsciiStream(index, (InputStream)bais, bytes.length);
            } else {
                super.setObjectForStatement(ps, index, value, sqlType);
            }
        } else if (value instanceof Long) {
            ps.setInt(index, ((Long)value).intValue());
        } else {
            super.setObjectForStatement(ps, index, value, sqlType);
        }
    }

    public void beforeStatementClose(Statement stmt, ResultSet rs) throws PlatformException {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LoggerFactory.getDefaultLogger().warn("Resultset closing failed (can be ignored for MsAccess)");
            }
        }
    }

    protected String getConcatenationCharacter() {
        return "&";
    }

    public String getEscapeClause(LikeCriteria aCriteria) {
        return "";
    }
}

