/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata.fieldaccess;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldDirectAccessImpl;

public class PersistentFieldPrivilegedImpl
extends PersistentFieldDirectAccessImpl {
    private static final long serialVersionUID = -6110158693763128846L;
    private SetAccessibleAction setAccessibleAction = new SetAccessibleAction();
    private UnsetAccessibleAction unsetAccessibleAction = new UnsetAccessibleAction();
    private static final int ACCESSIBLE_STATE_UNKOWN = 0;
    private static final int ACCESSIBLE_STATE_FALSE = 1;
    private static final int ACCESSIBLE_STATE_SET_TRUE = 2;

    public PersistentFieldPrivilegedImpl() {
    }

    public PersistentFieldPrivilegedImpl(Class type, String fieldname) {
        super(type, fieldname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doSet(Object obj, Object value) throws MetadataException {
        int accessibleState = 0;
        Field fld = this.getField();
        if (!fld.isAccessible()) {
            accessibleState = 1;
        }
        if (accessibleState == 1) {
            accessibleState = 2;
            AccessController.doPrivileged(this.setAccessibleAction);
        }
        try {
            super.doSet(obj, value);
        }
        finally {
            if (accessibleState == 2) {
                AccessController.doPrivileged(this.unsetAccessibleAction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object doGet(Object obj) throws MetadataException {
        int accessibleState = 0;
        Field fld = this.getField();
        Object result = null;
        if (!fld.isAccessible()) {
            accessibleState = 1;
        }
        if (accessibleState == 1) {
            accessibleState = 2;
            AccessController.doPrivileged(this.setAccessibleAction);
        }
        try {
            result = super.doGet(obj);
        }
        finally {
            if (accessibleState == 2) {
                AccessController.doPrivileged(this.unsetAccessibleAction);
            }
        }
        return result;
    }

    public boolean makeAccessible() {
        return false;
    }

    public boolean usesAccessorsAndMutators() {
        return false;
    }

    private class UnsetAccessibleAction
    implements PrivilegedAction,
    Serializable {
        static final long serialVersionUID = -2284913657454430305L;

        private UnsetAccessibleAction() {
        }

        public Object run() {
            PersistentFieldPrivilegedImpl.this.getField().setAccessible(false);
            return null;
        }
    }

    private class SetAccessibleAction
    implements PrivilegedAction,
    Serializable {
        static final long serialVersionUID = 8152025069698028050L;

        private SetAccessibleAction() {
        }

        public Object run() {
            PersistentFieldPrivilegedImpl.this.getField().setAccessible(true);
            return null;
        }
    }
}

