/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import javax.sql.DataSource;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.metadata.MetadataException;

public class JdbcMetadataUtils {
    public static final String PROPERTY_PROTOCOL = "protocol";
    public static final String PROPERTY_SUBPROTOCOL = "subprotocol";
    public static final String PROPERTY_DBALIAS = "dbAlias";
    public static final String PLATFORM_DB2 = "Db2";
    public static final String PLATFORM_FIREBIRD = "Firebird";
    public static final String PLATFORM_HSQLDB = "Hsqldb";
    public static final String PLATFORM_INFORMIX = "Informix";
    public static final String PLATFORM_MAXDB = "MaxDB";
    public static final String PLATFORM_MCKOI = "McKoi";
    public static final String PLATFORM_MSACCESS = "MsAccess";
    public static final String PLATFORM_MSSQLSERVER = "MsSQLServer";
    public static final String PLATFORM_MYSQL = "MySQL";
    public static final String PLATFORM_ORACLE = "Oracle";
    public static final String PLATFORM_ORACLE9I = "Oracle9i";
    public static final String PLATFORM_POSTGRESQL = "PostgreSQL";
    public static final String PLATFORM_SYBASE = "Sybase";
    public static final String PLATFORM_SYBASEASA = "SybaseASA";
    public static final String PLATFORM_SYBASEASE = "SybaseASE";
    public static final String PLATFORM_WLORACLE9I = "WLOracle9i";
    public static final String DRIVER_DB2 = "COM.ibm.db2.jdbc.app.DB2Driver";
    public static final String DRIVER_DB2_INET = "com.inet.drda.DRDADriver";
    public static final String DRIVER_FIREBIRD = "org.firebirdsql.jdbc.FBDriver";
    public static final String DRIVER_HSQLDB = "org.hsqldb.jdbcDriver";
    public static final String DRIVER_INET_POOLED = "com.inet.pool.PoolDriver";
    public static final String DRIVER_INFORMIX = "com.informix.jdbc.IfxDriver";
    public static final String DRIVER_JTDS = "net.sourceforge.jtds.jdbc.Driver";
    public static final String DRIVER_MAXDB = "com.sap.dbtech.jdbc.DriverSapDB";
    public static final String DRIVER_MCKOI = "com.mckoi.JDBCDriver";
    public static final String DRIVER_MSSQLSERVER = "com.microsoft.jdbc.sqlserver.SQLServerDriver";
    public static final String DRIVER_MSSQLSERVER_INET = "com.inet.tds.TdsDriver";
    public static final String DRIVER_MSSQLSERVER_JSQLCONNECT = "com.jnetdirect.jsql.JSQLDriver";
    public static final String DRIVER_MYSQL = "com.mysql.jdbc.Driver";
    public static final String DRIVER_MYSQL_OLD = "org.gjt.mm.mysql.Driver";
    public static final String DRIVER_ORACLE = "oracle.jdbc.driver.OracleDriver";
    public static final String DRIVER_ORACLE_INET = "com.inet.ora.OraDriver";
    public static final String DRIVER_POSTGRESQL = "org.postgresql.Driver";
    public static final String DRIVER_SAPDB = "com.sap.dbtech.jdbc.DriverSapDB";
    public static final String DRIVER_SYBASE = "com.sybase.jdbc2.jdbc.SybDriver";
    public static final String DRIVER_SYBASE_OLD = "com.sybase.jdbc.SybDriver";
    public static final String DRIVER_SYBASE_INET = "com.inet.syb.SybDriver";
    public static final String SUBPROTOCOL_DB2 = "db2";
    public static final String SUBPROTOCOL_DB2_INET = "inetdb2";
    public static final String SUBPROTOCOL_FIREBIRD = "firebirdsql";
    public static final String SUBPROTOCOL_HSQLDB = "hsqldb";
    public static final String SUBPROTOCOL_INFORMIX = "informix-sqli";
    public static final String SUBPROTOCOL_MAXDB = "sapdb";
    public static final String SUBPROTOCOL_MCKOI = "mckoi";
    public static final String SUBPROTOCOL_MSSQLSERVER = "microsoft:sqlserver";
    public static final String SUBPROTOCOL_MSSQLSERVER_INET = "inetdae";
    public static final String SUBPROTOCOL_MSSQLSERVER6_INET = "inetdae6";
    public static final String SUBPROTOCOL_MSSQLSERVER7_INET = "inetdae7";
    public static final String SUBPROTOCOL_MSSQLSERVER7A_INET = "inetdae7a";
    public static final String SUBPROTOCOL_MSSQLSERVER_INET_POOLED = "inetpool:inetdae";
    public static final String SUBPROTOCOL_MSSQLSERVER6_INET_POOLED = "inetpool:inetdae6";
    public static final String SUBPROTOCOL_MSSQLSERVER7_INET_POOLED = "inetpool:inetdae7";
    public static final String SUBPROTOCOL_MSSQLSERVER7A_INET_POOLED = "inetpool:inetdae7a";
    public static final String SUBPROTOCOL_MSSQLSERVER_JSQLCONNECT = "JSQLConnect";
    public static final String SUBPROTOCOL_MSSQLSERVER_JTDS = "jtds:sqlserver";
    public static final String SUBPROTOCOL_MYSQL = "mysql";
    public static final String SUBPROTOCOL_ORACLE = "oracle";
    public static final String SUBPROTOCOL_ORACLE_INET = "inetora";
    public static final String SUBPROTOCOL_POSTGRESQL = "postgresql";
    public static final String SUBPROTOCOL_SAPDB = "sapdb";
    public static final String SUBPROTOCOL_SYBASE = "sybase:Tds";
    public static final String SUBPROTOCOL_SYBASE_INET = "inetsyb";
    public static final String SUBPROTOCOL_SYBASE_INET_POOLED = "inetpool:inetsyb";
    public static final String SUBPROTOCOL_SYBASE_JTDS = "jtds:sybase";
    private HashMap jdbcSubProtocolToPlatform = new HashMap();
    private HashMap jdbcDriverToPlatform = new HashMap();

    public JdbcMetadataUtils() {
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_DB2, PLATFORM_DB2);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_DB2_INET, PLATFORM_DB2);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_FIREBIRD, PLATFORM_FIREBIRD);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_HSQLDB, PLATFORM_HSQLDB);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_INFORMIX, PLATFORM_INFORMIX);
        this.jdbcSubProtocolToPlatform.put("sapdb", PLATFORM_MAXDB);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_MSSQLSERVER, PLATFORM_MSSQLSERVER);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_MSSQLSERVER_INET, PLATFORM_MSSQLSERVER);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_MSSQLSERVER6_INET, PLATFORM_MSSQLSERVER);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_MSSQLSERVER7_INET, PLATFORM_MSSQLSERVER);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_MSSQLSERVER7A_INET, PLATFORM_MSSQLSERVER);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_MSSQLSERVER_INET_POOLED, PLATFORM_MSSQLSERVER);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_MSSQLSERVER6_INET_POOLED, PLATFORM_MSSQLSERVER);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_MSSQLSERVER7_INET_POOLED, PLATFORM_MSSQLSERVER);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_MSSQLSERVER7A_INET_POOLED, PLATFORM_MSSQLSERVER);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_MSSQLSERVER_JTDS, PLATFORM_MSSQLSERVER);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_MYSQL, PLATFORM_MYSQL);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_ORACLE, PLATFORM_ORACLE);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_ORACLE_INET, PLATFORM_ORACLE);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_POSTGRESQL, PLATFORM_POSTGRESQL);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_SYBASE, PLATFORM_SYBASE);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_SYBASE_INET, PLATFORM_SYBASE);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_SYBASE_INET_POOLED, PLATFORM_SYBASE);
        this.jdbcSubProtocolToPlatform.put(SUBPROTOCOL_SYBASE_JTDS, PLATFORM_SYBASE);
        this.jdbcDriverToPlatform.put(DRIVER_DB2, PLATFORM_DB2);
        this.jdbcDriverToPlatform.put(DRIVER_DB2_INET, PLATFORM_DB2);
        this.jdbcDriverToPlatform.put(DRIVER_FIREBIRD, PLATFORM_FIREBIRD);
        this.jdbcDriverToPlatform.put(DRIVER_HSQLDB, PLATFORM_HSQLDB);
        this.jdbcDriverToPlatform.put(DRIVER_INFORMIX, PLATFORM_INFORMIX);
        this.jdbcDriverToPlatform.put("com.sap.dbtech.jdbc.DriverSapDB", PLATFORM_MAXDB);
        this.jdbcDriverToPlatform.put(DRIVER_MCKOI, PLATFORM_MCKOI);
        this.jdbcDriverToPlatform.put(DRIVER_MSSQLSERVER, PLATFORM_MSSQLSERVER);
        this.jdbcDriverToPlatform.put(DRIVER_MSSQLSERVER_INET, PLATFORM_MSSQLSERVER);
        this.jdbcDriverToPlatform.put(DRIVER_MSSQLSERVER_JSQLCONNECT, PLATFORM_MSSQLSERVER);
        this.jdbcDriverToPlatform.put(DRIVER_MYSQL, PLATFORM_MYSQL);
        this.jdbcDriverToPlatform.put(DRIVER_MYSQL_OLD, PLATFORM_MYSQL);
        this.jdbcDriverToPlatform.put(DRIVER_ORACLE, PLATFORM_ORACLE);
        this.jdbcDriverToPlatform.put(DRIVER_ORACLE_INET, PLATFORM_ORACLE);
        this.jdbcDriverToPlatform.put(DRIVER_POSTGRESQL, PLATFORM_POSTGRESQL);
        this.jdbcDriverToPlatform.put(DRIVER_SYBASE, PLATFORM_SYBASE);
        this.jdbcDriverToPlatform.put(DRIVER_SYBASE_OLD, PLATFORM_SYBASE);
        this.jdbcDriverToPlatform.put(DRIVER_SYBASE_INET, PLATFORM_SYBASE);
    }

    public void fillJCDFromDataSource(JdbcConnectionDescriptor jcd, DataSource dataSource, String username, String password) throws MetadataException {
        String realUsername = jcd.getUserName() != null ? jcd.getUserName() : username;
        String realPassword = jcd.getPassWord() != null ? jcd.getPassWord() : password;
        Connection connection = null;
        DatabaseMetaData metadata = null;
        try {
            connection = realUsername != null ? dataSource.getConnection(realUsername, realPassword) : dataSource.getConnection();
            metadata = connection.getMetaData();
        }
        catch (Throwable t) {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {
                    // empty catch block
                }
            }
            throw new MetadataException("Could not get the metadata from the given datasource", t);
        }
        try {
            HashMap urlComponents = this.parseConnectionUrl(metadata.getURL());
            if (urlComponents.containsKey(PROPERTY_DBALIAS)) {
                jcd.setProtocol((String)urlComponents.get(PROPERTY_PROTOCOL));
                jcd.setSubProtocol((String)urlComponents.get(PROPERTY_SUBPROTOCOL));
                jcd.setDbAlias((String)urlComponents.get(PROPERTY_DBALIAS));
                if (this.jdbcSubProtocolToPlatform.containsKey(jcd.getSubProtocol())) {
                    jcd.setDbms((String)this.jdbcSubProtocolToPlatform.get(jcd.getSubProtocol()));
                }
            }
        }
        catch (Throwable t) {
            try {
                connection.close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            throw new MetadataException("Could not get the metadata from the given datasource", t);
        }
        try {
            Integer majorVersion = (Integer)PropertyUtils.getProperty((Object)metadata, (String)"JDBCMajorVersion");
            Integer minorVersion = (Integer)PropertyUtils.getProperty((Object)metadata, (String)"JDBCMinorVersion");
            jcd.setJdbcLevel(Double.parseDouble(majorVersion.toString() + "." + minorVersion.toString()));
        }
        catch (Throwable t) {
            jcd.setJdbcLevel(2.0);
        }
        try {
            connection.close();
        }
        catch (SQLException ex) {
            // empty catch block
        }
    }

    public HashMap parseConnectionUrl(String jdbcConnectionUrl) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (jdbcConnectionUrl == null) {
            return result;
        }
        int pos = jdbcConnectionUrl.indexOf(58);
        result.put(PROPERTY_PROTOCOL, jdbcConnectionUrl.substring(0, pos));
        int lastPos = pos;
        pos = jdbcConnectionUrl.indexOf(58, lastPos + 1);
        String subProtocol = jdbcConnectionUrl.substring(lastPos + 1, pos);
        if ("inetpool".equals(subProtocol)) {
            int tmpPos = jdbcConnectionUrl.indexOf(58, pos + 1);
            if ("inetpool:jdbc".equals(jdbcConnectionUrl.substring(lastPos + 1, tmpPos))) {
                pos = tmpPos;
                tmpPos = jdbcConnectionUrl.indexOf(58, pos + 1);
            }
            subProtocol = subProtocol + ":" + jdbcConnectionUrl.substring(pos + 1, tmpPos);
        } else if ("jtds".equals(subProtocol) || "microsoft".equals(subProtocol) || "sybase".equals(subProtocol)) {
            pos = jdbcConnectionUrl.indexOf(58, pos + 1);
            subProtocol = ":" + jdbcConnectionUrl.substring(lastPos + 1, pos);
        }
        result.put(PROPERTY_SUBPROTOCOL, subProtocol);
        result.put(PROPERTY_DBALIAS, jdbcConnectionUrl.substring(pos + 1));
        return result;
    }

    public String findPlatformFor(String jdbcSubProtocol, String jdbcDriver) {
        String platform = (String)this.jdbcSubProtocolToPlatform.get(jdbcSubProtocol);
        if (platform == null) {
            platform = (String)this.jdbcDriverToPlatform.get(jdbcDriver);
        }
        return platform;
    }
}

