/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.locking;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.locking.LockIsolation;
import org.apache.ojb.broker.locking.LockIsolationManager;
import org.apache.ojb.broker.locking.LockManager;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class LockManagerInMemoryImpl
implements LockManager {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$locking$LockManagerInMemoryImpl == null ? (class$org$apache$ojb$broker$locking$LockManagerInMemoryImpl = LockManagerInMemoryImpl.class$("org.apache.ojb.broker.locking.LockManagerInMemoryImpl")) : class$org$apache$ojb$broker$locking$LockManagerInMemoryImpl);
    private static long CLEANUP_FREQUENCY = 1000L;
    private static int MAX_LOCKS_TO_CLEAN = 300;
    private HashMap locktable = new HashMap();
    private LockIsolationManager lockStrategyManager = new LockIsolationManager();
    private long m_lastCleanupAt = System.currentTimeMillis();
    private long lockTimeout = 60000L;
    private long timeoutCounterRead;
    private long timeoutCounterWrite;
    static /* synthetic */ Class class$org$apache$ojb$broker$locking$LockManagerInMemoryImpl;

    public long getLockTimeout() {
        return this.lockTimeout;
    }

    public void setLockTimeout(long timeout) {
        this.lockTimeout = timeout;
    }

    public long getBlockTimeout() {
        return 0L;
    }

    public void setBlockTimeout(long timeout) {
    }

    public String getLockInfo() {
        String eol = SystemUtils.LINE_SEPARATOR;
        StringBuffer msg = new StringBuffer("Class: " + (class$org$apache$ojb$broker$locking$LockManagerInMemoryImpl == null ? (class$org$apache$ojb$broker$locking$LockManagerInMemoryImpl = LockManagerInMemoryImpl.class$("org.apache.ojb.broker.locking.LockManagerInMemoryImpl")) : class$org$apache$ojb$broker$locking$LockManagerInMemoryImpl).getName() + eol);
        msg.append("lock timeout: " + this.getLockTimeout() + " [ms]" + eol);
        msg.append("concurrent lock owners: " + this.locktable.size() + eol);
        msg.append("timed out write locks: " + this.timeoutCounterWrite + eol);
        msg.append("timed out read locks: " + this.timeoutCounterRead + eol);
        return msg.toString();
    }

    public boolean readLock(Object key, Object resourceId, int isolationLevel) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("LM.readLock(tx-" + key + ", " + resourceId + ")");
        }
        this.checkTimedOutLocks();
        LockEntry reader = new LockEntry(resourceId, key, System.currentTimeMillis(), isolationLevel, 0);
        LockIsolation ls = this.lockStrategyManager.getStrategyFor(isolationLevel);
        return this.addReaderIfPossibleInternal(reader, ls.allowMultipleRead(), ls.allowReadWhenWrite());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addReaderIfPossibleInternal(LockEntry reader, boolean allowMultipleReader, boolean allowReaderWhenWriteLock) {
        boolean result = false;
        ObjectLocks objectLocks = null;
        Object oid = reader.getResourceId();
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            objectLocks = (ObjectLocks)this.locktable.get(oid);
            if (objectLocks == null) {
                objectLocks = new ObjectLocks();
                this.locktable.put(oid, objectLocks);
                objectLocks.addReader(reader);
                result = true;
            } else {
                LockEntry writer = objectLocks.getWriter();
                if (writer != null) {
                    if (writer.isOwnedBy(reader.getKey())) {
                        result = true;
                    } else if (allowReaderWhenWriteLock && allowMultipleReader) {
                        objectLocks.addReader(reader);
                        result = true;
                    } else {
                        result = false;
                    }
                } else if (objectLocks.getReaders().size() > 0) {
                    if (objectLocks.getReader(reader.getKey()) != null) {
                        result = true;
                    } else if (allowMultipleReader) {
                        objectLocks.addReader(reader);
                        result = true;
                    }
                } else {
                    objectLocks.addReader(reader);
                    result = true;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeReader(Object key, Object resourceId) {
        boolean result = false;
        ObjectLocks objectLocks = null;
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            objectLocks = (ObjectLocks)this.locktable.get(resourceId);
            if (objectLocks != null) {
                Hashtable readers = objectLocks.getReaders();
                boolean bl = result = readers.remove(key) != null;
                if (objectLocks.getWriter() == null && readers.size() == 0) {
                    this.locktable.remove(resourceId);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeWriter(Object key, Object resourceId) {
        boolean result = false;
        ObjectLocks objectLocks = null;
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            LockEntry entry;
            objectLocks = (ObjectLocks)this.locktable.get(resourceId);
            if (objectLocks != null && (entry = objectLocks.getWriter()) != null && entry.isOwnedBy(key)) {
                objectLocks.setWriter(null);
                result = true;
                if (objectLocks.getReaders().size() == 0) {
                    this.locktable.remove(resourceId);
                }
            }
        }
        return result;
    }

    public boolean releaseLock(Object key, Object resourceId) {
        boolean result;
        if (this.log.isDebugEnabled()) {
            this.log.debug("LM.releaseLock(tx-" + key + ", " + resourceId + ")");
        }
        if (!(result = this.removeReader(key, resourceId))) {
            result = this.removeWriter(key, resourceId);
        }
        return result;
    }

    public void releaseLocks(Object key) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("LM.releaseLocks(tx-" + key + ")");
        }
        this.checkTimedOutLocks();
        this.releaseLocksInternal(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLocksInternal(Object key) {
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            Collection values = this.locktable.values();
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                ObjectLocks entry = (ObjectLocks)iterator.next();
                entry.removeReader(key);
                if (entry.getWriter() == null || !entry.getWriter().isOwnedBy(key)) continue;
                entry.setWriter(null);
            }
        }
    }

    public boolean writeLock(Object key, Object resourceId, int isolationLevel) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("LM.writeLock(tx-" + key + ", " + resourceId + ")");
        }
        this.checkTimedOutLocks();
        LockEntry writer = new LockEntry(resourceId, key, System.currentTimeMillis(), isolationLevel, 1);
        LockIsolation ls = this.lockStrategyManager.getStrategyFor(isolationLevel);
        return this.setWriterIfPossibleInternal(writer, ls.allowWriteWhenRead());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setWriterIfPossibleInternal(LockEntry writer, boolean allowReaders) {
        boolean result = false;
        ObjectLocks objectLocks = null;
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            objectLocks = (ObjectLocks)this.locktable.get(writer.getResourceId());
            if (objectLocks == null) {
                objectLocks = new ObjectLocks();
                objectLocks.setWriter(writer);
                this.locktable.put(writer.getResourceId(), objectLocks);
                result = true;
            } else {
                LockEntry oldWriter = objectLocks.getWriter();
                if (oldWriter != null) {
                    if (oldWriter.isOwnedBy(writer.getKey())) {
                        result = true;
                    }
                } else {
                    int readerSize = objectLocks.getReaders().size();
                    if (readerSize > 0) {
                        if (objectLocks.getReader(writer.getKey()) != null) {
                            if (readerSize == 1) {
                                objectLocks.readers.remove(writer.getKey());
                                objectLocks.setWriter(writer);
                                result = true;
                            } else if (allowReaders) {
                                objectLocks.readers.remove(writer.getKey());
                                objectLocks.setWriter(writer);
                                result = true;
                            }
                        } else if (allowReaders) {
                            objectLocks.setWriter(writer);
                            result = true;
                        }
                    } else {
                        objectLocks.setWriter(writer);
                        result = true;
                    }
                }
            }
        }
        return result;
    }

    public boolean upgradeLock(Object key, Object resourceId, int isolationLevel) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("LM.upgradeLock(tx-" + key + ", " + resourceId + ")");
        }
        return this.writeLock(key, resourceId, isolationLevel);
    }

    public boolean hasWrite(Object key, Object resourceId) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("LM.hasWrite(tx-" + key + ", " + resourceId + ")");
        }
        this.checkTimedOutLocks();
        return this.hasWriteLockInternal(resourceId, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasWriteLockInternal(Object resourceId, Object key) {
        boolean result = false;
        ObjectLocks objectLocks = null;
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            LockEntry writer;
            objectLocks = (ObjectLocks)this.locktable.get(resourceId);
            if (objectLocks != null && (writer = objectLocks.getWriter()) != null) {
                result = writer.isOwnedBy(key);
            }
        }
        return result;
    }

    public boolean hasUpgrade(Object key, Object resourceId) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("LM.hasUpgrade(tx-" + key + ", " + resourceId + ")");
        }
        return this.hasWrite(key, resourceId);
    }

    public boolean hasRead(Object key, Object resourceId) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("LM.hasRead(tx-" + key + ", " + resourceId + ')');
        }
        this.checkTimedOutLocks();
        return this.hasReadLockInternal(resourceId, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasReadLockInternal(Object resourceId, Object key) {
        boolean result = false;
        ObjectLocks objectLocks = null;
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            LockEntry reader;
            objectLocks = (ObjectLocks)this.locktable.get(resourceId);
            if (objectLocks != null && ((reader = objectLocks.getReader(key)) != null || objectLocks.getWriter() != null && objectLocks.getWriter().isOwnedBy(key))) {
                result = true;
            }
        }
        return result;
    }

    public int lockedObjects() {
        return this.locktable.size();
    }

    private void checkTimedOutLocks() {
        if (System.currentTimeMillis() - this.m_lastCleanupAt > CLEANUP_FREQUENCY) {
            this.removeTimedOutLocks(this.getLockTimeout());
            this.m_lastCleanupAt = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTimedOutLocks(long timeout) {
        long maxAge = System.currentTimeMillis() - timeout;
        boolean breakFromLoop = false;
        ObjectLocks temp = null;
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            Iterator it = this.locktable.values().iterator();
            for (int count = 0; it.hasNext() && !breakFromLoop && count <= MAX_LOCKS_TO_CLEAN; ++count) {
                temp = (ObjectLocks)it.next();
                if (temp.getWriter() != null && temp.getWriter().getTimestamp() < maxAge) {
                    temp.setWriter(null);
                    ++this.timeoutCounterWrite;
                }
                if (temp.getYoungestReader() < maxAge) {
                    temp.getReaders().clear();
                    ++this.timeoutCounterRead;
                    if (temp.getWriter() != null) continue;
                    it.remove();
                    continue;
                }
                Iterator readerIt = temp.getReaders().values().iterator();
                LockEntry readerLock = null;
                while (readerIt.hasNext()) {
                    readerLock = (LockEntry)readerIt.next();
                    if (readerLock.getTimestamp() >= maxAge) continue;
                    readerIt.remove();
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    final class LockEntry
    implements Serializable {
        static final int LOCK_READ = 0;
        static final int LOCK_WRITE = 1;
        private Object resourceId;
        private Object key;
        private long timestamp;
        private int isolationLevel;
        private int lockType;

        public LockEntry(Object resourceId, Object key, long timestamp, int isolationLevel, int lockType) {
            this.resourceId = resourceId;
            this.key = key;
            this.timestamp = timestamp;
            this.isolationLevel = isolationLevel;
            this.lockType = lockType;
        }

        public Object getResourceId() {
            return this.resourceId;
        }

        public Object getKey() {
            return this.key;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public int getIsolationLevel() {
            return this.isolationLevel;
        }

        public int getLockType() {
            return this.lockType;
        }

        public void setLockType(int locktype) {
            this.lockType = locktype;
        }

        public boolean isOwnedBy(Object key) {
            return this.getKey().equals(key);
        }

        public void setIsolationLevel(int isolationLevel) {
            this.isolationLevel = isolationLevel;
        }

        public void setresourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public void setKey(Object key) {
            this.key = key;
        }
    }

    static final class ObjectLocks {
        private LockEntry writer;
        private Hashtable readers;
        private long m_youngestReader = 0L;

        ObjectLocks() {
            this(null);
        }

        ObjectLocks(LockEntry writer) {
            this.writer = writer;
            this.readers = new Hashtable();
        }

        LockEntry getWriter() {
            return this.writer;
        }

        void setWriter(LockEntry writer) {
            this.writer = writer;
        }

        Hashtable getReaders() {
            return this.readers;
        }

        void addReader(LockEntry reader) {
            if (reader.getTimestamp() < this.m_youngestReader || this.m_youngestReader == 0L) {
                this.m_youngestReader = reader.getTimestamp();
            }
            this.readers.put(reader.getKey(), reader);
        }

        long getYoungestReader() {
            return this.m_youngestReader;
        }

        LockEntry getReader(Object key) {
            return (LockEntry)this.readers.get(key);
        }

        LockEntry removeReader(Object key) {
            return (LockEntry)this.readers.remove(key);
        }
    }
}

