/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core.proxy;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.core.PersistenceBrokerThreadMapping;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.MaterializationListener;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class IndirectionHandlerDefaultImpl
implements IndirectionHandler {
    static final long serialVersionUID = -1993879565033755826L;
    private transient PersistenceBroker _broker = null;
    private PBKey _brokerKey;
    private Object _realSubject = null;
    private Identity _id = null;
    private transient ArrayList _listeners;
    private boolean _needsClose;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$proxy$IndirectionHandler;

    public IndirectionHandlerDefaultImpl(PBKey brokerKey, Identity id) {
        this.setBrokerKey(brokerKey);
        this.setIdentity(id);
    }

    public Identity getIdentity() {
        return this._id;
    }

    protected void setIdentity(Identity identity) {
        this._id = identity;
    }

    public PBKey getBrokerKey() {
        return this._brokerKey;
    }

    protected void setBrokerKey(PBKey brokerKey) {
        this._brokerKey = brokerKey;
    }

    public synchronized void addListener(MaterializationListener listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    public synchronized void removeListener(MaterializationListener listener) {
        if (this._listeners != null) {
            this._listeners.remove(listener);
        }
    }

    protected void beforeMaterialization() {
        if (this._listeners != null) {
            for (int idx = this._listeners.size() - 1; idx >= 0; --idx) {
                MaterializationListener listener = (MaterializationListener)this._listeners.get(idx);
                listener.beforeMaterialization(this, this._id);
            }
        }
    }

    protected void afterMaterialization() {
        if (this._listeners != null) {
            for (int idx = this._listeners.size() - 1; idx >= 0; --idx) {
                MaterializationListener listener = (MaterializationListener)this._listeners.get(idx);
                listener.afterMaterialization(this, this._realSubject);
            }
        }
    }

    protected synchronized PersistenceBroker getBroker() throws PBFactoryException {
        if (this.getBrokerKey() == null) {
            throw new OJBRuntimeException("Can't find associated PBKey. Need PBKey to obtain a validPersistenceBroker instance from intern resources.");
        }
        PersistenceBroker broker = PersistenceBrokerThreadMapping.currentPersistenceBroker(this.getBrokerKey());
        if (broker == null && this._broker == null) {
            this._broker = PersistenceBrokerFactory.createPersistenceBroker(this.getBrokerKey());
            this._needsClose = true;
            broker = this._broker;
        }
        return broker;
    }

    protected void releaseBroker() {
        if (this._broker != null && this._needsClose) {
            this._needsClose = false;
            this._broker.close();
            this._broker = null;
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) {
        Object subject = null;
        String methodName = method.getName();
        try {
            if ("equals".equals(methodName) && args[0] != null) {
                Object otherObj;
                args[0] = otherObj = ProxyHelper.getRealObject(args[0]);
            }
            subject = this.getRealSubject();
            return method.invoke(subject, args);
        }
        catch (Exception ex) {
            throw new PersistenceBrokerException("Error invoking method " + method.getName(), ex);
        }
    }

    public Object getRealSubject() throws PersistenceBrokerException {
        if (this._realSubject == null) {
            this.beforeMaterialization();
            this._realSubject = this.materializeSubject();
            this.afterMaterialization();
        }
        return this._realSubject;
    }

    public void setRealSubject(Object object) {
        this._realSubject = object;
    }

    protected synchronized Object materializeSubject() throws PersistenceBrokerException {
        try {
            Object realSubject = this.getBroker().getObjectByIdentity(this._id);
            if (realSubject == null) {
                LoggerFactory.getLogger(class$org$apache$ojb$broker$core$proxy$IndirectionHandler == null ? (class$org$apache$ojb$broker$core$proxy$IndirectionHandler = IndirectionHandlerDefaultImpl.class$("org.apache.ojb.broker.core.proxy.IndirectionHandler")) : class$org$apache$ojb$broker$core$proxy$IndirectionHandler).warn("Can not materialize object for Identity " + this._id + " - using PBKey " + this._brokerKey);
            }
            Object object = realSubject;
            return object;
        }
        catch (Exception ex) {
            throw new PersistenceBrokerException(ex);
        }
        finally {
            this.releaseBroker();
        }
    }

    public boolean alreadyMaterialized() {
        return this._realSubject != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

