/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.AbstractMetaCache;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.cache.ObjectCacheJCSImpl;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class ObjectCacheJCSPerClassImpl
extends AbstractMetaCache {
    private static Map cachesByClass = new HashMap();

    public ObjectCacheJCSPerClassImpl(PersistenceBroker broker, Properties prop) {
    }

    public ObjectCache getCache(Identity oid, Object obj, int methodCall) {
        if (oid.getObjectsRealClass() == null) {
            LoggerFactory.getDefaultLogger().info("[" + this.getClass() + "] Can't get JCS cache, real class was 'null' for Identity: " + oid);
            return null;
        }
        return this.getCachePerClass(oid.getObjectsRealClass(), methodCall);
    }

    public void clear() {
        Iterator it = cachesByClass.values().iterator();
        while (it.hasNext()) {
            ObjectCache cache = (ObjectCache)it.next();
            if (cache != null) {
                cache.clear();
                continue;
            }
            it.remove();
        }
    }

    private ObjectCache getCachePerClass(Class objectClass, int methodCall) {
        ObjectCache cache = (ObjectCache)cachesByClass.get(objectClass.getName());
        if (cache == null && methodCall == 1) {
            cache = new ObjectCacheJCSImpl(objectClass.getName());
            cachesByClass.put(objectClass.getName(), cache);
        }
        return cache;
    }
}

