/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer.conversions;

import java.util.Vector;
import org.apache.ojb.broker.accesslayer.conversions.ConversionException;
import org.apache.ojb.broker.accesslayer.conversions.FieldConversion;

public class StringVector2VarcharFieldConversion
implements FieldConversion {
    private static final String NULLVALUE = "#NULL#";
    private static final String EMPTYCOLLEC = "#EMTPY#";
    private static final String SEPARATOR = "#";

    public Object javaToSql(Object obj) throws ConversionException {
        if (obj == null) {
            return NULLVALUE;
        }
        if (!(obj instanceof Vector)) {
            throw new ConversionException("Object is not a vector it is a" + obj.getClass().getName());
        }
        Vector v = (Vector)obj;
        if (v.size() == 0) {
            return EMPTYCOLLEC;
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < v.size(); ++i) {
            String newSt = v.get(i).toString();
            if (newSt.indexOf(SEPARATOR) >= 0) {
                throw new ConversionException("An entry in the Vector contains the forbidden # character used to separate the strings on the DB");
            }
            result.append(newSt);
            result.append(SEPARATOR);
        }
        return result.toString();
    }

    public Object sqlToJava(Object obj) throws ConversionException {
        if (obj == null) {
            return null;
        }
        if (obj.toString().equals(NULLVALUE)) {
            return null;
        }
        if (obj.toString().equals(EMPTYCOLLEC)) {
            return new Vector();
        }
        Vector<String> v = new Vector<String>();
        String input = obj.toString();
        int pos = input.indexOf(SEPARATOR);
        while (pos >= 0) {
            if (pos == 0) {
                v.add("");
            } else {
                v.add(input.substring(0, pos));
            }
            if (pos + 1 > input.length()) break;
            input = input.substring(pos + 1, input.length());
            pos = input.indexOf(SEPARATOR);
        }
        return v;
    }
}

