/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPoolFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.accesslayer.ConnectionFactoryAbstractImpl;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class ConnectionFactoryDBCPImpl
extends ConnectionFactoryAbstractImpl {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$accesslayer$ConnectionFactoryDBCPImpl == null ? (class$org$apache$ojb$broker$accesslayer$ConnectionFactoryDBCPImpl = ConnectionFactoryDBCPImpl.class$("org.apache.ojb.broker.accesslayer.ConnectionFactoryDBCPImpl")) : class$org$apache$ojb$broker$accesslayer$ConnectionFactoryDBCPImpl);
    private Map poolMap = Collections.synchronizedMap(new HashMap());
    private Map dsMap = Collections.synchronizedMap(new HashMap());
    private Object poolSynch = new Object();
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$ConnectionFactoryDBCPImpl;

    public Connection getConnectionFromPool(JdbcConnectionDescriptor jcd) throws LookupException {
        Connection conn;
        DataSource ds = this.getDataSource(jcd);
        try {
            conn = ds.getConnection();
        }
        catch (SQLException e) {
            throw new LookupException("Could not get connection from DBCP DataSource", e);
        }
        return conn;
    }

    public void returnConnectionToPool(JdbcConnectionDescriptor jcd, Connection con) throws LookupException {
        try {
            con.close();
        }
        catch (SQLException e) {
            this.log.warn("Connection close failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAllResources() {
        super.releaseAllResources();
        Object object = this.poolSynch;
        synchronized (object) {
            if (!this.poolMap.isEmpty()) {
                Collection pools = this.poolMap.values();
                Iterator iterator = pools.iterator();
                ObjectPool op = null;
                while (iterator.hasNext()) {
                    try {
                        op = (ObjectPool)iterator.next();
                        op.close();
                    }
                    catch (Exception e) {
                        this.log.error("Exception occured while closing ObjectPool " + op, e);
                    }
                }
                this.poolMap.clear();
            }
            this.dsMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSource getDataSource(JdbcConnectionDescriptor jcd) throws LookupException {
        PBKey key = jcd.getPBKey();
        DataSource ds = (DataSource)this.dsMap.get(key);
        if (ds == null) {
            try {
                Object object = this.poolSynch;
                synchronized (object) {
                    ObjectPool pool = this.setupPool(jcd);
                    this.poolMap.put(key, pool);
                    ds = this.createPoolingDataSource(pool);
                    this.dsMap.put(key, ds);
                }
            }
            catch (Exception e) {
                this.log.error("Could not setup DBCP DataSource for " + jcd, e);
                throw new LookupException(e);
            }
        }
        return ds;
    }

    protected ObjectPool setupPool(JdbcConnectionDescriptor jcd) {
        this.log.info("Create new ObjectPool for DBCP connections:" + jcd);
        try {
            ClassHelper.newInstance(jcd.getDriver());
        }
        catch (InstantiationException e) {
            this.log.fatal("Unable to instantiate the driver class: " + jcd.getDriver() + " in ConnectionFactoryDBCImpl!", e);
        }
        catch (IllegalAccessException e) {
            this.log.fatal("IllegalAccessException while instantiating the driver class: " + jcd.getDriver() + " in ConnectionFactoryDBCImpl!", e);
        }
        catch (ClassNotFoundException e) {
            this.log.fatal("Could not find the driver class : " + jcd.getDriver() + " in ConnectionFactoryDBCImpl!", e);
        }
        GenericObjectPool.Config conf = jcd.getConnectionPoolDescriptor().getObjectPoolConfig();
        ObjectPool connectionPool = this.createObjectPool(conf);
        ConnectionFactory connectionFactory = this.createConnectionFactory(jcd);
        KeyedObjectPoolFactory statementPoolFactory = this.createStatementPoolFactory(jcd);
        String validationQuery = jcd.getConnectionPoolDescriptor().getValidationQuery();
        boolean defaultReadOnly = false;
        boolean defaultAutoCommit = jcd.getUseAutoCommit() != 2;
        AbandonedConfig ac = jcd.getConnectionPoolDescriptor().getAbandonedConfig();
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory(connectionFactory, connectionPool, statementPoolFactory, validationQuery, defaultReadOnly, defaultAutoCommit, ac);
        return poolableConnectionFactory.getPool();
    }

    protected ObjectPool createObjectPool(GenericObjectPool.Config config) {
        return new GenericObjectPool(null, config);
    }

    protected KeyedObjectPoolFactory createStatementPoolFactory(JdbcConnectionDescriptor jcd) {
        String platform = jcd.getDbms();
        if (platform.equals("Oracle9i")) {
            return null;
        }
        KeyedPoolableObjectFactory objectFactory = null;
        GenericKeyedObjectPool.Config factoryConfig = new GenericKeyedObjectPool.Config();
        GenericKeyedObjectPoolFactory stmtPoolFactory = new GenericKeyedObjectPoolFactory(objectFactory, factoryConfig);
        return stmtPoolFactory;
    }

    protected PoolingDataSource createPoolingDataSource(ObjectPool pool) {
        return new PoolingDataSource(pool);
    }

    protected ConnectionFactory createConnectionFactory(JdbcConnectionDescriptor jcd) {
        return new ConPoolFactory(jcd);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ConPoolFactory
    extends DriverManagerConnectionFactory {
        private final JdbcConnectionDescriptor jcd;

        public ConPoolFactory(JdbcConnectionDescriptor jcd) {
            super(ConnectionFactoryDBCPImpl.this.getDbURL(jcd), jcd.getUserName(), jcd.getPassWord());
            this.jcd = jcd;
        }

        public Connection createConnection() throws SQLException {
            Connection conn = super.createConnection();
            if (conn != null) {
                try {
                    ConnectionFactoryDBCPImpl.this.initializeJdbcConnection(conn, this.jcd);
                }
                catch (LookupException e) {
                    ConnectionFactoryDBCPImpl.this.log.error("Platform dependent initialization of connection failed", (Throwable)((Object)e));
                }
            }
            return conn;
        }
    }
}

