/*
 * Decompiled with CFR 0.152.
 */
package ognl.benchmarks;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import ognl.OgnlRuntime;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Benchmark)
@BenchmarkMode(value={Mode.AverageTime, Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=1, warmups=1, jvmArgs={"--add-opens=java.base/java.lang=ALL-UNNAMED", "--add-opens=java.base/java.lang.reflect=ALL-UNNAMED", "--add-opens=java.base/java.util=ALL-UNNAMED"})
@Warmup(iterations=3, time=1)
@Measurement(iterations=5, time=1)
public class OgnlRuntimePerformanceBenchmarks {
    private void runTest(Class<?> clazz, Method method, int invocationCount, int threadCount, Class<?>[] expected, Blackhole blackhole) throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);
        ArrayList<Future<Class<?>[]>> futures = new ArrayList<Future<Class<?>[]>>(threadCount);
        for (int i = threadCount; i > 0; --i) {
            futures.add(executor.submit(new Worker(clazz, method, invocationCount)));
        }
        for (Future future : futures) {
            Class[] classes = (Class[])future.get();
            assert (expected == classes);
            blackhole.consume((Object)classes);
        }
        executor.shutdown();
    }

    @Benchmark
    public void testPerformanceRealGenericSingleThread(Blackhole blackhole) throws Exception {
        Method barMethod = ExampleStringClass.class.getMethod("bar", Object.class);
        this.runTest(ExampleStringClass.class, barMethod, 10000000, 1, new Class[]{String.class}, blackhole);
    }

    @Benchmark
    public void testPerformanceFakeGenericSingleThread(Blackhole blackhole) throws Exception {
        Method fooMethod = ExampleStringClass.class.getMethod("foo", Integer.class, Date.class);
        this.runTest(ExampleStringClass.class, fooMethod, 10000000, 1, new Class[]{Integer.class, Date.class}, blackhole);
    }

    @Benchmark
    public void testPerformanceNonGenericSingleThread(Blackhole blackhole) throws Exception {
        Method fooMethod = ExampleStringSubclass.class.getMethod("foo", Integer.class, Date.class);
        this.runTest(ExampleStringSubclass.class, fooMethod, 10000000, 1, new Class[]{Integer.class, Date.class}, blackhole);
    }

    @Benchmark
    public void testPerformanceRealGenericMultipleThreads(Blackhole blackhole) throws Exception {
        Method barMethod = ExampleStringClass.class.getMethod("bar", Object.class);
        this.runTest(ExampleStringClass.class, barMethod, 100000, 100, new Class[]{String.class}, blackhole);
    }

    @Benchmark
    public void testPerformanceFakeGenericMultipleThreads(Blackhole blackhole) throws Exception {
        Method fooMethod = ExampleStringClass.class.getMethod("foo", Integer.class, Date.class);
        this.runTest(ExampleStringClass.class, fooMethod, 100000, 100, new Class[]{Integer.class, Date.class}, blackhole);
    }

    @Benchmark
    public void testPerformanceNotGenericMultipleThreads(Blackhole blackhole) throws Exception {
        Method fooMethod = ExampleStringSubclass.class.getMethod("foo", Integer.class, Date.class);
        this.runTest(ExampleStringSubclass.class, fooMethod, 100000, 100, new Class[]{Integer.class, Date.class}, blackhole);
    }

    @Benchmark
    public void testPerformanceMultipleClassesMultipleMethodsSingleThread(Blackhole blackhole) throws Exception {
        Method barMethod = ExampleTwoMethodClass.class.getMethod("bar", String.class);
        Method fooMethod = ExampleTwoMethodClass.class.getMethod("foo", Integer.class, Date.class);
        this.runTest(ExampleTwoMethodClass.class, barMethod, 10000000, 1, new Class[]{String.class}, blackhole);
        this.runTest(ExampleTwoMethodClass.class, fooMethod, 10000000, 1, new Class[]{Integer.class, Date.class}, blackhole);
        barMethod = ExampleTwoMethodClass2.class.getMethod("bar", String.class);
        fooMethod = ExampleTwoMethodClass2.class.getMethod("foo", Integer.class, Date.class);
        this.runTest(ExampleTwoMethodClass2.class, barMethod, 10000000, 1, new Class[]{String.class}, blackhole);
        this.runTest(ExampleTwoMethodClass2.class, fooMethod, 10000000, 1, new Class[]{Integer.class, Date.class}, blackhole);
        barMethod = ExampleTwoMethodClass3.class.getMethod("bar", String.class);
        fooMethod = ExampleTwoMethodClass3.class.getMethod("foo", Integer.class, Date.class);
        this.runTest(ExampleTwoMethodClass3.class, barMethod, 10000000, 1, new Class[]{String.class}, blackhole);
        this.runTest(ExampleTwoMethodClass3.class, fooMethod, 10000000, 1, new Class[]{Integer.class, Date.class}, blackhole);
        barMethod = ExampleTwoMethodClass4.class.getMethod("bar", String.class);
        fooMethod = ExampleTwoMethodClass4.class.getMethod("foo", Integer.class, Date.class);
        this.runTest(ExampleTwoMethodClass4.class, barMethod, 10000000, 1, new Class[]{String.class}, blackhole);
        this.runTest(ExampleTwoMethodClass4.class, fooMethod, 10000000, 1, new Class[]{Integer.class, Date.class}, blackhole);
        barMethod = ExampleTwoMethodClass5.class.getMethod("bar", String.class);
        fooMethod = ExampleTwoMethodClass5.class.getMethod("foo", Integer.class, Date.class);
        this.runTest(ExampleTwoMethodClass5.class, barMethod, 10000000, 1, new Class[]{String.class}, blackhole);
        this.runTest(ExampleTwoMethodClass5.class, fooMethod, 10000000, 1, new Class[]{Integer.class, Date.class}, blackhole);
        barMethod = ExampleTwoMethodClass6.class.getMethod("bar", String.class);
        fooMethod = ExampleTwoMethodClass6.class.getMethod("foo", Integer.class, Date.class);
        this.runTest(ExampleTwoMethodClass6.class, barMethod, 10000000, 1, new Class[]{String.class}, blackhole);
        this.runTest(ExampleTwoMethodClass6.class, fooMethod, 10000000, 1, new Class[]{Integer.class, Date.class}, blackhole);
        barMethod = ExampleTwoMethodClass7.class.getMethod("bar", String.class);
        fooMethod = ExampleTwoMethodClass7.class.getMethod("foo", Integer.class, Date.class);
        this.runTest(ExampleTwoMethodClass7.class, barMethod, 10000000, 1, new Class[]{String.class}, blackhole);
        this.runTest(ExampleTwoMethodClass7.class, fooMethod, 10000000, 1, new Class[]{Integer.class, Date.class}, blackhole);
        barMethod = ExampleTwoMethodClass8.class.getMethod("bar", String.class);
        fooMethod = ExampleTwoMethodClass8.class.getMethod("foo", Integer.class, Date.class);
        this.runTest(ExampleTwoMethodClass8.class, barMethod, 10000000, 1, new Class[]{String.class}, blackhole);
        this.runTest(ExampleTwoMethodClass8.class, fooMethod, 10000000, 1, new Class[]{Integer.class, Date.class}, blackhole);
        barMethod = ExampleTwoMethodClass9.class.getMethod("bar", String.class);
        fooMethod = ExampleTwoMethodClass9.class.getMethod("foo", Integer.class, Date.class);
        this.runTest(ExampleTwoMethodClass9.class, barMethod, 10000000, 1, new Class[]{String.class}, blackhole);
        this.runTest(ExampleTwoMethodClass9.class, fooMethod, 10000000, 1, new Class[]{Integer.class, Date.class}, blackhole);
        barMethod = ExampleTwoMethodClass10.class.getMethod("bar", String.class);
        fooMethod = ExampleTwoMethodClass10.class.getMethod("foo", Integer.class, Date.class);
        this.runTest(ExampleTwoMethodClass10.class, barMethod, 10000000, 1, new Class[]{String.class}, blackhole);
        this.runTest(ExampleTwoMethodClass10.class, fooMethod, 10000000, 1, new Class[]{Integer.class, Date.class}, blackhole);
    }

    @Benchmark
    public void testPerformanceMultipleClassesMultipleMethodsMultipleThreads(Blackhole blackhole) throws Exception {
        Method barMethod = ExampleTwoMethodClass.class.getMethod("bar", String.class);
        Method fooMethod = ExampleTwoMethodClass.class.getMethod("foo", Integer.class, Date.class);
        this.runTest(ExampleTwoMethodClass.class, barMethod, 100000, 100, new Class[]{String.class}, blackhole);
        this.runTest(ExampleTwoMethodClass.class, fooMethod, 100000, 100, new Class[]{Integer.class, Date.class}, blackhole);
        barMethod = ExampleTwoMethodClass2.class.getMethod("bar", String.class);
        fooMethod = ExampleTwoMethodClass2.class.getMethod("foo", Integer.class, Date.class);
        this.runTest(ExampleTwoMethodClass2.class, barMethod, 100000, 100, new Class[]{String.class}, blackhole);
        this.runTest(ExampleTwoMethodClass2.class, fooMethod, 100000, 100, new Class[]{Integer.class, Date.class}, blackhole);
        barMethod = ExampleTwoMethodClass3.class.getMethod("bar", String.class);
        fooMethod = ExampleTwoMethodClass3.class.getMethod("foo", Integer.class, Date.class);
        this.runTest(ExampleTwoMethodClass3.class, barMethod, 100000, 100, new Class[]{String.class}, blackhole);
        this.runTest(ExampleTwoMethodClass3.class, fooMethod, 100000, 100, new Class[]{Integer.class, Date.class}, blackhole);
        barMethod = ExampleTwoMethodClass4.class.getMethod("bar", String.class);
        fooMethod = ExampleTwoMethodClass4.class.getMethod("foo", Integer.class, Date.class);
        this.runTest(ExampleTwoMethodClass4.class, barMethod, 100000, 100, new Class[]{String.class}, blackhole);
        this.runTest(ExampleTwoMethodClass4.class, fooMethod, 100000, 100, new Class[]{Integer.class, Date.class}, blackhole);
        barMethod = ExampleTwoMethodClass5.class.getMethod("bar", String.class);
        fooMethod = ExampleTwoMethodClass5.class.getMethod("foo", Integer.class, Date.class);
        this.runTest(ExampleTwoMethodClass5.class, barMethod, 100000, 100, new Class[]{String.class}, blackhole);
        this.runTest(ExampleTwoMethodClass5.class, fooMethod, 100000, 100, new Class[]{Integer.class, Date.class}, blackhole);
        barMethod = ExampleTwoMethodClass6.class.getMethod("bar", String.class);
        fooMethod = ExampleTwoMethodClass6.class.getMethod("foo", Integer.class, Date.class);
        this.runTest(ExampleTwoMethodClass6.class, barMethod, 100000, 100, new Class[]{String.class}, blackhole);
        this.runTest(ExampleTwoMethodClass6.class, fooMethod, 100000, 100, new Class[]{Integer.class, Date.class}, blackhole);
        barMethod = ExampleTwoMethodClass7.class.getMethod("bar", String.class);
        fooMethod = ExampleTwoMethodClass7.class.getMethod("foo", Integer.class, Date.class);
        this.runTest(ExampleTwoMethodClass7.class, barMethod, 100000, 100, new Class[]{String.class}, blackhole);
        this.runTest(ExampleTwoMethodClass7.class, fooMethod, 100000, 100, new Class[]{Integer.class, Date.class}, blackhole);
        barMethod = ExampleTwoMethodClass8.class.getMethod("bar", String.class);
        fooMethod = ExampleTwoMethodClass8.class.getMethod("foo", Integer.class, Date.class);
        this.runTest(ExampleTwoMethodClass8.class, barMethod, 100000, 100, new Class[]{String.class}, blackhole);
        this.runTest(ExampleTwoMethodClass8.class, fooMethod, 100000, 100, new Class[]{Integer.class, Date.class}, blackhole);
        barMethod = ExampleTwoMethodClass9.class.getMethod("bar", String.class);
        fooMethod = ExampleTwoMethodClass9.class.getMethod("foo", Integer.class, Date.class);
        this.runTest(ExampleTwoMethodClass9.class, barMethod, 100000, 100, new Class[]{String.class}, blackhole);
        this.runTest(ExampleTwoMethodClass9.class, fooMethod, 100000, 100, new Class[]{Integer.class, Date.class}, blackhole);
        barMethod = ExampleTwoMethodClass10.class.getMethod("bar", String.class);
        fooMethod = ExampleTwoMethodClass10.class.getMethod("foo", Integer.class, Date.class);
        this.runTest(ExampleTwoMethodClass10.class, barMethod, 100000, 100, new Class[]{String.class}, blackhole);
        this.runTest(ExampleTwoMethodClass10.class, fooMethod, 100000, 100, new Class[]{Integer.class, Date.class}, blackhole);
    }

    private static class Worker
    implements Callable<Class<?>[]> {
        private final Class<?> clazz;
        private final Method method;
        private final int invocationCount;

        public Worker(Class<?> clazz, Method method, int invocationCount) {
            this.clazz = clazz;
            this.method = method;
            this.invocationCount = invocationCount;
        }

        @Override
        public Class<?>[] call() {
            Class[] result = null;
            for (int i = this.invocationCount; i > 0; --i) {
                result = OgnlRuntime.findParameterTypes(this.clazz, (Method)this.method);
            }
            return result;
        }
    }

    static class ExampleStringClass
    extends GenericClass<String> {
        ExampleStringClass() {
        }

        public void foo(Integer parameter1, Date parameter2) {
        }
    }

    static class ExampleStringSubclass
    extends ExampleStringClass {
        ExampleStringSubclass() {
        }
    }

    static class ExampleTwoMethodClass {
        ExampleTwoMethodClass() {
        }

        public void foo(Integer parameter1, Date parameter2) {
        }

        public void bar(String parameter2) {
        }
    }

    static class ExampleTwoMethodClass2 {
        ExampleTwoMethodClass2() {
        }

        public void foo(Integer parameter1, Date parameter2) {
        }

        public void bar(String parameter2) {
        }
    }

    static class ExampleTwoMethodClass3 {
        ExampleTwoMethodClass3() {
        }

        public void foo(Integer parameter1, Date parameter2) {
        }

        public void bar(String parameter2) {
        }
    }

    static class ExampleTwoMethodClass4 {
        ExampleTwoMethodClass4() {
        }

        public void foo(Integer parameter1, Date parameter2) {
        }

        public void bar(String parameter2) {
        }
    }

    static class ExampleTwoMethodClass5 {
        ExampleTwoMethodClass5() {
        }

        public void foo(Integer parameter1, Date parameter2) {
        }

        public void bar(String parameter2) {
        }
    }

    static class ExampleTwoMethodClass6 {
        ExampleTwoMethodClass6() {
        }

        public void foo(Integer parameter1, Date parameter2) {
        }

        public void bar(String parameter2) {
        }
    }

    static class ExampleTwoMethodClass7 {
        ExampleTwoMethodClass7() {
        }

        public void foo(Integer parameter1, Date parameter2) {
        }

        public void bar(String parameter2) {
        }
    }

    static class ExampleTwoMethodClass8 {
        ExampleTwoMethodClass8() {
        }

        public void foo(Integer parameter1, Date parameter2) {
        }

        public void bar(String parameter2) {
        }
    }

    static class ExampleTwoMethodClass9 {
        ExampleTwoMethodClass9() {
        }

        public void foo(Integer parameter1, Date parameter2) {
        }

        public void bar(String parameter2) {
        }
    }

    static class ExampleTwoMethodClass10 {
        ExampleTwoMethodClass10() {
        }

        public void foo(Integer parameter1, Date parameter2) {
        }

        public void bar(String parameter2) {
        }
    }

    static class GenericClass<T> {
        GenericClass() {
        }

        public void bar(T parameter) {
        }
    }
}

