/*
 * Decompiled with CFR 0.152.
 */
package nz.net.ultraq.thymeleaf.decorator;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.dom.Text;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.attr.AbstractAttrProcessor;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.util.StringUtils;

public class TitlePatternProcessor
extends AbstractAttrProcessor {
    private static final Logger logger = LoggerFactory.getLogger(TitlePatternProcessor.class);
    private static final String PARAM_TITLE_DECORATOR = "$DECORATOR_TITLE";
    private static final String PARAM_TITLE_CONTENT = "$CONTENT_TITLE";
    public static final String PROCESSOR_NAME_TITLEPATTERN = "title-pattern";
    public static final String DECORATOR_TITLE = "title-pattern::decorator-title";
    public static final String CONTENT_TITLE = "title-pattern::content-title";

    public TitlePatternProcessor() {
        super(PROCESSOR_NAME_TITLEPATTERN);
    }

    public int getPrecedence() {
        return 1;
    }

    protected ProcessorResult processAttribute(Arguments arguments, Element element, String attributeName) {
        if (!element.getNormalizedName().equals("title")) {
            logger.error("layout:title-pattern attribute should only appear in a <title> element");
            throw new IllegalArgumentException("layout:title-pattern attribute should only appear in a <title> element");
        }
        Configuration configuration = arguments.getConfiguration();
        IStandardExpressionParser parser = StandardExpressions.getExpressionParser((Configuration)configuration);
        String decoratortitle = TitlePatternProcessor.processTitle((String)element.getNodeProperty(DECORATOR_TITLE), arguments, configuration, parser);
        String contenttitle = TitlePatternProcessor.processTitle((String)element.getNodeProperty(CONTENT_TITLE), arguments, configuration, parser);
        String titlepattern = element.getAttributeValue(attributeName);
        String title = decoratortitle != null ? (contenttitle != null ? titlepattern.replace(PARAM_TITLE_DECORATOR, decoratortitle).replace(PARAM_TITLE_CONTENT, contenttitle) : decoratortitle) : (contenttitle != null ? contenttitle : "");
        element.clearChildren();
        element.addChild((Node)new Text(title));
        element.removeAttribute(attributeName);
        return ProcessorResult.OK;
    }

    private static String processTitle(String title, Arguments arguments, Configuration configuration, IStandardExpressionParser parser) {
        String titlevalue;
        try {
            titlevalue = title == null ? null : parser.parseExpression(configuration, (IProcessingContext)arguments, title).execute(configuration, (IProcessingContext)arguments).toString();
        }
        catch (TemplateProcessingException ex) {
            titlevalue = title;
        }
        titlevalue = StringUtils.isEmptyOrWhitespace((String)titlevalue) ? null : titlevalue.trim();
        return titlevalue;
    }
}

