/*
 * Decompiled with CFR 0.152.
 */
package nz.net.ultraq.thymeleaf.decorator;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.dom.Text;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.attr.AbstractAttrProcessor;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;

public class TitlePatternProcessor
extends AbstractAttrProcessor {
    private static final Logger logger = LoggerFactory.getLogger(TitlePatternProcessor.class);
    private static final String PARAM_TITLE_DECORATOR = "$DECORATOR_TITLE";
    private static final String PARAM_TITLE_CONTENT = "$CONTENT_TITLE";
    public static final String PROCESSOR_NAME_TITLEPATTERN = "title-pattern";
    public static final String DECORATOR_TITLE = "title-pattern::decorator-title";
    public static final String CONTENT_TITLE = "title-pattern::content-title";

    public TitlePatternProcessor() {
        super(PROCESSOR_NAME_TITLEPATTERN);
    }

    public int getPrecedence() {
        return 1;
    }

    protected ProcessorResult processAttribute(Arguments arguments, Element element, String attributeName) {
        String contenttitlevalue;
        String decoratortitlevalue;
        if (!element.getNormalizedName().equals("title")) {
            logger.error("layout:title-pattern attribute should only appear in a <title> element");
            throw new IllegalArgumentException("layout:title-pattern attribute should only appear in a <title> element");
        }
        Configuration configuration = arguments.getConfiguration();
        IStandardExpressionParser parser = StandardExpressions.getExpressionParser((Configuration)configuration);
        String decoratortitle = (String)element.getNodeProperty(DECORATOR_TITLE);
        try {
            decoratortitlevalue = decoratortitle == null ? "" : parser.parseExpression(configuration, (IProcessingContext)arguments, decoratortitle).execute(configuration, (IProcessingContext)arguments).toString();
        }
        catch (TemplateProcessingException ex) {
            decoratortitlevalue = decoratortitle;
        }
        String contenttitle = (String)element.getNodeProperty(CONTENT_TITLE);
        try {
            contenttitlevalue = contenttitle == null ? "" : parser.parseExpression(configuration, (IProcessingContext)arguments, contenttitle).execute(configuration, (IProcessingContext)arguments).toString();
        }
        catch (TemplateProcessingException ex) {
            contenttitlevalue = contenttitle;
        }
        String titlepattern = element.getAttributeValue(attributeName);
        element.clearChildren();
        element.addChild((Node)new Text(titlepattern.replace(PARAM_TITLE_DECORATOR, decoratortitlevalue).replace(PARAM_TITLE_CONTENT, contenttitlevalue)));
        element.removeAttribute(attributeName);
        return ProcessorResult.OK;
    }
}

