package nz.co.nativemobile.cameramodule.helper

import android.graphics.Bitmap
import android.net.Uri
import android.os.Parcel
import android.os.Parcelable

data class BitmapMedia(var uri: Uri? = null,
                       var bitmap: Bitmap? = null) : Parcelable {
    constructor(source: Parcel) : this(
            source.readParcelable<Uri>(Uri::class.java.classLoader),
            source.readParcelable<Bitmap>(Bitmap::class.java.classLoader)
    )

    override fun describeContents() = 0

    override fun writeToParcel(dest: Parcel, flags: Int) = with(dest) {
        writeParcelable(uri, 0)
        writeParcelable(bitmap, 0)
    }

    companion object {
        @JvmField
        val CREATOR: Parcelable.Creator<BitmapMedia> = object : Parcelable.Creator<BitmapMedia> {
            override fun createFromParcel(source: Parcel): BitmapMedia = BitmapMedia(source)
            override fun newArray(size: Int): Array<BitmapMedia?> = arrayOfNulls(size)
        }
    }
}