package nz.co.nativemobile.cameramodule.extensions

import android.graphics.Bitmap
import java.io.ByteArrayOutputStream

/**
 * This extension method on Bitmap converts a bitmap to a [ByteArray]
 *
 * @param bitmapQuality the amount of compression to be applied
 * @return [ByteArray]
 */
fun Bitmap.convertToByteArray(bitmapQuality: Int): ByteArray {
    val byteArrayOutputStream = ByteArrayOutputStream()
    this.compress(Bitmap.CompressFormat.JPEG, bitmapQuality, byteArrayOutputStream)

    return byteArrayOutputStream.toByteArray()
}