/*
 * Decompiled with CFR 0.152.
 */
package nz.co.electricbolt.propertylistserialization.internal;

import android.util.Base64;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import nz.co.electricbolt.propertylistserialization.internal.DateUtil;

public class XMLPropertyListWriter {
    private Object obj;
    private OutputStream os;

    public XMLPropertyListWriter(Object obj, OutputStream os) {
        this.obj = obj;
        this.os = os;
    }

    public void write() throws IOException, IllegalStateException {
        this.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n<plist version=\"1.0\">\n", 0);
        this.writeObject(this.obj, 0);
        this.write("</plist>\n", 0);
    }

    private void writeObject(Object obj, int indent) throws IOException, IllegalStateException {
        if (obj == null) {
            throw new IllegalStateException("Object cannot be null");
        }
        if (obj instanceof Map) {
            Map dict = (Map)obj;
            if (dict.size() == 0) {
                this.write("<dict/>\n", indent);
            } else {
                this.write("<dict>\n", indent);
                TreeMap sortedDict = new TreeMap(dict);
                for (Object key : sortedDict.keySet()) {
                    this.write("<key>" + this.escape((String)key) + "</key>\n", indent + 1);
                    Object value = sortedDict.get(key);
                    this.writeObject(value, indent + 1);
                }
                this.write("</dict>\n", indent);
            }
        } else if (obj instanceof List) {
            List list = (List)obj;
            if (list.size() == 0) {
                this.write("<array/>\n", indent);
            } else {
                this.write("<array>\n", indent);
                for (int i = 0; i < list.size(); ++i) {
                    Object value = list.get(i);
                    this.writeObject(value, indent + 1);
                }
                this.write("</array>\n", indent);
            }
        } else if (obj instanceof String) {
            String value = (String)obj;
            value = this.escape(value);
            this.write("<string>" + value + "</string>\n", indent);
        } else if (obj instanceof Float) {
            Float value = (Float)obj;
            String s = Float.toString(value.floatValue());
            if (s.endsWith(".0")) {
                s = s.substring(0, s.length() - 2);
            }
            this.write("<real>" + s + "</real>\n", indent);
        } else if (obj instanceof Double) {
            Double value = (Double)obj;
            String s = Double.toString(value);
            if (s.endsWith(".0")) {
                s = s.substring(0, s.length() - 2);
            }
            this.write("<real>" + s + "</real>\n", indent);
        } else if (obj instanceof Integer) {
            Integer value = (Integer)obj;
            this.write("<integer>" + value + "</integer>\n", indent);
        } else if (obj instanceof Long) {
            Long value = (Long)obj;
            this.write("<integer>" + value + "</integer>\n", indent);
        } else if (obj instanceof byte[]) {
            this.writeData((byte[])obj, indent);
        } else if (obj instanceof Date) {
            Date value = (Date)obj;
            this.write("<date>" + DateUtil.formatXML(value) + "</date>\n", indent);
        } else if (obj instanceof Boolean) {
            Boolean value = (Boolean)obj;
            if (value.booleanValue()) {
                this.write("<true/>\n", indent);
            } else {
                this.write("<false/>\n", indent);
            }
        } else {
            throw new IllegalStateException("Incompatible object " + obj + " found");
        }
    }

    private String escape(String s) {
        StringBuilder sb = new StringBuilder();
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block5;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block5;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private byte[] tab(int indent) {
        byte[] buf = new byte[indent];
        Arrays.fill(buf, (byte)9);
        return buf;
    }

    private void write(String s, int indent) throws IOException {
        this.os.write(this.tab(indent > 8 ? 8 : indent));
        this.os.write(s.getBytes("utf8"));
    }

    private void writeData(byte[] value, int indent) throws IOException {
        if (indent > 8) {
            indent = 8;
        }
        int lineLength = 76 - indent * 8;
        byte[] tabBuf = this.tab(indent);
        byte[] encodedBuf = Base64.encode((byte[])value, (int)2);
        this.os.write(tabBuf);
        this.os.write("<data>\n".getBytes("utf8"));
        int i = 0;
        for (int l = 0; l < encodedBuf.length / lineLength; ++l) {
            this.os.write(tabBuf);
            this.os.write(encodedBuf, i, lineLength);
            this.os.write(10);
            i += lineLength;
        }
        if (i < encodedBuf.length) {
            this.os.write(tabBuf);
            this.os.write(encodedBuf, i, encodedBuf.length - i);
            this.os.write(10);
        }
        this.os.write(tabBuf);
        this.os.write("</data>\n".getBytes("utf8"));
    }
}

