/*
 * Decompiled with CFR 0.152.
 */
package nz.co.electricbolt.propertylistserialization.internal;

import android.util.Base64;
import android.util.Xml;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import nz.co.electricbolt.propertylistserialization.internal.DateUtil;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XMLPropertyListReader {
    private InputStream is;
    private XmlPullParser parser;

    public XMLPropertyListReader(InputStream is) {
        this.is = is;
        this.parser = Xml.newPullParser();
    }

    public Object parse() throws XmlPullParserException, IOException, ParseException {
        try {
            this.parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
            this.parser.setInput(this.is, null);
            this.parser.nextTag();
            Object object = this.readPlist();
            return object;
        }
        finally {
            this.is.close();
        }
    }

    private Object readPlist() throws XmlPullParserException, IOException, ParseException {
        this.parser.require(2, null, "plist");
        this.parser.nextTag();
        if (this.parser.getEventType() != 2) {
            throw new XmlPullParserException("START_TAG expected", this.parser, null);
        }
        String name = this.parser.getName();
        Object value = this.readObject(name);
        this.parser.nextTag();
        this.parser.require(3, null, "plist");
        return value;
    }

    private HashMap<String, Object> readDict() throws XmlPullParserException, IOException, ParseException {
        this.parser.nextTag();
        HashMap<String, Object> dict = new HashMap<String, Object>();
        while (this.parser.getEventType() != 3) {
            this.parser.require(2, null, "key");
            this.parser.next();
            if (this.parser.getEventType() != 4) {
                throw new XmlPullParserException("TEXT expected", this.parser, null);
            }
            String key = this.parser.getText();
            this.parser.nextTag();
            this.parser.require(3, null, "key");
            this.parser.nextTag();
            if (this.parser.getEventType() != 2) {
                throw new XmlPullParserException("START_TAG expected", this.parser, null);
            }
            String name = this.parser.getName();
            dict.put(key, this.readObject(name));
            this.parser.nextTag();
        }
        return dict;
    }

    private ArrayList readArray() throws XmlPullParserException, IOException, ParseException {
        this.parser.nextTag();
        ArrayList<Object> list = new ArrayList<Object>();
        while (this.parser.getEventType() != 3) {
            if (this.parser.getEventType() != 2) {
                throw new XmlPullParserException("START_TAG expected", this.parser, null);
            }
            String name = this.parser.getName();
            list.add(this.readObject(name));
            this.parser.nextTag();
        }
        return list;
    }

    private Object readObject(String tagName) throws ParseException, XmlPullParserException, IOException {
        switch (tagName) {
            case "array": {
                return this.readArray();
            }
            case "dict": {
                return this.readDict();
            }
            case "string": {
                return this.readString("string");
            }
            case "data": {
                return Base64.decode((String)this.readString("data"), (int)0);
            }
            case "date": {
                return DateUtil.parseXML(this.readString("date"));
            }
            case "integer": {
                return Long.valueOf(this.readString("integer"));
            }
            case "real": {
                return Double.valueOf(this.readString("real"));
            }
            case "true": {
                this.parser.nextTag();
                this.parser.require(3, null, "true");
                return true;
            }
            case "false": {
                this.parser.nextTag();
                this.parser.require(3, null, "false");
                return false;
            }
        }
        throw new XmlPullParserException("unexpected tag " + tagName, this.parser, null);
    }

    private String readString(String tagName) throws XmlPullParserException, IOException {
        this.parser.next();
        if (this.parser.getEventType() == 3) {
            this.parser.require(3, null, tagName);
            return "";
        }
        if (this.parser.getEventType() != 4) {
            throw new XmlPullParserException("TEXT expected", this.parser, null);
        }
        String result = this.parser.getText();
        this.parser.nextTag();
        this.parser.require(3, null, tagName);
        return result;
    }
}

