/*
 * Decompiled with CFR 0.152.
 */
package nz.co.electricbolt.propertylistserialization.internal;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtil {
    private static ThreadLocal<SimpleDateFormat> plistDateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            return df;
        }
    };

    private static Date parse(String s) throws ParseException {
        return plistDateFormat.get().parse(s);
    }

    public static Date parseBinary(double d) throws ParseException {
        Date binaryPlistEpoch = DateUtil.parse("2001-01-01T00:00:00Z");
        return new Date(binaryPlistEpoch.getTime() + (long)(d * 1000.0));
    }

    public static Date parseXML(String s) throws ParseException {
        return plistDateFormat.get().parse(s);
    }

    public static String formatXML(Date d) {
        return plistDateFormat.get().format(d);
    }

    public static double formatBinary(Date d) throws ParseException {
        Date binaryPlistEpoch = DateUtil.parse("2001-01-01T00:00:00Z");
        return (double)(d.getTime() - binaryPlistEpoch.getTime()) / 1000.0;
    }
}

