/*
 * Decompiled with CFR 0.152.
 */
package nz.co.electricbolt.propertylistserialization.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nz.co.electricbolt.propertylistserialization.internal.DateUtil;

public class BinaryPropertyListWriter {
    private Object rootObj;
    private Map<Object, Integer> objectIdMap;
    private byte objectRefSize;
    private ByteArrayOutputStream os;
    private CharsetEncoder asciiEncoder;
    private CharsetEncoder utf16Encoder;

    public BinaryPropertyListWriter(Object rootObj) {
        this.rootObj = rootObj;
        this.objectIdMap = new LinkedHashMap<Object, Integer>();
        this.os = new ByteArrayOutputStream();
        this.asciiEncoder = Charset.forName("ascii").newEncoder();
        this.utf16Encoder = Charset.forName("utf-16be").newEncoder();
    }

    public byte[] write() throws IOException, IllegalStateException, ParseException {
        this.os.write("bplist00".getBytes());
        this.mapObject(this.rootObj);
        this.objectRefSize = this.objectIdMap.size() < 256 ? (byte)1 : (this.objectIdMap.size() < 65536 ? (byte)2 : (byte)4);
        int[] offsetTable = new int[this.objectIdMap.size()];
        for (Map.Entry<Object, Integer> entry : this.objectIdMap.entrySet()) {
            Object obj = entry.getKey();
            offsetTable[entry.getValue().intValue()] = this.os.size();
            if (obj instanceof Map) {
                Map.Entry e;
                Map dict = (Map)obj;
                this.writeLength(13, dict.size());
                Set de = dict.entrySet();
                Iterator iterator = de.iterator();
                while (iterator.hasNext()) {
                    e = iterator.next();
                    this.writeLong(this.objectIdMap.get(e.getKey()).intValue(), this.objectRefSize);
                }
                iterator = de.iterator();
                while (iterator.hasNext()) {
                    e = iterator.next();
                    this.writeLong(this.objectIdMap.get(e.getValue()).intValue(), this.objectRefSize);
                }
                continue;
            }
            if (obj instanceof List) {
                List array = (List)obj;
                this.writeLength(10, array.size());
                for (Object value : array) {
                    this.writeLong(this.objectIdMap.get(value).intValue(), this.objectRefSize);
                }
                continue;
            }
            if (obj instanceof String) {
                int intType;
                ByteBuffer byteBuf;
                CharBuffer charBuf = CharBuffer.wrap((String)obj);
                if (this.asciiEncoder.canEncode((CharSequence)charBuf)) {
                    this.asciiEncoder.reset();
                    byteBuf = this.asciiEncoder.encode(charBuf);
                    intType = 5;
                } else {
                    this.utf16Encoder.reset();
                    byteBuf = this.utf16Encoder.encode(charBuf);
                    intType = 6;
                }
                byte[] buf = new byte[byteBuf.remaining()];
                byteBuf.get(buf);
                this.writeLength(intType, ((String)obj).length());
                this.os.write(buf);
                continue;
            }
            if (obj instanceof Float) {
                this.os.write(34);
                this.writeLong(Float.floatToRawIntBits(((Float)obj).floatValue()), 4);
                continue;
            }
            if (obj instanceof Double) {
                this.os.write(35);
                this.writeLong(Double.doubleToRawLongBits((Double)obj), 8);
                continue;
            }
            if (obj instanceof Integer || obj instanceof Long) {
                long value = obj instanceof Integer ? (long)((Integer)obj).intValue() : (Long)obj;
                if (value < 0L) {
                    this.os.write(19);
                    this.writeLong(value, 8);
                    continue;
                }
                if (value < 256L) {
                    this.os.write(16);
                    this.writeLong(value, 1);
                    continue;
                }
                if (value < 65536L) {
                    this.os.write(17);
                    this.writeLong(value, 2);
                    continue;
                }
                if (value < 0x100000000L) {
                    this.os.write(18);
                    this.writeLong(value, 4);
                    continue;
                }
                this.os.write(19);
                this.writeLong(value, 8);
                continue;
            }
            if (obj instanceof Date) {
                this.os.write(51);
                double value = DateUtil.formatBinary((Date)obj);
                this.writeLong(Double.doubleToRawLongBits(value), 8);
                continue;
            }
            if (obj instanceof Boolean) {
                if (!((Boolean)obj).booleanValue()) {
                    this.os.write(8);
                    continue;
                }
                this.os.write(9);
                continue;
            }
            if (!(obj instanceof byte[])) continue;
            byte[] buf = (byte[])obj;
            this.writeLength(4, buf.length);
            this.os.write(buf);
        }
        long offsetTableOffset = this.os.size();
        int offsetIntSize = 4;
        if (this.os.size() < 256) {
            offsetIntSize = 1;
        } else if (this.os.size() < 65536) {
            offsetIntSize = 2;
        }
        for (int offset : offsetTable) {
            this.writeLong(offset, offsetIntSize);
        }
        this.os.write(new byte[6]);
        this.os.write(offsetIntSize);
        this.os.write(this.objectRefSize);
        this.writeLong(this.objectIdMap.size(), 8);
        this.writeLong(this.objectIdMap.get(this.rootObj).intValue(), 8);
        this.writeLong(offsetTableOffset, 8);
        this.os.flush();
        return this.os.toByteArray();
    }

    private void mapObject(Object obj) {
        if (!this.objectIdMap.containsKey(obj)) {
            this.objectIdMap.put(obj, this.objectIdMap.size());
        }
        if (obj instanceof Map) {
            Map dict = (Map)obj;
            Set de = dict.entrySet();
            for (Map.Entry e : de) {
                this.mapObject(e.getKey());
            }
            for (Map.Entry e : de) {
                this.mapObject(e.getValue());
            }
        } else if (obj instanceof List) {
            List list = (List)obj;
            for (int i = 0; i < list.size(); ++i) {
                this.mapObject(list.get(i));
            }
        } else if (!(obj instanceof String || obj instanceof Float || obj instanceof Double || obj instanceof Integer || obj instanceof Long || obj instanceof byte[] || obj instanceof Date || obj instanceof Boolean)) {
            throw new IllegalStateException("Incompatible object " + obj + " found");
        }
    }

    private void writeLong(long value, int length) throws IOException {
        for (int i = length - 1; i >= 0; --i) {
            this.os.write((int)(value >> 8 * i));
        }
    }

    private void writeLength(int intType, int length) throws IOException {
        if (length < 15) {
            this.os.write((intType << 4) + length);
        } else if (length < 256) {
            this.os.write((intType << 4) + 15);
            this.os.write(16);
            this.writeLong(length, 1);
        } else if (length < 65536) {
            this.os.write((intType << 4) + 15);
            this.os.write(17);
            this.writeLong(length, 2);
        } else {
            this.os.write((intType << 4) + 15);
            this.os.write(18);
            this.writeLong(length, 4);
        }
    }
}

