/*
 * Decompiled with CFR 0.152.
 */
package nz.co.electricbolt.propertylistserialization.internal;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import nz.co.electricbolt.propertylistserialization.internal.DateUtil;

public class BinaryPropertyListReader {
    private byte objectRefSize;
    private int[] offsetTable;
    private byte[] buf;

    public BinaryPropertyListReader(byte[] buf) {
        this.buf = buf;
    }

    public Object parse() throws IOException, UnsupportedOperationException, ParseException {
        if (!new String(this.buf, 0, 8).equals("bplist00")) {
            throw new UnsupportedOperationException("File is not binary plist or supported version");
        }
        byte offsetIntSize = this.readByte(this.buf.length - 32 + 6);
        this.objectRefSize = this.readByte(this.buf.length - 32 + 7);
        int numObjects = (int)this.readLong(this.buf.length - 32 + 8);
        int rootObjectId = (int)this.readLong(this.buf.length - 32 + 16);
        int offsetTableOffset = (int)this.readLong(this.buf.length - 32 + 24);
        this.offsetTable = new int[numObjects];
        for (int i = 0; i < numObjects; ++i) {
            this.offsetTable[i] = (int)this.readLong(offsetIntSize * i + offsetTableOffset, offsetIntSize);
        }
        return this.readObject(rootObjectId);
    }

    private Object readObject(int objectId) throws UnsupportedOperationException, UnsupportedEncodingException, ParseException {
        int offset = this.offsetTable[objectId];
        int objectType = (this.buf[offset] & 0xF0) >> 4;
        int objectInfo = this.buf[offset] & 0xF;
        switch (objectType) {
            case 0: {
                switch (objectInfo) {
                    case 8: {
                        return false;
                    }
                    case 9: {
                        return true;
                    }
                }
                throw new UnsupportedOperationException("Unsupported objectInfo " + objectInfo);
            }
            case 1: {
                return this.readLong(offset + 1, (int)Math.pow(2.0, objectInfo));
            }
            case 2: {
                int size = (int)Math.pow(2.0, objectInfo);
                if (size == 4) {
                    return Float.valueOf(Float.intBitsToFloat((int)this.readLong(offset + 1, 4)));
                }
                if (size == 8) {
                    return Double.longBitsToDouble(this.readLong(offset + 1, 8));
                }
                throw new UnsupportedOperationException("Unsupported real size");
            }
            case 3: {
                if (objectInfo != 3) {
                    throw new UnsupportedOperationException("Unsupported date format" + objectInfo);
                }
                double millisSinceEpoch = Double.longBitsToDouble(this.readLong(offset + 1, 8));
                return DateUtil.parseBinary(millisSinceEpoch);
            }
            case 4: {
                LengthOffset lo = this.readLengthOffset(offset, objectInfo);
                byte[] data = new byte[lo.length];
                System.arraycopy(this.buf, lo.offset, data, 0, lo.length);
                return data;
            }
            case 5: {
                LengthOffset lo = this.readLengthOffset(offset, objectInfo);
                return new String(this.buf, lo.offset, lo.length, "ascii");
            }
            case 6: {
                LengthOffset lo = this.readLengthOffset(offset, objectInfo);
                return new String(this.buf, lo.offset, lo.length * 2, "utf-16be");
            }
            case 10: {
                LengthOffset lo = this.readLengthOffset(offset, objectInfo);
                ArrayList<Object> array = new ArrayList<Object>();
                for (int i = 0; i < lo.length; ++i) {
                    int arrayObjectId = (int)this.readLong(lo.offset + i * this.objectRefSize, this.objectRefSize);
                    array.add(this.readObject(arrayObjectId));
                }
                return array;
            }
            case 13: {
                LengthOffset lo = this.readLengthOffset(offset, objectInfo);
                HashMap<String, Object> dict = new HashMap<String, Object>();
                for (int i = 0; i < lo.length; ++i) {
                    int keyObjectId = (int)this.readLong(lo.offset + i * this.objectRefSize, this.objectRefSize);
                    int valueObjectId = (int)this.readLong(lo.offset + i * this.objectRefSize + lo.length * this.objectRefSize, this.objectRefSize);
                    dict.put((String)this.readObject(keyObjectId), this.readObject(valueObjectId));
                }
                return dict;
            }
        }
        throw new UnsupportedOperationException("Unsupported plist objectType " + objectType);
    }

    private byte readByte(int offset) {
        return (byte)this.readLong(offset, 1);
    }

    private long readLong(int offset) {
        return this.readLong(offset, 8);
    }

    private long readLong(int offset, int length) {
        long value = 0L;
        for (int i = 0; i < length; ++i) {
            value <<= 8;
            value |= (long)(this.buf[offset + i] & 0xFF);
        }
        return value;
    }

    private LengthOffset readLengthOffset(int offset, int objectInfo) {
        LengthOffset result = new LengthOffset();
        if (objectInfo == 15) {
            int intType = (this.buf[offset + 1] & 0xF0) >> 4;
            int intInfo = this.buf[offset + 1] & 0xF;
            int size = (int)Math.pow(2.0, intInfo);
            result.offset = offset + 2 + size;
            result.length = (int)this.readLong(offset + 2, size);
        } else {
            result.offset = offset + 1;
            result.length = objectInfo;
        }
        return result;
    }

    private static class LengthOffset {
        int length;
        int offset;

        private LengthOffset() {
        }
    }
}

