/*
 * Decompiled with CFR 0.152.
 */
package nz.co.electricbolt.propertylistserialization;

import android.support.annotation.NonNull;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import nz.co.electricbolt.propertylistserialization.PropertyListReadStreamException;
import nz.co.electricbolt.propertylistserialization.PropertyListWriteStreamException;
import nz.co.electricbolt.propertylistserialization.internal.BinaryPropertyListReader;
import nz.co.electricbolt.propertylistserialization.internal.BinaryPropertyListWriter;
import nz.co.electricbolt.propertylistserialization.internal.XMLPropertyListReader;
import nz.co.electricbolt.propertylistserialization.internal.XMLPropertyListWriter;
import org.xmlpull.v1.XmlPullParserException;

public class PropertyListSerialization {
    @NonNull
    public static byte[] dataWithPropertyList(@NonNull Object obj, Format format) throws PropertyListWriteStreamException {
        if (format == Format.Binary) {
            try {
                BinaryPropertyListWriter p = new BinaryPropertyListWriter(obj);
                return p.write();
            }
            catch (ParseException pe) {
                throw new PropertyListWriteStreamException(pe);
            }
            catch (IOException ioe) {
                throw new PropertyListWriteStreamException(ioe);
            }
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PropertyListSerialization.writePropertyList(obj, os, format);
        return os.toByteArray();
    }

    public static void writePropertyList(@NonNull Object obj, @NonNull OutputStream os, Format format) throws PropertyListWriteStreamException {
        if (format == Format.XML) {
            try {
                XMLPropertyListWriter p = new XMLPropertyListWriter(obj, os);
                p.write();
            }
            catch (NullPointerException npe) {
                throw new PropertyListWriteStreamException(npe);
            }
            catch (IllegalStateException ise) {
                throw new PropertyListWriteStreamException(ise);
            }
            catch (IOException ioe) {
                throw new PropertyListWriteStreamException(ioe);
            }
        }
        try {
            os.write(PropertyListSerialization.dataWithPropertyList(obj, Format.Binary));
        }
        catch (IOException ioe) {
            throw new PropertyListWriteStreamException(ioe);
        }
    }

    @NonNull
    public static Object propertyListWithData(@NonNull byte[] data, Format format) throws PropertyListReadStreamException {
        if (format == Format.Binary) {
            try {
                BinaryPropertyListReader p = new BinaryPropertyListReader(data);
                return p.parse();
            }
            catch (UnsupportedOperationException uoe) {
                throw new PropertyListReadStreamException(uoe);
            }
            catch (ParseException pe) {
                throw new PropertyListReadStreamException(pe);
            }
            catch (IOException ioe) {
                throw new PropertyListReadStreamException(ioe);
            }
        }
        return PropertyListSerialization.propertyListWithData(new ByteArrayInputStream(data), format);
    }

    @NonNull
    public static Object propertyListWithData(@NonNull InputStream is, Format format) throws PropertyListReadStreamException {
        if (format == Format.XML) {
            try {
                XMLPropertyListReader p = new XMLPropertyListReader(is);
                return p.parse();
            }
            catch (ParseException pe) {
                throw new PropertyListReadStreamException(pe);
            }
            catch (IOException ioe) {
                throw new PropertyListReadStreamException(ioe);
            }
            catch (XmlPullParserException xppe) {
                throw new PropertyListReadStreamException((Exception)((Object)xppe));
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int read;
            byte[] buf = new byte[1024];
            while ((read = is.read(buf, 0, 1024)) != -1) {
                baos.write(buf, 0, read);
            }
            baos.flush();
            return PropertyListSerialization.propertyListWithData(baos.toByteArray(), Format.Binary);
        }
        catch (IOException ioe) {
            throw new PropertyListReadStreamException(ioe);
        }
    }

    public static enum Format {
        XML,
        Binary;

    }
}

