/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.EventSetDescriptor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import weka.core.Instance;
import weka.core.Instances;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSource;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.InstanceListener;
import weka.gui.beans.KFStep;
import weka.gui.beans.Visible;

@KFStep(category="Tools", toolTipText="Converts an incoming instance stream into a data set batch")
public class InstanceStreamToBatchMaker
extends JPanel
implements BeanCommon,
Visible,
InstanceListener,
EventConstraints,
DataSource {
    private static final long serialVersionUID = -7037141087208627799L;
    protected BeanVisual m_visual = new BeanVisual("InstanceStreamToBatchMaker", "weka/gui/beans/icons/InstanceStreamToBatchMaker.gif", "weka/gui/beans/icons/InstanceStreamToBatchMaker_animated.gif");
    private transient Logger m_log;
    private Object m_listenee;
    private ArrayList<DataSourceListener> m_dataListeners = new ArrayList();
    private List<Instance> m_batch;
    private Instances m_structure;

    public InstanceStreamToBatchMaker() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    @Override
    public void acceptInstance(InstanceEvent e) {
        if (e.getStatus() == 0) {
            this.m_batch = new LinkedList<Instance>();
            this.m_structure = e.getStructure();
            if (this.m_log != null) {
                this.m_log.logMessage("[InstanceStreamToBatch] passing on structure.");
            }
            DataSetEvent dse = new DataSetEvent(this, this.m_structure);
            this.notifyDataListeners(dse);
        } else if (e.getStatus() == 1) {
            this.m_batch.add(e.getInstance());
        } else {
            if (e.getInstance() != null) {
                this.m_batch.add(e.getInstance());
            }
            Instances dataSet = new Instances(this.m_structure, this.m_batch.size());
            for (Instance i : this.m_batch) {
                dataSet.add(i);
            }
            dataSet.compactify();
            this.m_batch = null;
            if (this.m_log != null) {
                this.m_log.logMessage("[InstanceStreamToBatch] sending batch to listeners.");
            }
            DataSetEvent dse = new DataSetEvent(this, dataSet);
            this.notifyDataListeners(dse);
        }
    }

    @Override
    public boolean connectionAllowed(EventSetDescriptor esd) {
        return this.connectionAllowed(esd.getName());
    }

    @Override
    public boolean connectionAllowed(String eventName) {
        return this.m_listenee == null && eventName.equals("instance");
    }

    @Override
    public void connectionNotification(String eventName, Object source) {
        if (this.connectionAllowed(eventName)) {
            this.m_listenee = source;
        }
    }

    @Override
    public void disconnectionNotification(String eventName, Object source) {
        this.m_listenee = null;
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        if (!eventName.equals("dataSet")) {
            return false;
        }
        if (this.m_listenee == null) {
            return false;
        }
        return !(this.m_listenee instanceof EventConstraints) || ((EventConstraints)this.m_listenee).eventGeneratable("instance");
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public void setLog(Logger logger) {
        this.m_log = logger;
    }

    @Override
    public boolean isBusy() {
        return false;
    }

    @Override
    public void stop() {
    }

    @Override
    public BeanVisual getVisual() {
        return this.m_visual;
    }

    @Override
    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    @Override
    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/InstanceStreamToBatchMaker.gif", "weka/gui/beans/icons/InstanceStreamToBatchMaker_animated.gif");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyDataListeners(DataSetEvent tse) {
        ArrayList l;
        InstanceStreamToBatchMaker instanceStreamToBatchMaker = this;
        synchronized (instanceStreamToBatchMaker) {
            l = (ArrayList)this.m_dataListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((DataSourceListener)l.get(i)).acceptDataSet(tse);
            }
        }
    }

    @Override
    public synchronized void addDataSourceListener(DataSourceListener tsl) {
        this.m_dataListeners.add(tsl);
        if (this.m_structure != null) {
            DataSetEvent e = new DataSetEvent(this, this.m_structure);
            tsl.acceptDataSet(e);
        }
    }

    @Override
    public synchronized void removeDataSourceListener(DataSourceListener tsl) {
        this.m_dataListeners.remove(tsl);
    }

    @Override
    public synchronized void addInstanceListener(InstanceListener il) {
    }

    @Override
    public synchronized void removeInstanceListener(InstanceListener il) {
    }
}

