/*
 * Decompiled with CFR 0.152.
 */
package weka.core.tokenizers;

import java.util.NoSuchElementException;
import weka.core.RevisionUtils;
import weka.core.tokenizers.Tokenizer;

public class AlphabeticTokenizer
extends Tokenizer {
    private static final long serialVersionUID = 6705199562609861697L;
    protected char[] m_Str;
    protected int m_CurrentPos;

    @Override
    public String globalInfo() {
        return "Alphabetic string tokenizer, tokens are to be formed only from contiguous alphabetic sequences.";
    }

    @Override
    public boolean hasMoreElements() {
        int beginpos;
        for (beginpos = this.m_CurrentPos; !(beginpos >= this.m_Str.length || this.m_Str[beginpos] >= 'a' && this.m_Str[beginpos] <= 'z' || this.m_Str[beginpos] >= 'A' && this.m_Str[beginpos] <= 'Z'); ++beginpos) {
        }
        this.m_CurrentPos = beginpos;
        return beginpos < this.m_Str.length && (this.m_Str[beginpos] >= 'a' && this.m_Str[beginpos] <= 'z' || this.m_Str[beginpos] >= 'A' && this.m_Str[beginpos] <= 'Z');
    }

    @Override
    public Object nextElement() {
        int endpos;
        int beginpos;
        for (beginpos = this.m_CurrentPos; beginpos < this.m_Str.length && this.m_Str[beginpos] < 'a' && this.m_Str[beginpos] > 'z' && this.m_Str[beginpos] < 'A' && this.m_Str[beginpos] > 'Z'; ++beginpos) {
        }
        this.m_CurrentPos = endpos = beginpos;
        if (beginpos >= this.m_Str.length) {
            throw new NoSuchElementException("No more tokens present");
        }
        while (endpos < this.m_Str.length && (this.m_Str[endpos] >= 'a' && this.m_Str[endpos] <= 'z' || this.m_Str[endpos] >= 'A' && this.m_Str[endpos] <= 'Z')) {
            ++endpos;
        }
        String s = new String(this.m_Str, beginpos, endpos - this.m_CurrentPos);
        this.m_CurrentPos = endpos;
        return s;
    }

    @Override
    public void tokenize(String s) {
        this.m_CurrentPos = 0;
        this.m_Str = new char[s.length()];
        s.getChars(0, s.length(), this.m_Str, 0);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) {
        AlphabeticTokenizer.runTokenizer(new AlphabeticTokenizer(), args);
    }
}

