/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;

public class ItemSet
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = 2724000045282835791L;
    protected int[] m_items;
    protected int m_counter;
    protected int m_totalTransactions;
    protected boolean m_treatZeroAsMissing = false;

    public ItemSet(int totalTrans) {
        this.m_totalTransactions = totalTrans;
    }

    public ItemSet(int totalTrans, int[] array) {
        this.m_totalTransactions = totalTrans;
        this.m_items = array;
        this.m_counter = 1;
    }

    public ItemSet(int[] array) {
        this.m_items = array;
        this.m_counter = 0;
    }

    public boolean containedBy(Instance instance) {
        if (instance instanceof SparseInstance && this.m_treatZeroAsMissing) {
            int numInstVals = instance.numValues();
            int numItemSetVals = this.m_items.length;
            int p1 = 0;
            int p2 = 0;
            while (p1 < numInstVals || p2 < numItemSetVals) {
                int itemIndex;
                int instIndex = Integer.MAX_VALUE;
                if (p1 < numInstVals) {
                    instIndex = instance.index(p1);
                }
                if (this.m_items[itemIndex = p2++] > -1) {
                    if (itemIndex != instIndex) {
                        return false;
                    }
                    if (instance.isMissingSparse(p1)) {
                        return false;
                    }
                    if (this.m_items[itemIndex] != (int)instance.valueSparse(p1)) {
                        return false;
                    }
                    ++p1;
                    continue;
                }
                if (itemIndex < instIndex) {
                    ++p2;
                    continue;
                }
                if (itemIndex != instIndex) continue;
                ++p2;
                ++p1;
            }
        } else {
            for (int i = 0; i < instance.numAttributes(); ++i) {
                if (this.m_items[i] <= -1) continue;
                if (instance.isMissing(i) || this.m_treatZeroAsMissing && (int)instance.value(i) == 0) {
                    return false;
                }
                if (this.m_items[i] == (int)instance.value(i)) continue;
                return false;
            }
        }
        return true;
    }

    public static FastVector deleteItemSets(FastVector itemSets, int minSupport, int maxSupport) {
        FastVector<ItemSet> newVector = new FastVector<ItemSet>(itemSets.size());
        for (int i = 0; i < itemSets.size(); ++i) {
            ItemSet current = (ItemSet)itemSets.elementAt(i);
            if (current.m_counter < minSupport || current.m_counter > maxSupport) continue;
            newVector.addElement(current);
        }
        return newVector;
    }

    public boolean equals(Object itemSet) {
        if (itemSet == null || !itemSet.getClass().equals(this.getClass())) {
            return false;
        }
        if (this.m_items.length != ((ItemSet)itemSet).m_items.length) {
            return false;
        }
        for (int i = 0; i < this.m_items.length; ++i) {
            if (this.m_items[i] == ((ItemSet)itemSet).m_items[i]) continue;
            return false;
        }
        return true;
    }

    public static Hashtable getHashtable(FastVector itemSets, int initialSize) {
        Hashtable<ItemSet, Integer> hashtable = new Hashtable<ItemSet, Integer>(initialSize);
        for (int i = 0; i < itemSets.size(); ++i) {
            ItemSet current = (ItemSet)itemSets.elementAt(i);
            hashtable.put(current, new Integer(current.m_counter));
        }
        return hashtable;
    }

    public int hashCode() {
        long result = 0L;
        for (int i = this.m_items.length - 1; i >= 0; --i) {
            result += (long)(i * this.m_items[i]);
        }
        return (int)result;
    }

    public static FastVector mergeAllItemSets(FastVector itemSets, int size, int totalTrans) {
        FastVector<ItemSet> newVector = new FastVector<ItemSet>();
        block0: for (int i = 0; i < itemSets.size(); ++i) {
            ItemSet first = (ItemSet)itemSets.elementAt(i);
            for (int j = i + 1; j < itemSets.size(); ++j) {
                ItemSet second = (ItemSet)itemSets.elementAt(j);
                ItemSet result = new ItemSet(totalTrans);
                result.m_items = new int[first.m_items.length];
                int numFound = 0;
                int k = 0;
                while (numFound < size) {
                    if (first.m_items[k] != second.m_items[k]) continue block0;
                    if (first.m_items[k] != -1) {
                        ++numFound;
                    }
                    result.m_items[k] = first.m_items[k];
                    ++k;
                }
                while (k < first.m_items.length && (first.m_items[k] == -1 || second.m_items[k] == -1)) {
                    result.m_items[k] = first.m_items[k] != -1 ? first.m_items[k] : second.m_items[k];
                    ++k;
                }
                if (k != first.m_items.length) continue;
                result.m_counter = 0;
                newVector.addElement(result);
            }
        }
        return newVector;
    }

    public static FastVector pruneItemSets(FastVector toPrune, Hashtable kMinusOne) {
        FastVector<ItemSet> newVector = new FastVector<ItemSet>(toPrune.size());
        for (int i = 0; i < toPrune.size(); ++i) {
            int j;
            ItemSet current = (ItemSet)toPrune.elementAt(i);
            for (j = 0; j < current.m_items.length; ++j) {
                if (current.m_items[j] == -1) continue;
                int help = current.m_items[j];
                current.m_items[j] = -1;
                if (kMinusOne.get(current) == null) {
                    current.m_items[j] = help;
                    break;
                }
                current.m_items[j] = help;
            }
            if (j != current.m_items.length) continue;
            newVector.addElement(current);
        }
        return newVector;
    }

    public static void pruneRules(FastVector[] rules, double minConfidence) {
        FastVector newPremises = new FastVector(rules[0].size());
        FastVector newConsequences = new FastVector(rules[1].size());
        FastVector newConf = new FastVector(rules[2].size());
        FastVector newLift = null;
        FastVector newLev = null;
        FastVector newConv = null;
        if (rules.length > 3) {
            newLift = new FastVector(rules[3].size());
            newLev = new FastVector(rules[4].size());
            newConv = new FastVector(rules[5].size());
        }
        for (int i = 0; i < rules[0].size(); ++i) {
            if ((Double)rules[2].elementAt(i) < minConfidence) continue;
            newPremises.addElement(rules[0].elementAt(i));
            newConsequences.addElement(rules[1].elementAt(i));
            newConf.addElement(rules[2].elementAt(i));
            if (rules.length <= 3) continue;
            newLift.addElement(rules[3].elementAt(i));
            newLev.addElement(rules[4].elementAt(i));
            newConv.addElement(rules[5].elementAt(i));
        }
        rules[0] = newPremises;
        rules[1] = newConsequences;
        rules[2] = newConf;
        if (rules.length > 3) {
            rules[3] = newLift;
            rules[4] = newLev;
            rules[5] = newConv;
        }
    }

    public static FastVector singletons(Instances instances) throws Exception {
        FastVector<ItemSet> setOfItemSets = new FastVector<ItemSet>();
        for (int i = 0; i < instances.numAttributes(); ++i) {
            if (instances.attribute(i).isNumeric()) {
                throw new Exception("Can't handle numeric attributes!");
            }
            int j = 0;
            while (j < instances.attribute(i).numValues()) {
                ItemSet current = new ItemSet(instances.numInstances());
                current.m_items = new int[instances.numAttributes()];
                for (int k = 0; k < instances.numAttributes(); ++k) {
                    current.m_items[k] = -1;
                }
                current.m_items[i] = j++;
                setOfItemSets.addElement(current);
            }
        }
        return setOfItemSets;
    }

    public int support() {
        return this.m_counter;
    }

    public String toString(Instances instances) {
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < instances.numAttributes(); ++i) {
            if (this.m_items[i] == -1) continue;
            text.append(instances.attribute(i).name() + '=');
            text.append(instances.attribute(i).value(this.m_items[i]) + ' ');
        }
        text.append(this.m_counter);
        return text.toString();
    }

    public void upDateCounter(Instance instance) {
        if (this.containedBy(instance)) {
            ++this.m_counter;
        }
    }

    public static void upDateCounters(FastVector itemSets, Instances instances) {
        for (int i = 0; i < instances.numInstances(); ++i) {
            Enumeration enu = itemSets.elements();
            while (enu.hasMoreElements()) {
                ((ItemSet)enu.nextElement()).upDateCounter(instances.instance(i));
            }
        }
    }

    public int counter() {
        return this.m_counter;
    }

    public int[] items() {
        return this.m_items;
    }

    public int itemAt(int k) {
        return this.m_items[k];
    }

    public void setCounter(int count) {
        this.m_counter = count;
    }

    public void setItem(int[] items) {
        this.m_items = items;
    }

    public void setItemAt(int value, int k) {
        this.m_items[k] = value;
    }

    public void setTreatZeroAsMissing(boolean z) {
        this.m_treatZeroAsMissing = z;
    }

    public boolean getTreatZeroAsMissing() {
        return this.m_treatZeroAsMissing;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

