/*
 * Decompiled with CFR 0.152.
 */
package nu.studer.gradle.jooq.util;

import groovy.lang.Closure;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.gradle.api.GradleException;

public final class Objects {
    private static final MessageDigest MESSAGE_DIGEST;

    public static void applyClosureToDelegate(Closure<?> closure, Object delegate) {
        Closure copy = (Closure)closure.clone();
        copy.setResolveStrategy(1);
        copy.setDelegate(delegate);
        if (copy.getMaximumNumberOfParameters() == 0) {
            copy.call();
        } else {
            copy.call(delegate);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T cloneObject(T obj) {
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        try (ObjectOutputStream os = new ObjectOutputStream(bas);){
            os.writeObject(obj);
            os.flush();
        }
        catch (IOException e) {
            throw new GradleException("Cannot serialize object: " + obj.getClass(), (Throwable)e);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bas.toByteArray());
        try (ObjectInputStream is = new ObjectInputStream(bis);){
            Object clone;
            Object object = clone = is.readObject();
            return (T)object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new GradleException("Cannot deserialize object: " + obj.getClass(), (Throwable)e);
        }
    }

    public static String deepHash(Object obj) {
        try {
            byte[] encodedHash;
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            try (ObjectOutputStream os = new ObjectOutputStream(bas);){
                os.writeObject(obj);
                os.flush();
            }
            catch (IOException e) {
                throw new GradleException("Cannot serialize object: " + obj.getClass(), (Throwable)e);
            }
            StringBuilder hexString = new StringBuilder();
            for (byte hash : encodedHash = MESSAGE_DIGEST.digest(bas.toByteArray())) {
                String hex = Integer.toHexString(0xFF & hash);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (GradleException e) {
            throw new RuntimeException(e);
        }
    }

    private Objects() {
    }

    static {
        try {
            MESSAGE_DIGEST = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

