/*
 * Decompiled with CFR 0.152.
 */
package nu.studer.gradle.jooq;

import javax.inject.Inject;
import nu.studer.gradle.jooq.JooqConfig;
import nu.studer.gradle.jooq.JooqEdition;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;

public class JooqExtension {
    private static final String DEFAULT_VERSION = "3.16.4";
    private static final JooqEdition DEFAULT_EDITION = JooqEdition.OSS;
    private final Property<String> version;
    private final Property<JooqEdition> edition;
    private final NamedDomainObjectContainer<JooqConfig> configurations;

    @Inject
    public JooqExtension(ObjectFactory objects) {
        this.version = objects.property(String.class).convention((Object)DEFAULT_VERSION);
        this.edition = objects.property(JooqEdition.class).convention((Object)DEFAULT_EDITION);
        this.configurations = objects.domainObjectContainer(JooqConfig.class, name -> (JooqConfig)objects.newInstance(JooqConfig.class, new Object[]{name}));
        this.version.finalizeValueOnRead();
        this.edition.finalizeValueOnRead();
    }

    public Property<String> getVersion() {
        return this.version;
    }

    public Property<JooqEdition> getEdition() {
        return this.edition;
    }

    public NamedDomainObjectContainer<JooqConfig> getConfigurations() {
        return this.configurations;
    }
}

