/*
 * Decompiled with CFR 0.152.
 */
package nu.studer.gradle.jooq;

import groovy.lang.Closure;
import javax.inject.Inject;
import nu.studer.gradle.jooq.jaxb.JaxbConfigurationBridge;
import nu.studer.gradle.jooq.util.Objects;
import org.gradle.api.file.Directory;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.jooq.meta.jaxb.Configuration;
import org.jooq.meta.jaxb.Database;
import org.jooq.meta.jaxb.Generate;
import org.jooq.meta.jaxb.Generator;
import org.jooq.meta.jaxb.Jdbc;
import org.jooq.meta.jaxb.Strategy;
import org.jooq.meta.jaxb.Target;

public class JooqConfig {
    final String name;
    private final Configuration jooqConfiguration;
    private final Property<Boolean> generateSchemaSourceOnCompilation;
    private final Provider<Directory> outputDir;

    @Inject
    public JooqConfig(String name, ObjectFactory objects, ProviderFactory providers, ProjectLayout layout) {
        this.name = name;
        this.jooqConfiguration = this.jooqDefaultConfiguration();
        this.generateSchemaSourceOnCompilation = objects.property(Boolean.class).convention((Object)true);
        this.outputDir = layout.getProjectDirectory().dir(providers.provider(() -> this.jooqConfiguration.getGenerator().getTarget().getDirectory())).orElse(layout.getBuildDirectory().dir("generated-src/jooq/" + name));
    }

    private Configuration jooqDefaultConfiguration() {
        return new Configuration().withJdbc(new Jdbc()).withGenerator(new Generator().withStrategy(new Strategy()).withDatabase(new Database()).withGenerate(new Generate()).withTarget(new Target().withDirectory(null)));
    }

    public Configuration getJooqConfiguration() {
        return this.jooqConfiguration;
    }

    public Property<Boolean> getGenerateSchemaSourceOnCompilation() {
        return this.generateSchemaSourceOnCompilation;
    }

    public Provider<Directory> getOutputDir() {
        return this.outputDir;
    }

    public void generationTool(Closure<?> closure) {
        JaxbConfigurationBridge delegate = new JaxbConfigurationBridge(this.jooqConfiguration, String.format("jooq.%s.generationTool", this.name));
        Objects.applyClosureToDelegate(closure, delegate);
    }
}

