/*
 * Decompiled with CFR 0.152.
 */
package nu.studer.gradle.jooq.util;

import groovy.lang.Closure;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.gradle.api.GradleException;

public final class Objects {
    public static void applyClosureToDelegate(Closure<?> closure, Object delegate) {
        Closure copy = (Closure)closure.clone();
        copy.setResolveStrategy(1);
        copy.setDelegate(delegate);
        if (copy.getMaximumNumberOfParameters() == 0) {
            copy.call();
        } else {
            copy.call(delegate);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T cloneObject(T obj) {
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        try (ObjectOutputStream os = new ObjectOutputStream(bas);){
            os.writeObject(obj);
            os.flush();
        }
        catch (IOException e) {
            throw new GradleException("Cannot serialize object: " + obj.getClass(), (Throwable)e);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bas.toByteArray());
        try (ObjectInputStream is = new ObjectInputStream(bis);){
            Object clone;
            Object object = clone = is.readObject();
            return (T)object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new GradleException("Cannot deserialize object: " + obj.getClass(), (Throwable)e);
        }
    }

    private Objects() {
    }
}

