/*
 * Decompiled with CFR 0.152.
 */
package nu.studer.gradle.credentials.domain;

import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import nu.studer.gradle.util.Base64;

public final class Encryption {
    private static final String UTF_8_CHARSET = "UTF8";
    private final Cipher ecipher;
    private final Cipher dcipher;

    public Encryption(Cipher ecipher, Cipher dcipher) throws GeneralSecurityException {
        this.ecipher = ecipher;
        this.dcipher = dcipher;
    }

    public String encrypt(String string) {
        try {
            byte[] utf8 = string.getBytes(UTF_8_CHARSET);
            byte[] enc = this.ecipher.doFinal(utf8);
            return Base64.encodeBase64(enc);
        }
        catch (Exception e) {
            throw new RuntimeException("Encryption failed: " + e.getMessage(), e);
        }
    }

    public String decrypt(String string) {
        try {
            byte[] dec = Base64.decodeBase64(string);
            byte[] utf8 = this.dcipher.doFinal(dec);
            return new String(utf8, UTF_8_CHARSET);
        }
        catch (Exception e) {
            throw new RuntimeException("Decryption failed: " + e.getMessage(), e);
        }
    }

    public static Encryption createEncryption(char[] passphrase) {
        try {
            return Encryption.createEncryptionThrowingException(passphrase);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Cannot create Encryption instance: " + e.getMessage(), e);
        }
    }

    private static Encryption createEncryptionThrowingException(char[] passphrase) throws GeneralSecurityException {
        byte[] salt = new byte[]{31, 19, -27, -78, 73, 44, -61, 60};
        int iterationCount = 65536;
        int keyLength = 128;
        PBEKeySpec pbeKeySpec = new PBEKeySpec(passphrase, salt, iterationCount, keyLength);
        SecretKeyFactory keyFac = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        SecretKey tmpKey = keyFac.generateSecret(pbeKeySpec);
        SecretKeySpec pbeKey = new SecretKeySpec(tmpKey.getEncoded(), "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        int blockSize = cipher.getBlockSize();
        byte[] iv = new byte[blockSize];
        for (int i = 0; i < iv.length; ++i) {
            iv[i] = (byte)i;
        }
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        Cipher pbeEcipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        pbeEcipher.init(1, (Key)pbeKey, ivSpec);
        Cipher pbeDcipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        pbeDcipher.init(2, (Key)pbeKey, ivSpec);
        return new Encryption(pbeEcipher, pbeDcipher);
    }
}

