/*
 * Decompiled with CFR 0.152.
 */
package nu.studer.gradle.credentials;

import java.io.File;
import java.util.function.Function;
import nu.studer.gradle.credentials.AddCredentialsTask;
import nu.studer.gradle.credentials.RemoveCredentialsTask;
import nu.studer.gradle.credentials.domain.CredentialsContainer;
import nu.studer.gradle.credentials.domain.CredentialsEncryptor;
import nu.studer.gradle.credentials.domain.CredentialsPersistenceManager;
import nu.studer.gradle.util.AlwaysFalseSpec;
import nu.studer.gradle.util.MD5;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialsPlugin
implements Plugin<ExtensionAware> {
    public static final String DEFAULT_PASSPHRASE_CREDENTIALS_FILE = "gradle.encrypted.properties";
    public static final String DEFAULT_PASSPHRASE = ">>Default passphrase to encrypt passwords!<<";
    public static final String CREDENTIALS_CONTAINER_PROPERTY = "credentials";
    public static final String CREDENTIALS_LOCATION_PROPERTY = "credentialsLocation";
    public static final String CREDENTIALS_PASSPHRASE_PROPERTY = "credentialsPassphrase";
    public static final String CREDENTIALS_KEY_PROPERTY = "credentialsKey";
    public static final String CREDENTIALS_VALUE_PROPERTY = "credentialsValue";
    public static final String ADD_CREDENTIALS_TASK_NAME = "addCredentials";
    public static final String REMOVE_CREDENTIALS_TASK_NAME = "removeCredentials";
    private static final Action<Pair> NOOP = p -> {};
    private static final Logger LOGGER = LoggerFactory.getLogger(CredentialsPlugin.class);

    public void apply(ExtensionAware extension) {
        if (GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"5.0")) < 0) {
            throw new IllegalStateException("This version of the credentials plugin is not compatible with Gradle < 5.0");
        }
        if (extension instanceof Settings) {
            Settings settings = (Settings)extension;
            this.init(settings.getGradle(), (ExtensionAware)settings, loc -> settings.getSettingsDir().toPath().resolve((String)loc).toFile(), NOOP);
        } else if (extension instanceof Project) {
            Project project = (Project)extension;
            this.init(project.getGradle(), (ExtensionAware)project, arg_0 -> ((Project)project).file(arg_0), (Action<Pair>)((Action)creds -> this.addTasks((Pair)creds, project.getTasks())));
        } else {
            throw new IllegalStateException("The credentials plugin can only be applied to Settings and Project instances");
        }
    }

    private void init(Gradle gradle, ExtensionAware extensionAware, Function<String, File> locationResolver, Action<Pair> customizations) {
        String passphrase = this.getStringProperty(CREDENTIALS_PASSPHRASE_PROPERTY, DEFAULT_PASSPHRASE, extensionAware);
        String credentialsFileName = this.deriveFileNameFromPassphrase(passphrase);
        CredentialsEncryptor credentialsEncryptor = CredentialsEncryptor.withPassphrase(passphrase.toCharArray());
        String credentialsLocation = this.getStringProperty(CREDENTIALS_LOCATION_PROPERTY, null, extensionAware);
        File credentialsLocationDir = credentialsLocation != null ? locationResolver.apply(credentialsLocation) : gradle.getGradleUserHomeDir();
        File credentialsFile = new File(credentialsLocationDir, credentialsFileName);
        CredentialsPersistenceManager credentialsPersistenceManager = new CredentialsPersistenceManager(credentialsFile);
        CredentialsContainer credentialsContainer = new CredentialsContainer(credentialsEncryptor, credentialsPersistenceManager.readCredentials());
        this.setProperty(CREDENTIALS_CONTAINER_PROPERTY, credentialsContainer, extensionAware);
        LOGGER.debug("Registered property 'credentials'");
        customizations.execute((Object)new Pair(credentialsEncryptor, credentialsPersistenceManager));
    }

    private String getStringProperty(String key, String defaultValue, ExtensionAware extensionAware) {
        ExtraPropertiesExtension properties = extensionAware.getExtensions().getExtraProperties();
        return properties.has(key) ? (String)properties.get(key) : defaultValue;
    }

    private void setProperty(String key, Object value, ExtensionAware extensionAware) {
        ExtraPropertiesExtension properties = extensionAware.getExtensions().getExtraProperties();
        properties.set(key, value);
    }

    private void addTasks(Pair result, TaskContainer tasks) {
        CredentialsEncryptor credentialsEncryptor = result.credentialsEncryptor;
        CredentialsPersistenceManager credentialsPersistenceManager = result.credentialsPersistenceManager;
        AddCredentialsTask addCredentials = (AddCredentialsTask)tasks.create(ADD_CREDENTIALS_TASK_NAME, AddCredentialsTask.class);
        addCredentials.setDescription("Adds the credentials specified through the project properties 'credentialsKey' and 'credentialsValue'.");
        addCredentials.setGroup("Credentials");
        addCredentials.setCredentialsEncryptor(credentialsEncryptor);
        addCredentials.setCredentialsPersistenceManager(credentialsPersistenceManager);
        addCredentials.getOutputs().upToDateWhen((Spec)AlwaysFalseSpec.INSTANCE);
        LOGGER.debug(String.format("Registered task '%s'", addCredentials.getName()));
        RemoveCredentialsTask removeCredentials = (RemoveCredentialsTask)tasks.create(REMOVE_CREDENTIALS_TASK_NAME, RemoveCredentialsTask.class);
        removeCredentials.setDescription("Removes the credentials specified through the project property 'credentialsKey'.");
        removeCredentials.setGroup("Credentials");
        removeCredentials.setCredentialsPersistenceManager(credentialsPersistenceManager);
        removeCredentials.getOutputs().upToDateWhen((Spec)AlwaysFalseSpec.INSTANCE);
        LOGGER.debug(String.format("Registered task '%s'", removeCredentials.getName()));
    }

    private String deriveFileNameFromPassphrase(String passphrase) {
        String credentialsFileName;
        if (passphrase.equals(DEFAULT_PASSPHRASE)) {
            credentialsFileName = DEFAULT_PASSPHRASE_CREDENTIALS_FILE;
            LOGGER.debug("No explicit passphrase provided. Using default credentials file name: " + credentialsFileName);
        } else {
            credentialsFileName = "gradle." + MD5.generateMD5Hash(passphrase) + ".encrypted.properties";
            LOGGER.debug("Custom passphrase provided. Using credentials file name: " + credentialsFileName);
        }
        return credentialsFileName;
    }

    private static final class Pair {
        private final CredentialsEncryptor credentialsEncryptor;
        private final CredentialsPersistenceManager credentialsPersistenceManager;

        private Pair(CredentialsEncryptor credentialsEncryptor, CredentialsPersistenceManager credentialsPersistenceManager) {
            this.credentialsEncryptor = credentialsEncryptor;
            this.credentialsPersistenceManager = credentialsPersistenceManager;
        }
    }
}

