/*
 * Decompiled with CFR 0.152.
 */
package nu.studer.gradle.credentials;

import java.io.File;
import java.io.IOException;
import nu.studer.gradle.credentials.domain.CredentialsPersistenceManager;
import nu.studer.java.util.OrderedProperties;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveCredentialsTask
extends DefaultTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoveCredentialsTask.class);
    private CredentialsPersistenceManager credentialsPersistenceManager;

    public void setCredentialsPersistenceManager(CredentialsPersistenceManager credentialsPersistenceManager) {
        this.credentialsPersistenceManager = credentialsPersistenceManager;
    }

    @Input
    public String getCredentialsKey() {
        return this.getProjectProperty("credentialsKey");
    }

    @OutputFile
    public File getEncryptedPropertiesFile() {
        return this.credentialsPersistenceManager.getCredentialsFile();
    }

    @TaskAction
    void removeCredentials() throws IOException {
        String key = this.getCredentialsKey();
        LOGGER.debug(String.format("Remove credentials with key: '%s'", key));
        OrderedProperties credentials = this.credentialsPersistenceManager.readCredentials();
        credentials.removeProperty(key);
        this.credentialsPersistenceManager.storeCredentials(credentials);
    }

    private String getProjectProperty(String key) {
        return (String)this.getProject().getProperties().get(key);
    }
}

