/*
 * Decompiled with CFR 0.152.
 */
package nu.annat.beholder.presenter;

import android.os.Bundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import nu.annat.beholder.BeholderAdapter;
import nu.annat.beholder.presenter.ComponentInfo;

public class ComponentPresenter
implements ComponentInfo {
    private final ComponentInfo base;
    private final List<ComponentInfo> children = new ArrayList<ComponentInfo>();
    private BeholderAdapter<?> childAdapter;

    public ComponentPresenter() {
        this.base = this;
    }

    public ComponentPresenter(ComponentInfo impersonate) {
        this.base = impersonate;
    }

    @Override
    public int layoutHash() {
        return this.base.getClass().getCanonicalName().hashCode();
    }

    @Override
    public int deepLayoutHash() {
        int hash = this.layoutHash();
        if (!this.children.isEmpty()) {
            for (ComponentInfo childComponentInfo : this.children) {
                hash = 31 * hash + childComponentInfo.deepLayoutHash();
            }
        }
        return hash;
    }

    @Override
    public List<ComponentInfo> getChildren() {
        return this.children;
    }

    @Override
    public void add(ComponentInfo component) {
        this.children.add(component);
    }

    @Override
    public void addAll(Collection<ComponentInfo> components) {
        this.children.addAll(components);
    }

    @Override
    public ComponentInfo get(int index) {
        return this.children.get(index);
    }

    @Override
    public int size() {
        return this.children.size();
    }

    @Override
    public Iterator<ComponentInfo> iterator() {
        return this.children.iterator();
    }

    @Override
    public long itemId() {
        return -1L;
    }

    @Override
    public void saveStates(Bundle extras) {
    }

    @Override
    public void restoreStates(Bundle extras) {
    }

    @Override
    public BeholderAdapter<?> getChildAdapter() {
        return this.childAdapter;
    }

    @Override
    public void setChildAdapter(BeholderAdapter<?> adapter) {
        this.childAdapter = adapter;
    }
}

