/*
 * Decompiled with CFR 0.152.
 */
package nu.annat.beholder;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.databinding.DataBindingUtil;
import androidx.databinding.ViewDataBinding;
import androidx.lifecycle.LifecycleOwner;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import nu.annat.beholder.BeholderAdapter;
import nu.annat.beholder.ComponentAdapterGroup;
import nu.annat.beholder.ComponentGroup;
import nu.annat.beholder.ComponentGroupViewHolder;
import nu.annat.beholder.ComponentViewHolder;
import nu.annat.beholder.Stats;
import nu.annat.beholder.ViewInformation;
import nu.annat.beholder.action.ActionHandler;
import nu.annat.beholder.presenter.ComponentData;
import nu.annat.beholder.presenter.ComponentInfo;

public class ComponentFactory {
    private static final String TAG = ComponentFactory.class.getSimpleName();
    public static boolean loggingEnabled = false;
    protected Map<Class<? extends ComponentInfo>, Component> components = new HashMap<Class<? extends ComponentInfo>, Component>();
    private List<WeakReference<ComponentViewHolder>> activeComponents = new LinkedList<WeakReference<ComponentViewHolder>>();

    public static Bundle saveStates(List<ComponentInfo> componentInfos, Bundle bundle) {
        ComponentFactory.saveStates("", bundle, bundle, componentInfos);
        return bundle;
    }

    private static void saveStates(String prefix, Bundle root, Bundle savedComponents, List<ComponentInfo> componentInfos) {
        int index = 0;
        for (ComponentInfo componentInfo : componentInfos) {
            String uniqueId = prefix + ":" + String.valueOf(componentInfo.layoutHash()) + ":" + index;
            Bundle bundle = new Bundle();
            componentInfo.saveStates(bundle);
            savedComponents.putBundle(uniqueId, bundle);
            ComponentFactory.saveStates(uniqueId, root, bundle, componentInfo.getChildren());
            ++index;
        }
    }

    public static void restoreStates(Bundle bundle, List<ComponentInfo> componentInfos) {
        ComponentFactory.restoreStates("", bundle, bundle, componentInfos);
    }

    private static void restoreStates(String prefix, Bundle root, Bundle bundle, List<ComponentInfo> componentInfos) {
        int index = 0;
        for (ComponentInfo componentInfo : componentInfos) {
            String uniqueId = prefix + ":" + String.valueOf(componentInfo.layoutHash()) + ":" + index;
            Bundle objectBundle = bundle.getBundle(uniqueId);
            if (objectBundle != null) {
                componentInfo.restoreStates(objectBundle);
                ComponentFactory.restoreStates(uniqueId, root, objectBundle, componentInfo.getChildren());
            }
            ++index;
        }
    }

    public static void print(List<ComponentInfo> ComponentInfoList) {
        ComponentFactory.print(ComponentInfoList, 0);
    }

    private static void print(List<ComponentInfo> ComponentInfoList, int level) {
        String s = "";
        for (int i = 0; i < level; ++i) {
            s = s + "    ";
        }
        for (ComponentInfo componentInfo : ComponentInfoList) {
            System.out.println(level + s + componentInfo.getClass().getSimpleName());
            if (!(componentInfo instanceof ComponentInfo)) continue;
            ComponentFactory.print(componentInfo.getChildren(), level + 1);
        }
    }

    public ComponentFactory() {
    }

    public ComponentFactory(Component ... components) {
        this();
        this.registerComponents(components);
    }

    public ComponentFactory(Collection<Component> components) {
        this();
        this.registerComponents(components);
    }

    public void registerComponent(Component component) {
        this.components.put(component.presenter, component);
    }

    public void registerComponents(Component ... components) {
        this.registerComponents(Arrays.asList(components));
    }

    public void registerComponents(Collection<Component> components) {
        for (Component ComponentInfo2 : components) {
            this.registerComponent(ComponentInfo2);
        }
    }

    public <T extends ComponentViewHolder> T createDeep(int depth, int order, Class<? extends ComponentInfo> presenterClass, @NonNull ComponentInfo componentInfo, ViewGroup root, LifecycleOwner lifecycleOwner, boolean force, boolean bindPresenter, ActionHandler actionHandler) {
        Stats deepLayoutStats = Stats.start("Create Deep " + componentInfo.getClass().getSimpleName() + ", with deep id " + componentInfo.deepLayoutHash());
        T holder = this.createView(depth, order, presenterClass, componentInfo, root, lifecycleOwner, actionHandler);
        if (!componentInfo.getChildren().isEmpty()) {
            if (holder instanceof ComponentGroup) {
                ComponentGroup componentGroup = (ComponentGroup)holder;
                int childOrder = 0;
                ++depth;
                for (ComponentInfo component : componentInfo.getChildren()) {
                    T deep = this.createDeep(depth, childOrder++, component.getClass(), component, componentGroup.getChildArea(), lifecycleOwner, force, bindPresenter, actionHandler);
                    componentGroup.addChild((ComponentViewHolder)((Object)deep));
                }
            } else if (holder instanceof ComponentAdapterGroup) {
                ComponentAdapterGroup componentGroup = (ComponentAdapterGroup)holder;
                componentInfo.setChildAdapter(new BeholderAdapter<ComponentInfo>(this, ++depth, componentInfo.getChildren(), actionHandler, lifecycleOwner, componentGroup.hasStableIds()));
            }
        }
        if (bindPresenter) {
            ((ComponentViewHolder)((Object)holder)).setData((ComponentInfo)componentInfo, force);
        }
        if (loggingEnabled) {
            Log.v((String)TAG, (String)deepLayoutStats.stop());
        }
        return holder;
    }

    protected <T extends ComponentViewHolder> T createView(int depth, int order, Class<? extends ComponentInfo> presenterClass, ComponentInfo componentInfo, ViewGroup root, LifecycleOwner lifecycleOwner, ActionHandler actionHandler) {
        Stats createViewStats = Stats.start("Create View " + componentInfo.getClass().getSimpleName());
        Component it = this.getIt(presenterClass);
        int layoutId = componentInfo.layoutHash();
        int reuseId = componentInfo.deepLayoutHash();
        if (it == null) {
            throw new RuntimeException(presenterClass.getName() + " is not registered as a component");
        }
        LayoutInflater inflater = LayoutInflater.from((Context)root.getContext());
        ViewDataBinding inflate = DataBindingUtil.inflate((LayoutInflater)inflater, (int)it.layout, (ViewGroup)root, (boolean)false);
        if (inflate == null) {
            throw new RuntimeException("Can't inflate view for " + presenterClass.getName());
        }
        ViewInformation viewInformation = new ViewInformation(depth, order);
        Stats createViewHolderStats = Stats.start();
        ComponentData componentData = new ComponentData(viewInformation, inflate, lifecycleOwner, actionHandler, layoutId, reuseId);
        Object componentViewHolder = it.vhc.create(componentData);
        if (loggingEnabled) {
            Log.v((String)TAG, (String)createViewHolderStats.stop("Create Viewholder " + componentViewHolder.getClass().getSimpleName()));
        }
        if (loggingEnabled) {
            Log.v((String)TAG, (String)createViewStats.stop());
        }
        return componentViewHolder;
    }

    public List<ComponentViewHolder> getActiveComponents() {
        this.compactActiveList();
        ArrayList<ComponentViewHolder> active = new ArrayList<ComponentViewHolder>();
        for (WeakReference<ComponentViewHolder> activeComponent : this.activeComponents) {
            ComponentViewHolder componentViewHolder = (ComponentViewHolder)((Object)activeComponent.get());
            if (componentViewHolder == null) continue;
            active.add(componentViewHolder);
        }
        return active;
    }

    public void compactActiveList() {
        Iterator<WeakReference<ComponentViewHolder>> iterator = this.activeComponents.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().get() != null) continue;
            iterator.remove();
        }
    }

    public void update(ComponentViewHolder holder, boolean force) {
        ViewGroup vg = (ViewGroup)holder.itemView;
        if (holder instanceof ComponentGroupViewHolder) {
            ComponentGroupViewHolder groupViewHolder = (ComponentGroupViewHolder)holder;
            groupViewHolder.removeAll();
            ViewInformation viewInformation = groupViewHolder.getViewInformation();
            ActionHandler actionHandler = groupViewHolder.getActionHandler();
            Object presenter = groupViewHolder.getPresenter();
            ViewGroup parentVG = groupViewHolder.getChildArea();
            int depth = viewInformation.getDepth() + 1;
            int order = 0;
            for (ComponentInfo componentInfo : presenter) {
                groupViewHolder.addChild((ComponentViewHolder)((Object)this.createDeep(depth, order++, componentInfo.getClass(), componentInfo, parentVG, null, force, true, actionHandler)));
            }
        }
    }

    public void updateDeep(ComponentGroupViewHolder parent, ComponentViewHolder holder, ComponentInfo componentInfo, boolean force) {
        if (holder.getLayoutId() != componentInfo.layoutHash()) {
            if (loggingEnabled) {
                Log.v((String)TAG, (String)"ID missmatch, recreate");
            }
            ViewInformation viewInformation = holder.getViewInformation();
            parent.remove(holder);
            ViewGroup parentVG = (ViewGroup)parent.itemView;
            Object newHolder = this.createDeep(viewInformation.getDepth(), viewInformation.getOrder(), componentInfo.getClass(), componentInfo, parentVG, null, force, true, holder.getActionHandler());
            parent.addChild((ComponentViewHolder)((Object)newHolder));
        } else {
            if (loggingEnabled) {
                Log.v((String)TAG, (String)"ID match, update data");
            }
            holder.setData(componentInfo, force);
        }
        if (holder instanceof ComponentGroupViewHolder) {
            ComponentGroupViewHolder groupViewHolder = (ComponentGroupViewHolder)holder;
            ArrayList<ComponentViewHolder> arrayList = new ArrayList<ComponentViewHolder>(groupViewHolder.getChildren());
        }
    }

    public void bindDeep(ComponentViewHolder holder, ComponentInfo componentInfo, boolean force) {
        this.bindDeep(holder, 0, componentInfo, force);
    }

    public void bindDeep(ComponentViewHolder holder, int order, ComponentInfo componentInfo, boolean force) {
        if (holder.getReuseId() != componentInfo.deepLayoutHash()) {
            throw new RuntimeException(String.format(Locale.ROOT, "Component does not fit the layout, holder = %d, componentInfo = %d", holder.getLayoutId(), componentInfo.layoutHash()));
        }
        holder.setViewInformation(new ViewInformation(holder.viewInformation.getDepth(), order));
        holder.setData(componentInfo, force);
        if (componentInfo instanceof ComponentInfo && holder instanceof ComponentGroup) {
            ComponentGroup componentGroup = (ComponentGroup)((Object)holder);
            if (holder.getLayoutId() == componentInfo.layoutHash()) {
                List<ComponentViewHolder> children = componentGroup.getChildren();
                List<ComponentInfo> componentInfoList = componentInfo.getChildren();
                if (children != null) {
                    for (int i = 0; i < children.size(); ++i) {
                        this.bindDeep(children.get(i), componentInfoList.get(i), force);
                    }
                }
            }
        }
    }

    protected Component getIt(Class<? extends ComponentInfo> presenterClass) {
        return this.components.get(presenterClass);
    }

    public <T extends ComponentViewHolder> T create(ComponentInfo componentInfo, ViewGroup root, LifecycleOwner lifecycleOwner, ActionHandler actionHandler) {
        return this.createDeep(0, 0, componentInfo.getClass(), componentInfo, root, lifecycleOwner, false, true, actionHandler);
    }

    public <T extends ComponentViewHolder> T create(int order, ComponentInfo componentInfo, ViewGroup root, LifecycleOwner lifecycleOwner, ActionHandler actionHandler) {
        return this.createDeep(0, order, componentInfo.getClass(), componentInfo, root, lifecycleOwner, false, true, actionHandler);
    }

    public <T extends ComponentViewHolder> T createReusable(ComponentInfo componentInfo, ViewGroup root, LifecycleOwner lifecycleOwner, ActionHandler actionHandler) {
        return this.createDeep(0, 0, componentInfo.getClass(), componentInfo, root, lifecycleOwner, false, false, actionHandler);
    }

    public <T extends ComponentViewHolder> T createReusable(ComponentInfo componentInfo, int depth, ViewGroup root, LifecycleOwner lifecycleOwner, ActionHandler actionHandler) {
        return this.createDeep(depth, 0, componentInfo.getClass(), componentInfo, root, lifecycleOwner, false, false, actionHandler);
    }

    public <T extends ComponentViewHolder> T createReusable(Class<? extends ComponentInfo> presenterClass, ViewGroup root, LifecycleOwner lifecycleOwner, ActionHandler actionHandler) {
        return this.createDeep(0, 0, presenterClass, null, root, lifecycleOwner, false, false, actionHandler);
    }

    public Collection<Class<? extends ComponentInfo>> getRegisteredPresenters() {
        return this.components.keySet();
    }

    public static class Component<T extends ComponentViewHolder> {
        public ViewHolderConstructor<T> vhc;
        public int layout;
        public Class<? extends ComponentInfo> presenter;

        public Component(Class<? extends ComponentInfo> presenter, ViewHolderConstructor<T> viewHolderConstructor, int layout) {
            this.layout = layout;
            this.presenter = presenter;
            this.vhc = viewHolderConstructor;
        }
    }

    public static interface ViewHolderConstructor<T extends ComponentViewHolder> {
        public T create(ComponentData var1);
    }
}

