/*
 * Decompiled with CFR 0.152.
 */
package nu.annat.beholder.action;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import nu.annat.beholder.action.OnAction;

public class ActionHandler<ACTION> {
    private static final String TAG = ActionHandler.class.getSimpleName();
    private final Handler mainThreadHandler;
    private final ActionHandler<ACTION> delegate;
    protected Map<Class<? extends ACTION>, ActionInfo<? extends ACTION>> handlers = new HashMap<Class<? extends ACTION>, ActionInfo<? extends ACTION>>();

    public ActionHandler() {
        this(null);
    }

    public ActionHandler(ActionHandler<ACTION> delegate) {
        this.mainThreadHandler = new Handler(Looper.getMainLooper());
        this.delegate = delegate;
    }

    public <T extends ACTION> void register(Class<? extends T> actionClass, OnAction<T> onAction) {
        this.register(actionClass, onAction, false);
    }

    public <T extends ACTION> void register(Class<? extends T> actionClass, OnAction<T> onAction, boolean forceMainThread) {
        this.handlers.put(actionClass, new ActionInfo<T>(forceMainThread, onAction));
    }

    public void handle(final ACTION action) {
        final ActionInfo<? extends ACTION> actionInfo = this.handlers.get(action.getClass());
        if (actionInfo == null) {
            if (this.delegate != null) {
                this.delegate.handle(action);
            } else {
                Log.w((String)TAG, (String)("Action " + action.getClass().getName() + " is not registered"));
            }
        } else if (((ActionInfo)actionInfo).forceMainThread && !this.isOnMainThread()) {
            this.mainThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    actionInfo.onAction.execute(action);
                }
            });
        } else {
            ((ActionInfo)actionInfo).onAction.execute(action);
        }
    }

    private boolean isOnMainThread() {
        return Thread.currentThread() == Looper.getMainLooper().getThread();
    }

    private static class ActionInfo<ACTION> {
        private final boolean forceMainThread;
        private final OnAction<ACTION> onAction;

        public ActionInfo(boolean forceMainThread, OnAction<ACTION> onAction) {
            this.forceMainThread = forceMainThread;
            this.onAction = onAction;
        }
    }
}

