/*
 * Decompiled with CFR 0.152.
 */
package nu.annat.beholder;

import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.ViewGroup;
import java.util.List;
import nu.annat.beholder.ComponentFactory;
import nu.annat.beholder.ComponentViewHolder;
import nu.annat.beholder.action.ActionHandler;
import nu.annat.beholder.presenter.ComponentInfo;

public class BeholderAdapter<T extends ComponentInfo>
extends RecyclerView.Adapter<ComponentViewHolder> {
    private static final String TAG = BeholderAdapter.class.getSimpleName();
    protected final ActionHandler actionHandler;
    protected final List<T> data;
    protected ComponentFactory factory;
    protected SparseArray<ComponentInfo> cachedPresenters = new SparseArray();

    public BeholderAdapter(ComponentFactory factory, List<T> data, ActionHandler actionHandler) {
        this(factory, data, actionHandler, false);
    }

    public BeholderAdapter(ComponentFactory factory, List<T> data, ActionHandler actionHandler, boolean hasStableIds) {
        this.factory = factory;
        this.data = data;
        this.actionHandler = actionHandler;
        this.setHasStableIds(hasStableIds);
    }

    public ComponentViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return this.factory.createReusable((ComponentInfo)this.cachedPresenters.get(viewType), parent, this.actionHandler);
    }

    public int getItemViewType(int position) {
        ComponentInfo componentInfo = this.getItem(position);
        int deepLayoutHash = componentInfo.deepLayoutHash();
        this.cachedPresenters.put(deepLayoutHash, (Object)componentInfo);
        return deepLayoutHash;
    }

    public long getItemId(int position) {
        return ((ComponentInfo)this.data.get(position)).itemId();
    }

    protected ComponentInfo getItem(int position) {
        return (ComponentInfo)this.data.get(position);
    }

    public List<T> getData() {
        return this.data;
    }

    public void onBindViewHolder(ComponentViewHolder holder, int position) {
        this.factory.bindDeep(holder, position, this.getItem(position), true);
    }

    public void onViewAttachedToWindow(ComponentViewHolder holder) {
        super.onViewAttachedToWindow((RecyclerView.ViewHolder)holder);
        holder.attached();
    }

    public void onViewDetachedFromWindow(ComponentViewHolder holder) {
        super.onViewDetachedFromWindow((RecyclerView.ViewHolder)holder);
        holder.detached();
    }

    public int getItemCount() {
        return this.data == null ? 0 : this.data.size();
    }

    public void close() {
        this.factory = null;
    }
}

