/*
 * Decompiled with CFR 0.152.
 */
package nu.annat.beholder;

import android.databinding.ViewDataBinding;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import nu.annat.beholder.ViewInformation;
import nu.annat.beholder.action.ActionHandler;
import nu.annat.beholder.presenter.ComponentData;
import nu.annat.beholder.presenter.ComponentInfo;

public abstract class ComponentViewHolder<BINDING extends ViewDataBinding, PRESENTER extends ComponentInfo, ACTION>
extends RecyclerView.ViewHolder {
    protected final BINDING binding;
    protected final ActionHandler actionHandler;
    protected ViewInformation viewInformation;
    private final int layoutId;
    private final int reuseId;
    protected PRESENTER presenter;
    private boolean attached;

    private ComponentViewHolder(View view) {
        super(view);
        this.binding = null;
        this.actionHandler = null;
        this.layoutId = 0;
        this.reuseId = 0;
        this.viewInformation = null;
    }

    public ComponentViewHolder(ComponentData baseData) {
        super(baseData.binding.getRoot());
        this.layoutId = baseData.layoutId;
        this.actionHandler = baseData.actionHandler;
        this.reuseId = baseData.reuseId;
        this.binding = baseData.binding;
        this.viewInformation = baseData.viewInformation;
        this.prepareView();
    }

    public PRESENTER getPresenter() {
        return this.presenter;
    }

    public void setData(PRESENTER presenter, boolean force) {
        this.presenter = presenter;
        this.prepareData();
        if (force) {
            this.binding.executePendingBindings();
        }
    }

    protected void prepareView() {
    }

    protected void prepareData() {
    }

    public void setViewInformation(ViewInformation viewInformation) {
        this.viewInformation = viewInformation;
    }

    public int getLayoutId() {
        return this.layoutId;
    }

    public int getReuseId() {
        return this.reuseId;
    }

    public ViewInformation getViewInformation() {
        return this.viewInformation;
    }

    public ActionHandler getActionHandler() {
        return this.actionHandler;
    }

    protected void act(ACTION action) {
        if (this.actionHandler != null) {
            this.actionHandler.handle(action);
        }
    }

    void attached() {
        this.attached = true;
        this.onAttached();
    }

    protected void onAttached() {
    }

    void detached() {
        this.attached = false;
        this.onDetached();
    }

    protected void onDetached() {
    }

    public boolean isAttached() {
        return this.attached;
    }
}

