/*
 * Decompiled with CFR 0.152.
 */
package nu.annat.beholder;

import android.content.Context;
import android.databinding.DataBindingUtil;
import android.databinding.ViewDataBinding;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nu.annat.beholder.ComponentGroup;
import nu.annat.beholder.ComponentViewHolder;
import nu.annat.beholder.ViewInformation;
import nu.annat.beholder.action.ActionHandler;
import nu.annat.beholder.presenter.ComponentInfo;

public class ComponentFactory {
    private static final String TAG = ComponentFactory.class.getSimpleName();
    protected Map<Class<? extends ComponentInfo>, Component> components = new HashMap<Class<? extends ComponentInfo>, Component>();

    public static void print(List<ComponentInfo> ComponentInfoList) {
        ComponentFactory.print(ComponentInfoList, 0);
    }

    private static void print(List<ComponentInfo> ComponentInfoList, int level) {
        String s = "";
        for (int i = 0; i < level; ++i) {
            s = s + "    ";
        }
        for (ComponentInfo componentInfo : ComponentInfoList) {
            System.out.println(level + s + componentInfo.getClass().getSimpleName());
            if (!(componentInfo instanceof ComponentInfo)) continue;
            ComponentFactory.print(componentInfo.getChildren(), level + 1);
        }
    }

    public ComponentFactory() {
    }

    public ComponentFactory(Component ... components) {
        this();
        this.registerComponents(components);
    }

    public ComponentFactory(Collection<Component> components) {
        this();
        this.registerComponents(components);
    }

    public void registerComponent(Component component) {
        this.components.put(component.presenter, component);
    }

    public void registerComponents(Component ... components) {
        this.registerComponents(Arrays.asList(components));
    }

    public void registerComponents(Collection<Component> components) {
        for (Component ComponentInfo2 : components) {
            this.registerComponent(ComponentInfo2);
        }
    }

    public ComponentViewHolder createDeep(int depth, int order, Class<? extends ComponentInfo> presenterClass, ComponentInfo componentInfo, ViewGroup root, boolean force, boolean bind, ActionHandler actionHandler) {
        ComponentViewHolder holder = this.createView(depth, order, presenterClass, componentInfo, root, actionHandler);
        if (bind) {
            holder.setData(componentInfo, force);
        }
        if (!componentInfo.getChildren().isEmpty() && holder instanceof ComponentGroup) {
            ComponentGroup componentGroup = (ComponentGroup)((Object)holder);
            int childOrder = 0;
            ++depth;
            for (ComponentInfo component : componentInfo.getChildren()) {
                ComponentViewHolder deep = this.createDeep(depth, childOrder++, component.getClass(), component, componentGroup.getChildArea(), force, true, actionHandler);
                componentGroup.addChild(deep);
            }
        }
        return holder;
    }

    protected ComponentViewHolder createView(int depth, int order, Class<? extends ComponentInfo> presenterClass, ComponentInfo componentInfo, ViewGroup root, ActionHandler actionHandler) {
        Component it = this.getIt(presenterClass);
        int layoutId = componentInfo.layoutHash();
        int reuseId = componentInfo.deepLayoutHash();
        if (it == null) {
            throw new RuntimeException(presenterClass.getName() + " is not registered as a component");
        }
        LayoutInflater inflater = LayoutInflater.from((Context)root.getContext());
        ViewDataBinding inflate = DataBindingUtil.inflate((LayoutInflater)inflater, (int)it.layout, (ViewGroup)root, (boolean)false);
        if (inflate == null) {
            throw new RuntimeException("Can't inflate view for " + presenterClass.getName());
        }
        ViewInformation viewInformation = new ViewInformation(depth, order);
        try {
            Constructor<? extends ComponentViewHolder> constructor = it.viewHolder.getConstructor(ViewInformation.class, ViewDataBinding.class, ActionHandler.class, Integer.TYPE, Integer.TYPE);
            return constructor.newInstance(new Object[]{viewInformation, inflate, actionHandler, layoutId, reuseId});
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void bindDeep(ComponentViewHolder holder, ComponentInfo componentInfo, boolean force) {
        if (holder.getReuseId() != componentInfo.deepLayoutHash()) {
            throw new RuntimeException(String.format("Component does not fit the layout, holder = %d, componentInfo = %d", holder.getLayoutId(), componentInfo.layoutHash()));
        }
        holder.setData(componentInfo, force);
        if (componentInfo instanceof ComponentInfo && holder instanceof ComponentGroup) {
            ComponentGroup componentGroup = (ComponentGroup)((Object)holder);
            if (holder.getLayoutId() == componentInfo.layoutHash()) {
                List<ComponentViewHolder> children = componentGroup.getChildren();
                List<ComponentInfo> componentInfoList = componentInfo.getChildren();
                if (children != null) {
                    for (int i = 0; i < children.size(); ++i) {
                        this.bindDeep(children.get(i), componentInfoList.get(i), force);
                    }
                }
            }
        }
    }

    protected Component getIt(Class<? extends ComponentInfo> presenterClass) {
        return this.components.get(presenterClass);
    }

    public <T extends ComponentViewHolder> T create(ComponentInfo componentInfo, ViewGroup root, ActionHandler actionHandler) {
        return (T)((Object)this.createDeep(0, 0, componentInfo.getClass(), componentInfo, root, false, true, actionHandler));
    }

    public <T extends ComponentViewHolder> T createReusable(ComponentInfo componentInfo, ViewGroup root, ActionHandler actionHandler) {
        return (T)((Object)this.createDeep(0, 0, componentInfo.getClass(), componentInfo, root, false, false, actionHandler));
    }

    public <T extends ComponentViewHolder> T createReusable(Class<? extends ComponentInfo> presenterClass, ViewGroup root, ActionHandler actionHandler) {
        return (T)((Object)this.createDeep(0, 0, presenterClass, null, root, false, false, actionHandler));
    }

    public Collection<Class<? extends ComponentInfo>> getRegisteredPresenters() {
        return this.components.keySet();
    }

    public static class Component {
        public Class<? extends ComponentViewHolder> viewHolder;
        public int layout;
        public Class<? extends ComponentInfo> presenter;

        public Component(Class<? extends ComponentInfo> presenter, Class<? extends ComponentViewHolder> viewHolder, int layout) {
            this.layout = layout;
            this.presenter = presenter;
            this.viewHolder = viewHolder;
        }
    }
}

